/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.ExtensionPropertyTranslation;
import org.gbif.ipt.model.factory.CallParamNoNSRule;
import org.gbif.ipt.model.factory.ThesaurusHandlingRule;
import org.gbif.utils.ExtendedResponse;
import org.gbif.utils.HttpClient;
import org.xml.sax.SAXException;

public class ExtensionFactory {
    private static final Logger LOG = LogManager.getLogger(ExtensionFactory.class);
    public static final String EXTENSION_NAMESPACE = "http://rs.gbif.org/extension/";
    private final ThesaurusHandlingRule thesaurusRule;
    private final SAXParserFactory saxf;
    private final HttpClient client;

    public ExtensionFactory(ThesaurusHandlingRule thesaurusRule, SAXParserFactory factory, HttpClient client) {
        this.thesaurusRule = thesaurusRule;
        this.saxf = factory;
        this.client = client;
    }

    public Collection<Extension> build(Collection<String> urls) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (String urlAsString : urls) {
            try {
                Extension e = this.build(urlAsString);
                if (e == null) continue;
                extensions.add(e);
            }
            catch (IOException e) {
                LOG.error("Unable to access extension definition defined at " + urlAsString, (Throwable)e);
            }
            catch (SAXException e) {
                LOG.error("Unable to parse extension definition defined at " + urlAsString, (Throwable)e);
            }
        }
        return extensions;
    }

    public Extension build(InputStream is) throws IOException, SAXException, ParserConfigurationException {
        Digester digester = new Digester(this.saxf.newSAXParser());
        digester.setRuleNamespaceURI(EXTENSION_NAMESPACE);
        Extension e = new Extension();
        digester.push((Object)e);
        digester.addCallMethod("*/extension", "setTitle", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "title"));
        digester.addCallMethod("*/extension", "setName", 1);
        digester.addCallParam("*/extension", 0, "name");
        digester.addCallMethod("*/extension", "setNamespace", 1);
        digester.addCallParam("*/extension", 0, "namespace");
        digester.addCallMethod("*/extension", "setRowType", 1);
        digester.addCallParam("*/extension", 0, "rowType");
        digester.addCallMethod("*/extension", "setIssuedDateAsString", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "issued"));
        digester.addCallMethod("*/extension", "setLink", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "relation"));
        digester.addCallMethod("*/extension", "setDescription", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "description"));
        digester.addCallMethod("*/extension", "setSubject", 1);
        digester.addRule("*/extension", (Rule)new CallParamNoNSRule(0, "subject"));
        digester.addObjectCreate("*/property", ExtensionProperty.class);
        digester.addCallMethod("*/property", "setQualname", 1);
        digester.addCallParam("*/property", 0, "qualName");
        digester.addCallMethod("*/property", "setName", 1);
        digester.addCallParam("*/property", 0, "name");
        digester.addCallMethod("*/property", "setNamespace", 1);
        digester.addCallParam("*/property", 0, "namespace");
        digester.addCallMethod("*/property", "setGroup", 1);
        digester.addCallParam("*/property", 0, "group");
        digester.addCallMethod("*/property", "setRequired", 1);
        digester.addCallParam("*/property", 0, "required");
        digester.addCallMethod("*/property", "setLink", 1);
        digester.addRule("*/property", (Rule)new CallParamNoNSRule(0, "relation"));
        digester.addCallMethod("*/property", "setLabel", 1);
        digester.addCallParam("*/property", 0, "label");
        digester.addCallMethod("*/property", "setDescription", 1);
        digester.addRule("*/property", (Rule)new CallParamNoNSRule(0, "description"));
        digester.addCallMethod("*/property", "setExamples", 1);
        digester.addCallParam("*/property", 0, "examples");
        digester.addCallMethod("*/property", "setComments", 1);
        digester.addCallParam("*/property", 0, "comments");
        digester.addCallMethod("*/property", "setType", 1);
        digester.addCallParam("*/property", 0, "type");
        digester.addObjectCreate("*/property/translation", ExtensionPropertyTranslation.class);
        digester.addSetProperties("*/property/translation");
        digester.addRule("*/property/translation", (Rule)new /* Unavailable Anonymous Inner Class!! */);
        digester.addSetNext("*/property/translation", "addTranslation");
        digester.addRule("*/property", (Rule)this.thesaurusRule);
        digester.addSetNext("*/property", "addProperty");
        digester.parse(is);
        return e;
    }

    public Extension build(String url) throws IOException, SAXException {
        block11: {
            Extension extension;
            block12: {
                ExtendedResponse response = this.client.get(url);
                HttpEntity entity = response.getResponse().getEntity();
                if (entity == null) break block11;
                InputStream is = entity.getContent();
                try {
                    Extension e = this.build(is);
                    LOG.info("Successfully parsed extension: " + e.getTitle());
                    extension = e;
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SAXException e) {
                            LOG.error("Unable to parse XML for extension: " + e.getMessage(), (Throwable)e);
                            EntityUtils.consume((HttpEntity)entity);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                    }
                }
                is.close();
            }
            return extension;
        }
        return null;
    }
}

