/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.datapackage.metadata.camtrap;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CaptureMethod;
import org.gbif.ipt.model.datapackage.metadata.camtrap.ObservationLevel;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Project;
import org.gbif.ipt.validation.ProjectMetadata;
import org.gbif.ipt.validation.ValidUrl;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Project
implements Serializable {
    private static final long serialVersionUID = 926360715052617217L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="title")
    @NotNull(message="validation.input.required", groups={ProjectMetadata.class})
    private @NotNull(message="validation.input.required", groups={ProjectMetadata.class}) String title;
    @JsonProperty(value="acronym")
    private String acronym;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @ValidUrl(message="validation.url.fullyQualified", groups={ProjectMetadata.class})
    private String path;
    @JsonProperty(value="samplingDesign")
    @NotNull(message="validation.input.required", groups={ProjectMetadata.class})
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull(message="validation.input.required", groups={ProjectMetadata.class}) Project.SamplingDesign samplingDesign;
    @JsonProperty(value="captureMethod")
    @JsonDeserialize(using=CaptureMethod.CaptureMethodSetDeserializer.class)
    @NotNull(message="validation.input.required", groups={ProjectMetadata.class})
    @Size(min=1, message="validation.camtrap.metadata.project.captureMethod.size", groups={ProjectMetadata.class})
    @Valid
    private @NotNull(message="validation.input.required", groups={ProjectMetadata.class}) @Size(min=1, message="validation.camtrap.metadata.project.captureMethod.size", groups={ProjectMetadata.class}) @Valid Set<CaptureMethod> captureMethod = new LinkedHashSet();
    @JsonProperty(value="observationLevel")
    @JsonDeserialize(using=ObservationLevel.ObservationLevelSetDeserializer.class)
    @NotNull(message="validation.input.required", groups={ProjectMetadata.class})
    @Size(min=1, message="validation.camtrap.metadata.project.observationLevel.size", groups={ProjectMetadata.class})
    @Valid
    private @NotNull(message="validation.input.required", groups={ProjectMetadata.class}) @Size(min=1, message="validation.camtrap.metadata.project.observationLevel.size", groups={ProjectMetadata.class}) @Valid Set<ObservationLevel> observationLevel = new LinkedHashSet();
    @JsonProperty(value="individualAnimals")
    @NotNull(message="validation.input.required", groups={ProjectMetadata.class})
    private @NotNull(message="validation.input.required", groups={ProjectMetadata.class}) Boolean individualAnimals = false;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap();

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="acronym")
    public String getAcronym() {
        return this.acronym;
    }

    @JsonProperty(value="acronym")
    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="samplingDesign")
    public SamplingDesign getSamplingDesign() {
        return this.samplingDesign;
    }

    @JsonProperty(value="samplingDesign")
    public void setSamplingDesign(SamplingDesign samplingDesign) {
        this.samplingDesign = samplingDesign;
    }

    @JsonProperty(value="captureMethod")
    public Set<CaptureMethod> getCaptureMethod() {
        return this.captureMethod;
    }

    @JsonProperty(value="captureMethod")
    public void setCaptureMethod(Set<CaptureMethod> captureMethod) {
        this.captureMethod = captureMethod;
    }

    @JsonProperty(value="observationLevel")
    public Set<ObservationLevel> getObservationLevel() {
        return this.observationLevel;
    }

    @JsonProperty(value="observationLevel")
    public void setObservationLevel(Set<ObservationLevel> observationLevel) {
        this.observationLevel = observationLevel;
    }

    @JsonProperty(value="individualAnimals")
    public Boolean getIndividualAnimals() {
        return this.individualAnimals;
    }

    @JsonProperty(value="individualAnimals")
    public void setIndividualAnimals(Boolean individualAnimals) {
        this.individualAnimals = individualAnimals;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return new StringJoiner(", ", Project.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("title='" + this.title + "'").add("acronym='" + this.acronym + "'").add("description='" + this.description + "'").add("path=" + this.path).add("samplingDesign=" + String.valueOf(this.samplingDesign)).add("captureMethod=" + String.valueOf(this.captureMethod)).add("observationLevel=" + String.valueOf(this.observationLevel)).add("individualAnimals=" + this.individualAnimals).add("additionalProperties=" + String.valueOf(this.additionalProperties)).toString();
    }
}

