/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.datapackage.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.gbif.ipt.model.datapackage.metadata.Contributor;
import org.gbif.ipt.validation.BasicMetadata;
import org.gbif.ipt.validation.ValidUrl;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FrictionlessContributor
implements Contributor,
Serializable {
    private static final long serialVersionUID = -288140518286006582L;
    @JsonProperty(value="title")
    @NotBlank(message="validation.input.required", groups={BasicMetadata.class})
    private @NotBlank(message="validation.input.required", groups={BasicMetadata.class}) String title;
    @JsonProperty(value="path")
    @ValidUrl(message="validation.url.fullyQualified", groups={BasicMetadata.class})
    @Pattern(regexp="^(?=^[^./~])(^((?!\\.{2}).)*$).*$", groups={BasicMetadata.class})
    private @Pattern(regexp="^(?=^[^./~])(^((?!\\.{2}).)*$).*$", groups={BasicMetadata.class}) String path;
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String email;
    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String organization;
    @JsonProperty(value="role")
    private String role = "contributor";
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap();

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    public void setRole(String role) {
        this.role = role;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return new StringJoiner(", ", FrictionlessContributor.class.getSimpleName() + "[", "]").add("title='" + this.title + "'").add("path='" + this.path + "'").add("email='" + this.email + "'").add("organization='" + this.organization + "'").add("role='" + this.role + "'").add("additionalProperties=" + String.valueOf(this.additionalProperties)).toString();
    }
}

