/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.service.admin.impl.ExtensionsHolder;

public class ExtensionRowTypeConverter
implements Converter {
    private final ExtensionsHolder extensionsHolder;
    private Extension lastExtensionConverted;

    public ExtensionRowTypeConverter(ExtensionsHolder extensionsHolder) {
        this.extensionsHolder = extensionsHolder;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Extension.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Extension e = (Extension)value;
        writer.setValue(e.getRowType());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Extension e;
        this.lastExtensionConverted = e = (Extension)this.extensionsHolder.getExtensionsByRowtype().get(reader.getValue());
        return e;
    }

    public Extension getLastExtensionConverted() {
        return this.lastExtensionConverted;
    }
}

