/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;

public class ExtensionMappingConverter
implements Converter {
    private final ReflectionConverter reflectionConverter;

    public ExtensionMappingConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this.reflectionConverter = new ReflectionConverter(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return ExtensionMapping.class.equals((Object)type);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ExtensionMapping mapping = new ExtensionMapping();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if ("extension".equals(nodeName)) {
                Extension extension = (Extension)context.convertAnother((Object)mapping, Extension.class);
                mapping.setExtension(extension);
                mapping.setExtensionVerbatim(reader.getValue());
            } else {
                Field field = this.findField(ExtensionMapping.class, nodeName);
                if (field != null) {
                    field.setAccessible(true);
                    Object value = context.convertAnother((Object)mapping, field.getType());
                    try {
                        field.set(mapping, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Failed to set field: " + nodeName, e);
                    }
                }
            }
            reader.moveUp();
        }
        return mapping;
    }

    private Field findField(Class<?> clazz, String name) {
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        this.reflectionConverter.marshal(source, writer, context);
    }
}

