/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model.converter;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.UnknownTerm;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.converter.ExtensionRowTypeConverter;

public class ConceptTermConverter
implements Converter {
    private static final Logger LOG = LogManager.getLogger(ConceptTermConverter.class);
    private final ExtensionRowTypeConverter extConverter;

    public ConceptTermConverter(ExtensionRowTypeConverter extConverter) {
        this.extConverter = extConverter;
    }

    public boolean canConvert(Class clazz) {
        return Term.class.isAssignableFrom(clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Term t = (Term)value;
        writer.setValue(t.qualifiedName());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Extension extension = this.extConverter.getLastExtensionConverted();
        ExtensionProperty t = null;
        if (extension != null) {
            t = extension.getProperty(reader.getValue());
        }
        if (t == null) {
            LOG.warn("Cant unmarshall concept " + reader.getValue());
            t = UnknownTerm.build((String)reader.getValue(), (String)reader.getValue());
        }
        return t;
    }
}

