/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.model.User;

public class User
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3832626162173359411L;
    private String email;
    private String password;
    private String firstname;
    private String lastname;
    private Role role = Role.User;
    private Date lastLogin;

    public Object clone() throws CloneNotSupportedException {
        User clone = (User)super.clone();
        if (clone != null && this.getLastLogin() != null) {
            clone.setLastLogin((Date)this.getLastLogin().clone());
        }
        return clone;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof User)) {
            return false;
        }
        User o = (User)other;
        return Objects.equals(this.email, o.email);
    }

    @NotNull
    public String getEmail() {
        return this.email;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public String getLastname() {
        return this.lastname;
    }

    public String getName() {
        return StringUtils.trimToNull((String)(StringUtils.trimToEmpty((String)this.firstname) + " " + StringUtils.trimToEmpty((String)this.lastname)));
    }

    public String getInitials() {
        Object initials = "A";
        if (StringUtils.isNotEmpty((CharSequence)this.firstname) && StringUtils.isNotEmpty((CharSequence)this.lastname)) {
            initials = "" + this.firstname.charAt(0) + this.lastname.charAt(0);
        }
        return ((String)initials).toUpperCase();
    }

    public String getNameWithEmail() {
        return StringUtils.trimToNull((String)(this.getName() + " <" + this.email + ">"));
    }

    public String getPassword() {
        return this.password;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean hasAdminRights() {
        return Role.Admin == this.role;
    }

    public int hashCode() {
        return Objects.hashCode(this.email);
    }

    public boolean hasManagerRights() {
        return Role.User != this.role;
    }

    public boolean hasRegistrationRights() {
        return Role.Publisher == this.role || Role.Admin == this.role;
    }

    public void setEmail(String email) {
        if (email != null) {
            email = email.toLowerCase().trim();
        }
        this.email = email;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public void setLastLoginToNow() {
        this.lastLogin = new Date();
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRole(Role role) {
        this.role = role == null ? Role.User : role;
    }

    public String toString() {
        return "User " + this.email;
    }
}

