/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.RowIterable;
import org.gbif.ipt.model.SourceBase;
import org.gbif.ipt.model.SourceType;
import org.gbif.ipt.model.SourceWithHeader;
import org.gbif.ipt.utils.FileUtils;
import org.gbif.utils.file.ClosableReportingIterator;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.CSVReaderFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class UrlSource
extends SourceBase
implements RowIterable,
SourceWithHeader {
    private static final long serialVersionUID = 5509301114753152587L;
    private static final Logger LOG = LogManager.getLogger(UrlSource.class);
    private URI url;
    private String fieldsTerminatedBy = "\t";
    private String fieldsEnclosedBy;
    private int ignoreHeaderLines = 0;
    private File file;
    private long fileSize;
    private int rows;
    protected Date lastModified;

    public String getFieldsEnclosedByEscaped() {
        return this.escape(this.fieldsEnclosedBy);
    }

    public String getFieldsTerminatedByEscaped() {
        return this.escape(this.fieldsTerminatedBy);
    }

    public int getIgnoreHeaderLines() {
        return this.ignoreHeaderLines;
    }

    public String formattedFileSize(String locale) {
        return FileUtils.formatSize((long)this.fileSize, (int)1, (String)locale, (boolean)false);
    }

    public void setFieldsEnclosedByEscaped(String fieldsEnclosedBy) {
        this.fieldsEnclosedBy = this.unescape(fieldsEnclosedBy);
    }

    public void setFieldsTerminatedByEscaped(String fieldsTerminatedBy) {
        this.fieldsTerminatedBy = this.unescape(fieldsTerminatedBy);
    }

    public void setIgnoreHeaderLines(Integer ignoreHeaderLines) {
        this.ignoreHeaderLines = ignoreHeaderLines == null ? 0 : ignoreHeaderLines;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public SourceType getSourceType() {
        return SourceType.URL;
    }

    public Character getFieldQuoteChar() {
        if (this.fieldsEnclosedBy == null || this.fieldsEnclosedBy.isEmpty()) {
            return null;
        }
        return Character.valueOf(this.fieldsEnclosedBy.charAt(0));
    }

    public ClosableReportingIterator<String[]> rowIterator() {
        try {
            return this.getReader();
        }
        catch (IOException e) {
            LOG.warn("Exception caught", (Throwable)e);
            return null;
        }
    }

    public static InputStream decompressInputStream(InputStream inputStream) throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream(8192);
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        Thread producerThread = new Thread(() -> {
            try (ZipInputStream zipStream = new ZipInputStream(inputStream);
                 PipedOutputStream out = pipedOutputStream;){
                int bytesRead;
                ZipEntry firstEntry = zipStream.getNextEntry();
                if (firstEntry == null) {
                    LOG.error("Exception while reading zipped URL source: no entries in the archive");
                    throw new IOException("Exception while reading zipped URL source: no entries in the archive");
                }
                LOG.debug("Reading file {} from archive", (Object)firstEntry.getName());
                byte[] buffer = new byte[8192];
                while ((bytesRead = zipStream.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                LOG.error("Exception during decompression", (Throwable)e);
            }
            finally {
                try {
                    pipedOutputStream.close();
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error("Error closing PipedOutputStream", (Throwable)e);
                }
            }
        });
        producerThread.start();
        return pipedInputStream;
    }

    private CSVReader getReader() throws IOException {
        InputStream input = this.url.toString().endsWith("zip") ? UrlSource.decompressInputStream((InputStream)this.url.toURL().openStream()) : this.url.toURL().openStream();
        return CSVReaderFactory.build((InputStream)input, (String)this.encoding, (String)this.fieldsTerminatedBy, (Character)this.getFieldQuoteChar(), (Integer)this.ignoreHeaderLines);
    }

    public List<String> columns() {
        List<String> columns = new ArrayList<String>();
        try (CSVReader reader = this.getReader();){
            if (this.ignoreHeaderLines > 0 && reader.header != null) {
                columns = Arrays.asList(reader.header);
            } else {
                int numColumns = reader.header == null ? 0 : reader.header.length;
                for (int x = 1; x <= numColumns; ++x) {
                    columns.add("Column #" + x);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Can't read source {}", (Object)this.getName(), (Object)e);
        }
        return columns;
    }

    public Set<Integer> analyze() throws IOException {
        boolean newFileCreated;
        LOG.debug("Analyzing URL source {}", (Object)this.url);
        Set<Integer> emptyLines = new HashSet<Integer>();
        if (!this.file.exists() && !(newFileCreated = this.file.createNewFile())) {
            LOG.error("Failed to create new file {}", (Object)this.file);
            this.setReadable(false);
            return emptyLines;
        }
        this.setFile(this.file);
        this.setFileSize(this.file.length());
        CSVReader reader = CSVReaderFactory.build((File)this.file, (String)this.getEncoding(), (String)this.getFieldsTerminatedBy(), (Character)this.getFieldQuoteChar(), (Integer)this.getIgnoreHeaderLines());
        while (reader.hasNext()) {
            reader.next();
        }
        this.setColumns(reader.header == null ? 0 : reader.header.length);
        this.setRows(reader.getReadRows());
        this.setReadable(true);
        emptyLines = reader.getEmptyLines();
        reader.close();
        return emptyLines;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setFieldsTerminatedBy(String fieldsTerminatedBy) {
        this.fieldsTerminatedBy = fieldsTerminatedBy;
    }

    public String getFieldsTerminatedBy() {
        return this.fieldsTerminatedBy;
    }

    public void setFieldsEnclosedBy(String fieldsEnclosedBy) {
        this.fieldsEnclosedBy = fieldsEnclosedBy;
    }

    public String getFieldsEnclosedBy() {
        return this.fieldsEnclosedBy;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }

    public Date getLastModified() {
        return this.lastModified;
    }
}

