/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.model.FileSource;
import org.gbif.ipt.model.SourceBase;
import org.gbif.ipt.model.SourceType;
import org.gbif.ipt.utils.FileUtils;
import org.gbif.utils.file.ClosableReportingIterator;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.CSVReaderFactory;

public class TextFileSource
extends SourceBase
implements FileSource {
    private static final Logger LOG = LogManager.getLogger(TextFileSource.class);
    private static final String SUFFIX = ".txt";
    private String fieldsTerminatedBy = "\t";
    private String fieldsEnclosedBy;
    private int ignoreHeaderLines = 0;
    private File file;
    private long fileSize;
    private int rows;
    protected Date lastModified;

    public Character getFieldQuoteChar() {
        if (this.fieldsEnclosedBy == null || this.fieldsEnclosedBy.length() == 0) {
            return null;
        }
        return Character.valueOf(this.fieldsEnclosedBy.charAt(0));
    }

    public String getFieldsEnclosedBy() {
        return this.fieldsEnclosedBy;
    }

    public String getFieldsEnclosedByEscaped() {
        return this.escape(this.fieldsEnclosedBy);
    }

    public String getFieldsTerminatedBy() {
        return this.fieldsTerminatedBy;
    }

    public String getFieldsTerminatedByEscaped() {
        return this.escape(this.fieldsTerminatedBy);
    }

    public File getFile() {
        return this.file;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String formattedFileSize(String locale) {
        return FileUtils.formatSize((long)this.fileSize, (int)1, (String)locale, (boolean)false);
    }

    public int getIgnoreHeaderLines() {
        return this.ignoreHeaderLines;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    private CSVReader getReader() throws IOException {
        return CSVReaderFactory.build((File)this.file, (String)this.encoding, (String)this.fieldsTerminatedBy, (Character)this.getFieldQuoteChar(), (Integer)this.ignoreHeaderLines);
    }

    public int getRows() {
        return this.rows;
    }

    public ClosableReportingIterator<String[]> rowIterator() {
        try {
            return this.getReader();
        }
        catch (IOException e) {
            LOG.warn("Exception caught", (Throwable)e);
            return null;
        }
    }

    public List<String> columns() {
        try {
            CSVReader reader = this.getReader();
            if (this.ignoreHeaderLines > 0) {
                List<String> columns = Arrays.asList(reader.header);
                reader.close();
                return columns;
            }
            ArrayList<String> columns = new ArrayList<String>();
            int numColumns = reader.header == null ? 0 : reader.header.length;
            for (int x = 1; x <= numColumns; ++x) {
                columns.add("Column #" + x);
            }
            reader.close();
            return columns;
        }
        catch (IOException e) {
            LOG.warn("Cant read source " + this.getName(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public void setFieldsEnclosedBy(String fieldsEnclosedBy) {
        this.fieldsEnclosedBy = fieldsEnclosedBy;
    }

    public void setFieldsEnclosedByEscaped(String fieldsEnclosedBy) {
        this.fieldsEnclosedBy = this.unescape(fieldsEnclosedBy);
    }

    public void setFieldsTerminatedBy(String fieldsTerminatedBy) {
        this.fieldsTerminatedBy = fieldsTerminatedBy;
    }

    public void setFieldsTerminatedByEscaped(String fieldsTerminatedBy) {
        this.fieldsTerminatedBy = this.unescape(fieldsTerminatedBy);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setIgnoreHeaderLines(Integer ignoreHeaderLines) {
        this.ignoreHeaderLines = ignoreHeaderLines == null ? 0 : ignoreHeaderLines;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getPreferredFileSuffix() {
        return SUFFIX;
    }

    public Set<Integer> analyze() throws IOException {
        this.setFileSize(this.getFile().length());
        CSVReader reader = this.getReader();
        while (reader.hasNext()) {
            reader.next();
        }
        this.setColumns(reader.header == null ? 0 : reader.header.length);
        this.setRows(reader.getReadRows());
        this.setReadable(true);
        Set emptyLines = reader.getEmptyLines();
        reader.close();
        return emptyLines;
    }

    public SourceType getSourceType() {
        return SourceType.TEXT_FILE;
    }
}

