/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.model.ExcelFileSource;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.model.SqlSource;
import org.gbif.ipt.model.TextFileSource;
import org.gbif.ipt.model.UrlSource;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SourceBase
implements Comparable<Source>,
Serializable,
Source {
    private static final long serialVersionUID = 119920000112L;
    protected Resource resource;
    protected String name;
    protected String encoding = "UTF-8";
    protected String multiValueFieldsDelimitedBy;
    protected String dateFormat = "YYYY-MM-DD";
    protected int columns;
    protected boolean readable = false;
    protected boolean processing = false;

    public static String normaliseName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return StringUtils.substringBeforeLast((String)name, (String)".").replaceAll("[\\s.:/\\\\*?%|><\"]+", "").toLowerCase();
    }

    @Override
    public int compareTo(Source o) {
        if (this == o) {
            return 0;
        }
        if (this.name == null) {
            return -1;
        }
        return this.name.compareTo(o.getName());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SourceBase)) {
            return false;
        }
        Source o = (Source)other;
        return Objects.equals(this.name, o.getName());
    }

    public int getColumns() {
        return this.columns;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMultiValueFieldsDelimitedBy() {
        return this.multiValueFieldsDelimitedBy;
    }

    public String getName() {
        return this.name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    public boolean isFileSource() {
        return this instanceof TextFileSource;
    }

    public boolean isExcelSource() {
        return this instanceof ExcelFileSource;
    }

    public boolean isSqlSource() {
        return this instanceof SqlSource;
    }

    public boolean isUrlSource() {
        return this instanceof UrlSource;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMultiValueFieldsDelimitedBy(String multiValueFieldsDelimitedBy) {
        this.multiValueFieldsDelimitedBy = multiValueFieldsDelimitedBy;
    }

    public void setName(String name) {
        this.name = SourceBase.normaliseName((String)name);
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public void setProcessing(boolean processing) {
        this.processing = processing;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + ";" + String.valueOf(this.resource) + "]";
    }

    protected String escape(String x) {
        if (x == null) {
            return null;
        }
        return x.replaceAll("\\t", "\\\\t").replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r").replaceAll("\\f", "\\\\f");
    }

    protected String unescape(String x) {
        if (x == null) {
            return null;
        }
        return x.replaceAll("\\\\t", String.valueOf('\t')).replaceAll("\\\\n", String.valueOf('\n')).replaceAll("\\\\r", String.valueOf('\r')).replaceAll("\\\\f", String.valueOf('\f'));
    }
}

