/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.model.common.DOI;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.model.BiMonthEnum;
import org.gbif.ipt.model.DataPackageMapping;
import org.gbif.ipt.model.DayEnum;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.InferredEmlMetadata;
import org.gbif.ipt.model.InferredMetadata;
import org.gbif.ipt.model.MonthEnum;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.model.SourceBase;
import org.gbif.ipt.model.User;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapContributor;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapLicense;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapMetadata;
import org.gbif.ipt.model.voc.IdentifierStatus;
import org.gbif.ipt.model.voc.PublicationMode;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.utils.ResourceUtils;
import org.gbif.metadata.eml.ipt.model.Agent;
import org.gbif.metadata.eml.ipt.model.Citation;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.MaintenanceUpdateFrequency;

public class Resource
implements Serializable,
Comparable<Resource> {
    private static final Logger LOG = LogManager.getLogger(Resource.class);
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private static final long serialVersionUID = 3832626162173352190L;
    private String shortname;
    private Eml eml = new Eml();
    private DataPackageMetadata dataPackageMetadata = new FrictionlessMetadata();
    private String coreType;
    private String subtype;
    private MaintenanceUpdateFrequency updateFrequency;
    private MonthEnum updateFrequencyMonth;
    private BiMonthEnum updateFrequencyBiMonth;
    private Integer updateFrequencyDay;
    private DayEnum updateFrequencyDayOfWeek;
    private Integer updateFrequencyHour;
    private Integer updateFrequencyMinute;
    private PublicationStatus status = PublicationStatus.PRIVATE;
    private PublicationMode publicationMode;
    private boolean citationAutoGenerated;
    private boolean inferGeocoverageAutomatically = false;
    private boolean inferTaxonomicCoverageAutomatically = false;
    private boolean inferTemporalCoverageAutomatically = false;
    private InferredMetadata inferredMetadata = new InferredEmlMetadata();
    private BigDecimal emlVersion;
    private BigDecimal dataPackageMetadataVersion;
    private BigDecimal replacedEmlVersion;
    private BigDecimal replacedDataPackageMetadataVersion;
    private Date lastPublished;
    private Date nextPublished;
    private Date makePublicDate;
    private int recordsPublished = 0;
    private Map<String, Integer> recordsByExtension = new HashMap();
    private UUID key;
    private Organisation organisation;
    private User creator;
    private Date created;
    private User modifier;
    private Date modified;
    private Date metadataModified;
    private Date mappingsModified;
    private Date sourcesModified;
    private Set<User> managers = new HashSet();
    private Set<Source> sources = new HashSet();
    private List<ExtensionMapping> mappings = new ArrayList();
    private List<DataPackageMapping> dataPackageMappings = new ArrayList();
    private String dataPackageIdentifier;
    private String changeSummary;
    private List<VersionHistory> versionHistory = new ArrayList();
    private IdentifierStatus identifierStatus = IdentifierStatus.UNRESERVED;
    private DOI doi;
    private UUID doiOrganisationKey;
    private String lastPublishedArchiveChecksum;
    private boolean skipPublicationIfNotChanged = false;
    private boolean skipPublicationIfRecordsDrop = false;
    private int recordsDropThreshold = 10;

    public void addManager(User manager) {
        if (manager != null) {
            this.managers.add(manager);
        }
    }

    public void addVersionHistory(VersionHistory history) {
        Objects.requireNonNull(history);
        boolean exists = false;
        for (VersionHistory vh : this.getVersionHistory()) {
            if (!vh.getVersion().equals(history.getVersion())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            LOG.debug("Adding new version history: " + history.getVersion());
            this.versionHistory.add(0, history);
        }
    }

    public void removeVersionHistory(BigDecimal version) {
        if (version != null) {
            Iterator iter = this.getVersionHistory().iterator();
            while (iter.hasNext()) {
                BigDecimal historyVersion = new BigDecimal(((VersionHistory)iter.next()).getVersion());
                if (version.compareTo(historyVersion) != 0) continue;
                iter.remove();
            }
        }
    }

    public VersionHistory findVersionHistory(BigDecimal version) {
        if (version != null) {
            for (VersionHistory vh : this.getVersionHistory()) {
                if (!version.toPlainString().equals(new BigDecimal(vh.getVersion()).toPlainString())) continue;
                return vh;
            }
        }
        return null;
    }

    public Integer addMapping(@Nullable ExtensionMapping mapping) throws IllegalArgumentException {
        if (mapping != null && mapping.getExtension() != null) {
            if (!mapping.isCore() && !this.hasCore()) {
                throw new IllegalArgumentException("Cannot add extension mapping before a core mapping exists");
            }
            Integer index = this.getMappings(mapping.getExtension().getRowType()).size();
            this.mappings.add(mapping);
            return index;
        }
        return null;
    }

    public Integer addDataPackageMapping(@Nullable DataPackageMapping mapping) {
        if (mapping != null && mapping.getDataPackageSchema() != null) {
            Integer index = this.getDataPackageMappings().size();
            this.dataPackageMappings.add(mapping);
            return index;
        }
        return null;
    }

    public void addSource(Source src, boolean allowOverwrite) throws AlreadyExistingException {
        src.setResource(this);
        if (!allowOverwrite && this.sources.contains(src)) {
            throw new AlreadyExistingException();
        }
        if (allowOverwrite && this.sources.contains(src)) {
            this.sources.remove(src);
            for (ExtensionMapping ext : this.getMappings()) {
                if (!ext.getSource().equals(src)) continue;
                ext.setSource(src);
            }
        }
        this.sources.add(src);
    }

    @Override
    public int compareTo(Resource o) {
        return this.shortname.compareToIgnoreCase(o.shortname);
    }

    public boolean deleteMapping(ExtensionMapping mapping) {
        if (mapping != null && this.mappings.contains(mapping)) {
            String coreRowType = this.getCoreRowType();
            if (coreRowType != null && coreRowType.equalsIgnoreCase(mapping.getExtension().getRowType())) {
                List coreMappings = this.getMappings(coreRowType);
                if (coreMappings.size() > 1) {
                    if (this.mappings.indexOf(mapping) == 0) {
                        ExtensionMapping next = (ExtensionMapping)coreMappings.get(1);
                        int nextIndex = this.mappings.indexOf(next);
                        LOG.debug("Swapping first core mapping with next core mapping with index#" + nextIndex);
                        Collections.swap(this.mappings, 0, nextIndex);
                    }
                    LOG.debug("Deleting core mapping...");
                    return this.mappings.remove(mapping);
                }
                LOG.debug("Deleting only core mapping and thus clearing all mappings...");
                this.mappings.clear();
                return true;
            }
            LOG.debug("Deleting non-core mapping...");
            return this.mappings.remove(mapping);
        }
        LOG.debug("Mapping was null, or resource no longer has this mapping, thus it could not be deleted!");
        return false;
    }

    public boolean deleteMapping(DataPackageMapping mapping) {
        if (mapping != null && this.dataPackageMappings.contains(mapping)) {
            return this.dataPackageMappings.remove(mapping);
        }
        LOG.debug("Data Package Mapping was null, or resource no longer has this mapping, thus it could not be deleted!");
        return false;
    }

    public boolean deleteSource(Source src) {
        boolean result = false;
        if (src != null) {
            result = this.sources.remove(src);
            ArrayList ems = new ArrayList(this.mappings);
            for (ExtensionMapping em : ems) {
                if (em.getSource() == null || !src.equals(em.getSource())) continue;
                this.deleteMapping(em);
                LOG.debug("Cascading source delete to mapping " + em.getExtension().getTitle());
            }
            ArrayList dpms = new ArrayList(this.dataPackageMappings);
            for (DataPackageMapping dpm : dpms) {
                if (dpm.getSource() == null || !src.equals(dpm.getSource())) continue;
                this.deleteMapping(dpm);
                LOG.debug("Cascading source delete to data package mapping " + dpm.getDataPackageSchema().getName());
            }
        }
        return result;
    }

    public boolean hasMappedSource(Source src) {
        if (src != null) {
            for (ExtensionMapping em : new ArrayList(this.mappings)) {
                if (em.getSource() == null || !src.equals(em.getSource())) continue;
                LOG.debug("Source mapped to " + em.getExtension().getTitle());
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Resource)) {
            return false;
        }
        Resource o = (Resource)other;
        return Objects.equals(this.shortname, o.shortname);
    }

    public List<ExtensionMapping> getCoreMappings() {
        ArrayList<ExtensionMapping> cores = new ArrayList<ExtensionMapping>();
        String coreRowType = this.getCoreRowType();
        for (ExtensionMapping m : this.mappings) {
            if (!m.isCore() || coreRowType == null || !coreRowType.equalsIgnoreCase(m.getExtension().getRowType())) continue;
            cores.add(m);
        }
        return cores;
    }

    @Nullable
    public String getCoreRowType() {
        for (ExtensionMapping m : this.mappings) {
            if (!m.isCore()) continue;
            return m.getExtension().getRowType();
        }
        return null;
    }

    @Nullable
    public String getDataPackageIdentifier() {
        return this.dataPackageIdentifier;
    }

    public void setDataPackageIdentifier(String dataPackageIdentifier) {
        this.dataPackageIdentifier = dataPackageIdentifier;
    }

    @Nullable
    public String getCoreType() {
        String coreRowType = this.getCoreRowType();
        if (coreRowType != null) {
            this.coreType = coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_TAXON) ? StringUtils.capitalize((String)CoreRowType.CHECKLIST.toString()) : (coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_OCCURRENCE) ? StringUtils.capitalize((String)CoreRowType.OCCURRENCE.toString()) : (coreRowType.equalsIgnoreCase(Constants.DWC_ROWTYPE_EVENT) ? StringUtils.capitalize((String)CoreRowType.SAMPLINGEVENT.toString()) : (coreRowType.equalsIgnoreCase("http://rs.tdwg.org/dwc/terms/MaterialEntity") ? StringUtils.capitalize((String)CoreRowType.MATERIALENTITY.toString()) : StringUtils.capitalize((String)CoreRowType.OTHER.toString()))));
        }
        return this.coreType;
    }

    public Term getCoreTypeTerm() {
        List cores = this.getCoreMappings();
        if (!cores.isEmpty()) {
            return TERM_FACTORY.findTerm(((ExtensionMapping)cores.get(0)).getExtension().getRowType());
        }
        return null;
    }

    public String getDataPackageType() {
        return this.coreType;
    }

    public Date getCreated() {
        return this.created;
    }

    @NotNull
    public User getCreator() {
        return this.creator;
    }

    public Eml getEml() {
        return this.eml;
    }

    public DataPackageMetadata getDataPackageMetadata() {
        return this.dataPackageMetadata;
    }

    @NotNull
    public BigDecimal getEmlVersion() {
        return this.emlVersion == null ? this.eml.getEmlVersion() : this.emlVersion;
    }

    @NotNull
    public BigDecimal getDataPackageMetadataVersion() {
        try {
            if (this.dataPackageMetadataVersion == null) {
                if (this.dataPackageMetadata.getVersion() != null) {
                    return new BigDecimal(this.dataPackageMetadata.getVersion());
                }
                return new BigDecimal("1.0");
            }
            return this.dataPackageMetadataVersion;
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse version: {}", (Object)this.dataPackageMetadata.getVersion());
            return new BigDecimal("1.0");
        }
    }

    @NotNull
    public BigDecimal getMetadataVersion() {
        return this.dataPackageIdentifier != null ? this.getDataPackageMetadataVersion() : this.getEmlVersion();
    }

    @NotNull
    public BigDecimal getNextVersion() {
        if (this.isDataPackage()) {
            return this.getNextVersionForDataPackage();
        }
        return this.getNextVersionForEml();
    }

    private BigDecimal getNextVersionForDataPackage() {
        String versionAsString = Optional.ofNullable(this.getDataPackageMetadata()).map(DataPackageMetadata::getVersion).orElse("1");
        boolean isVersionContainsDot = versionAsString.contains(".");
        if (this.lastPublished == null) {
            BigDecimal nextVersion;
            try {
                nextVersion = isVersionContainsDot ? new BigDecimal(versionAsString.substring(0, versionAsString.indexOf("."))) : new BigDecimal(versionAsString);
            }
            catch (NumberFormatException e) {
                LOG.error("Invalid version number: {}. Setting version to 1", (Object)versionAsString);
                nextVersion = new BigDecimal("1");
            }
            return nextVersion;
        }
        int majorVersion = isVersionContainsDot ? Integer.parseInt(versionAsString.substring(0, versionAsString.indexOf("."))) : Integer.parseInt(versionAsString);
        return new BigDecimal(majorVersion + 1);
    }

    private BigDecimal getNextVersionForEml() {
        if (this.lastPublished == null) {
            return this.getEml().getEmlVersion();
        }
        if (this.doi != null && this.identifierStatus == IdentifierStatus.PUBLIC_PENDING_PUBLICATION) {
            if (!(this.isAlreadyAssignedDoi() || this.status != PublicationStatus.PUBLIC && this.status != PublicationStatus.REGISTERED)) {
                return this.getEml().getNextEmlVersionAfterMajorVersionChange();
            }
            if (this.isAlreadyAssignedDoi()) {
                return this.getEml().getNextEmlVersionAfterMajorVersionChange();
            }
        }
        return this.getEml().getNextEmlVersionAfterMinorVersionChange();
    }

    public String getNextVersionPlainString() {
        return this.getNextVersion().toPlainString();
    }

    public boolean isAlreadyAssignedDoi() {
        VersionHistory last = this.getLastPublishedVersion();
        if (last != null) {
            DOI doi = last.getDoi();
            IdentifierStatus status = last.getStatus();
            return doi != null && status == IdentifierStatus.PUBLIC;
        }
        return false;
    }

    @Nullable
    public DOI getAssignedDoi() {
        VersionHistory last = this.getLastPublishedVersion();
        if (this.isAlreadyAssignedDoi() && last != null) {
            return last.getDoi();
        }
        return null;
    }

    @Nullable
    public BigDecimal getLastPublishedVersionsVersion() {
        VersionHistory last = this.getLastPublishedVersion();
        if (last != null) {
            return new BigDecimal(last.getVersion());
        }
        return null;
    }

    @Nullable
    public String getLastPublishedVersionsChangeSummary() {
        VersionHistory last = this.getLastPublishedVersion();
        if (last != null) {
            return StringUtils.trimToNull((String)last.getChangeSummary());
        }
        return null;
    }

    @NotNull
    public PublicationStatus getLastPublishedVersionsPublicationStatus() {
        VersionHistory last = this.getLastPublishedVersion();
        if (last != null) {
            return last.getPublicationStatus();
        }
        if (this.status.equals((Object)PublicationStatus.REGISTERED)) {
            return PublicationStatus.REGISTERED;
        }
        return PublicationStatus.PRIVATE;
    }

    @Nullable
    public VersionHistory getLastPublishedVersion() {
        for (VersionHistory vh : this.getVersionHistory()) {
            if (vh.getReleased() == null) continue;
            return vh;
        }
        return null;
    }

    @Nullable
    public BigDecimal getLastVersionHistoryVersion() {
        if (!this.getVersionHistory().isEmpty()) {
            return new BigDecimal(((VersionHistory)this.getVersionHistory().get(0)).getVersion());
        }
        return null;
    }

    public UUID getKey() {
        return this.key;
    }

    public Date getLastPublished() {
        return this.lastPublished;
    }

    public Date getNextPublished() {
        return this.nextPublished;
    }

    public Set<User> getManagers() {
        return this.managers;
    }

    public List<Extension> getMappedExtensions() {
        LinkedHashSet<Extension> extensions = new LinkedHashSet<Extension>();
        for (ExtensionMapping em : this.mappings) {
            if (em.getExtension() != null && em.getSource() != null) {
                extensions.add(em.getExtension());
                continue;
            }
            LOG.error("ExtensionMapping referencing NULL Extension or Source for resource: " + this.getShortname());
        }
        return new ArrayList<Extension>(extensions);
    }

    public ExtensionMapping getMapping(String rowType, Integer index) {
        List maps;
        if (rowType != null && index != null && (maps = this.getMappings(rowType)).size() >= index) {
            return (ExtensionMapping)maps.get(index);
        }
        return null;
    }

    public DataPackageMapping getDataPackageMapping(Integer index) {
        List maps;
        if (index != null && (maps = this.getDataPackageMappings()).size() >= index) {
            return (DataPackageMapping)maps.get(index);
        }
        return null;
    }

    public List<ExtensionMapping> getMappings() {
        return this.mappings;
    }

    public List<ExtensionMapping> getMappings(String rowType) {
        ArrayList<ExtensionMapping> maps = new ArrayList<ExtensionMapping>();
        if (rowType != null) {
            for (ExtensionMapping m : this.mappings) {
                if (!rowType.equals(m.getExtension().getRowType())) continue;
                maps.add(m);
            }
        }
        return maps;
    }

    public List<DataPackageMapping> getDataPackageMappings() {
        ArrayList<DataPackageMapping> maps = new ArrayList<DataPackageMapping>();
        if (this.dataPackageMappings == null) {
            this.dataPackageMappings = new ArrayList();
        }
        if (this.dataPackageIdentifier != null) {
            for (DataPackageMapping m : this.dataPackageMappings) {
                if (!this.dataPackageIdentifier.equals(m.getDataPackageSchema().getIdentifier())) continue;
                maps.add(m);
            }
        }
        return maps;
    }

    public Date getModified() {
        return this.modified;
    }

    public User getModifier() {
        return this.modifier;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public int getRecordsPublished() {
        return this.recordsPublished;
    }

    public String getShortname() {
        return this.shortname;
    }

    public Source getSource(String name) {
        if (name == null) {
            return null;
        }
        name = SourceBase.normaliseName((String)name);
        for (Source s : this.sources) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public List<Source> getSources() {
        return this.sources.stream().sorted(Comparator.nullsLast((first, last) -> StringUtils.compare((String)first.getName(), (String)last.getName(), (boolean)false))).collect(Collectors.toList());
    }

    @NotNull
    public PublicationStatus getStatus() {
        return this.status;
    }

    @NotNull
    public IdentifierStatus getIdentifierStatus() {
        return this.identifierStatus;
    }

    public void setIdentifierStatus(@NotNull IdentifierStatus identifierStatus) {
        this.identifierStatus = identifierStatus;
    }

    @Nullable
    public DOI getDoi() {
        return this.doi;
    }

    public void setDoi(@Nullable DOI doi) {
        this.doi = doi;
    }

    @Nullable
    public UUID getDoiOrganisationKey() {
        return this.doiOrganisationKey;
    }

    public void setDoiOrganisationKey(@Nullable UUID doiOrganisationKey) {
        this.doiOrganisationKey = doiOrganisationKey;
    }

    public PublicationMode getPublicationMode() {
        return this.publicationMode == null ? PublicationMode.AUTO_PUBLISH_OFF : this.publicationMode;
    }

    public String getSubtype() {
        return this.subtype;
    }

    @Nullable
    public MaintenanceUpdateFrequency getUpdateFrequency() {
        return this.updateFrequency;
    }

    public MonthEnum getUpdateFrequencyMonth() {
        return this.updateFrequencyMonth;
    }

    public BiMonthEnum getUpdateFrequencyBiMonth() {
        return this.updateFrequencyBiMonth;
    }

    public Integer getUpdateFrequencyDay() {
        return this.updateFrequencyDay;
    }

    public DayEnum getUpdateFrequencyDayOfWeek() {
        return this.updateFrequencyDayOfWeek;
    }

    public Integer getUpdateFrequencyHour() {
        return this.updateFrequencyHour;
    }

    public Integer getUpdateFrequencyMinute() {
        return this.updateFrequencyMinute;
    }

    public String getTitle() {
        if (this.dataPackageIdentifier != null && this.dataPackageMetadata != null) {
            return this.dataPackageMetadata.getTitle();
        }
        if (this.eml != null) {
            return this.eml.getTitle();
        }
        return null;
    }

    public String getTitleAndShortname() {
        StringBuilder sb = new StringBuilder();
        if (this.dataPackageIdentifier != null && this.dataPackageMetadata != null) {
            sb.append(this.dataPackageMetadata.getTitle());
            if (!this.shortname.equalsIgnoreCase(this.dataPackageMetadata.getTitle())) {
                sb.append(" (").append(this.shortname).append(")");
            }
        } else if (this.eml != null) {
            sb.append(this.eml.getTitle());
            if (!this.shortname.equalsIgnoreCase(this.eml.getTitle())) {
                sb.append(" (").append(this.shortname).append(")");
            }
        }
        return sb.toString();
    }

    public String getLogoUrl() {
        if (this.isDataPackage() && this.dataPackageMetadata != null) {
            return this.dataPackageMetadata.getImage();
        }
        if (this.eml != null) {
            return this.eml.getLogoUrl();
        }
        return null;
    }

    public String getSubject() {
        if (this.eml != null) {
            return this.eml.getSubject();
        }
        return null;
    }

    public String getOrganisationName() {
        if (this.organisation != null) {
            return this.organisation.getName();
        }
        return null;
    }

    public String getOrganisationAlias() {
        if (this.organisation != null) {
            return this.organisation.getAlias();
        }
        return null;
    }

    public String getCreatorName() {
        if (this.creator != null) {
            return this.creator.getName();
        }
        return null;
    }

    public boolean hasCore() {
        return this.getCoreTypeTerm() != null;
    }

    public int hashCode() {
        return Objects.hashCode(this.shortname);
    }

    public boolean hasAnyMappedData() {
        if (this.isDataPackage()) {
            return this.hasSchemaMappedData();
        }
        return this.hasMappedData();
    }

    public boolean hasMappedData() {
        for (ExtensionMapping cm : this.getCoreMappings()) {
            if (cm.getFields().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSchemaMappedData() {
        for (DataPackageMapping dpm : this.getDataPackageMappings()) {
            if (dpm.getFields().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPublishedData() {
        return this.recordsPublished > 0;
    }

    public boolean isPublished() {
        return this.lastPublished != null;
    }

    public boolean isLastPublishedVersionPublic() {
        VersionHistory last = this.getLastPublishedVersion();
        if (last != null) {
            return last.getPublicationStatus().equals((Object)PublicationStatus.PUBLIC);
        }
        return false;
    }

    public boolean isAssignedGBIFSupportedLicense() {
        if (this.isDataPackage()) {
            if ("camtrap-dp".equals(this.coreType)) {
                CamtrapMetadata camtrapMetadata = (CamtrapMetadata)this.dataPackageMetadata;
                Optional<CamtrapLicense> dataLicenseWrapped = camtrapMetadata.getLicenses().stream().map(license -> (CamtrapLicense)license).filter(license -> license.getScope() == CamtrapLicense.Scope.DATA).findFirst();
                return dataLicenseWrapped.isPresent() && Constants.GBIF_SUPPORTED_LICENSES_CODES.contains(dataLicenseWrapped.get().getName());
            }
            return false;
        }
        return this.eml.parseLicenseUrl() != null && Constants.GBIF_SUPPORTED_LICENSES.contains(this.eml.parseLicenseUrl());
    }

    public boolean isRegistered() {
        return this.key != null && this.status.equals((Object)PublicationStatus.REGISTERED);
    }

    public void setCoreType(@Nullable String coreType) {
        this.coreType = StringUtils.isBlank((CharSequence)coreType) ? null : coreType;
    }

    public void setCreated(Date created) {
        this.created = created;
        if (this.modified == null) {
            this.modified = created;
        }
    }

    public void setCreator(User creator) {
        this.creator = creator;
        if (this.modifier == null) {
            this.modifier = creator;
        }
    }

    public void setEml(Eml eml) {
        this.eml = eml;
    }

    public void setDataPackageMetadata(DataPackageMetadata dataPackageMetadata) {
        this.dataPackageMetadata = dataPackageMetadata;
    }

    public void setEmlVersion(BigDecimal v) {
        if (ResourceUtils.assertVersionOrder((BigDecimal)v, (BigDecimal)this.emlVersion)) {
            this.setReplacedEmlVersion(new BigDecimal(this.emlVersion.toPlainString()));
        }
        this.emlVersion = v;
        this.eml.setEmlVersion(v);
    }

    public void setDataPackageMetadataVersion(BigDecimal v) {
        if (ResourceUtils.assertVersionOrder((BigDecimal)v, (BigDecimal)this.dataPackageMetadataVersion)) {
            this.setReplacedDataPackageMetadataVersion(new BigDecimal(this.dataPackageMetadataVersion.toPlainString()));
        }
        this.dataPackageMetadataVersion = v;
        this.dataPackageMetadata.setVersion(v.toPlainString());
    }

    public void setMetadataVersion(BigDecimal v) {
        if (this.isDataPackage()) {
            this.setDataPackageMetadataVersion(v);
        } else {
            this.setEmlVersion(v);
        }
    }

    public void setKey(UUID key) {
        this.key = key;
    }

    public void setLastPublished(Date lastPublished) {
        this.lastPublished = lastPublished;
    }

    public void setNextPublished(Date nextPublished) {
        this.nextPublished = nextPublished;
    }

    public void setManagers(Set<User> managers) {
        this.managers = managers;
    }

    public void setMappings(List<ExtensionMapping> extensions) {
        this.mappings = extensions;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setModifier(User modifier) {
        this.modifier = modifier;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public void setRecordsPublished(int recordsPublished) {
        this.recordsPublished = recordsPublished;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public void setStatus(PublicationStatus status) {
        this.status = status;
    }

    public void setPublicationMode(PublicationMode publicationMode) {
        this.publicationMode = publicationMode;
    }

    public void setSubtype(String subtype) {
        this.subtype = StringUtils.isBlank((CharSequence)subtype) ? null : subtype.toLowerCase();
    }

    public void setUpdateFrequency(String updateFrequency) {
        this.updateFrequency = MaintenanceUpdateFrequency.findByIdentifier((String)updateFrequency);
    }

    public void setAutoPublishingFrequency(String frequency, String month, String biMonth, int day, String dayOfWeek, int hour, int minute) {
        this.clearAutoPublishingFrequency();
        this.updateFrequency = MaintenanceUpdateFrequency.findByIdentifier((String)frequency);
        switch (1.$SwitchMap$org$gbif$metadata$eml$ipt$model$MaintenanceUpdateFrequency[this.updateFrequency.ordinal()]) {
            case 1: {
                this.updateFrequencyMonth = MonthEnum.findByIdentifier((String)month);
                this.updateFrequencyDay = day;
                this.updateFrequencyHour = hour;
                this.updateFrequencyMinute = minute;
                break;
            }
            case 2: {
                this.updateFrequencyBiMonth = BiMonthEnum.findByIdentifier((String)biMonth);
                this.updateFrequencyDay = day;
                this.updateFrequencyHour = hour;
                this.updateFrequencyMinute = minute;
                break;
            }
            case 3: {
                this.updateFrequencyDay = day;
                this.updateFrequencyHour = hour;
                this.updateFrequencyMinute = minute;
                break;
            }
            case 4: {
                this.updateFrequencyDayOfWeek = DayEnum.findByIdentifier((String)dayOfWeek);
                this.updateFrequencyHour = hour;
                this.updateFrequencyMinute = minute;
                break;
            }
            case 5: {
                this.updateFrequencyHour = hour;
                this.updateFrequencyMinute = minute;
                break;
            }
        }
    }

    public void clearAutoPublishingFrequency() {
        this.updateFrequency = null;
        this.updateFrequencyMonth = null;
        this.updateFrequencyBiMonth = null;
        this.updateFrequencyDay = null;
        this.updateFrequencyDayOfWeek = null;
        this.updateFrequencyHour = null;
        this.updateFrequencyMinute = null;
    }

    public void setTitle(String title) {
        if (this.eml != null) {
            this.eml.setTitle(title);
        }
    }

    public String toString() {
        return "Resource " + this.shortname;
    }

    public boolean usesAutoPublishing() {
        return this.publicationMode == PublicationMode.AUTO_PUBLISH_ON && this.updateFrequency != null;
    }

    public boolean isDeprecatedAutoPublishingConfiguration() {
        return this.usesAutoPublishing() && this.updateFrequencyMinute == null;
    }

    public String getChangeSummary() {
        return this.changeSummary;
    }

    public void setChangeSummary(String changeSummary) {
        this.changeSummary = changeSummary;
    }

    @NotNull
    public List<VersionHistory> getVersionHistory() {
        if (this.versionHistory == null) {
            this.versionHistory = new ArrayList();
        }
        return this.versionHistory;
    }

    public void setVersionHistory(List<VersionHistory> versionHistory) {
        this.versionHistory = versionHistory;
    }

    @NotNull
    public BigDecimal getReplacedEmlVersion() {
        return this.replacedEmlVersion == null ? Constants.INITIAL_RESOURCE_VERSION : this.replacedEmlVersion;
    }

    public BigDecimal getReplacedDataPackageMetadataVersion() {
        return this.replacedDataPackageMetadataVersion == null ? Constants.INITIAL_RESOURCE_VERSION_DATA_PACKAGE : this.replacedDataPackageMetadataVersion;
    }

    public BigDecimal getReplacedMetadataVersion() {
        return this.dataPackageIdentifier != null ? this.getReplacedDataPackageMetadataVersion() : this.getReplacedEmlVersion();
    }

    public void setReplacedEmlVersion(BigDecimal replacedEmlVersion) {
        VersionHistory vh = this.findVersionHistory(replacedEmlVersion);
        if (vh == null) {
            LOG.error("Replaced version (" + replacedEmlVersion.toPlainString() + ") does not exist in version history!");
        } else {
            this.replacedEmlVersion = replacedEmlVersion;
        }
    }

    public void setReplacedDataPackageMetadataVersion(BigDecimal replacedDataPackageMetadataVersion) {
        VersionHistory vh = this.findVersionHistory(replacedDataPackageMetadataVersion);
        if (vh == null) {
            LOG.error("Replaced version (" + replacedDataPackageMetadataVersion.toPlainString() + ") does not exist in version history!");
        } else {
            this.replacedDataPackageMetadataVersion = replacedDataPackageMetadataVersion;
        }
    }

    public boolean isPubliclyAvailable() {
        return this.status.equals((Object)PublicationStatus.PUBLIC) || this.status.equals((Object)PublicationStatus.REGISTERED);
    }

    public boolean isCitationAutoGenerated() {
        return this.citationAutoGenerated;
    }

    public void setCitationAutoGenerated(boolean citationAutoGenerated) {
        this.citationAutoGenerated = citationAutoGenerated;
    }

    public boolean isInferGeocoverageAutomatically() {
        return this.inferGeocoverageAutomatically;
    }

    public void setInferGeocoverageAutomatically(boolean inferGeocoverageAutomatically) {
        this.inferGeocoverageAutomatically = inferGeocoverageAutomatically;
    }

    public boolean isInferTaxonomicCoverageAutomatically() {
        return this.inferTaxonomicCoverageAutomatically;
    }

    public void setInferTaxonomicCoverageAutomatically(boolean inferTaxonomicCoverageAutomatically) {
        this.inferTaxonomicCoverageAutomatically = inferTaxonomicCoverageAutomatically;
    }

    public boolean isInferTemporalCoverageAutomatically() {
        return this.inferTemporalCoverageAutomatically;
    }

    public void setInferTemporalCoverageAutomatically(boolean inferTemporalCoverageAutomatically) {
        this.inferTemporalCoverageAutomatically = inferTemporalCoverageAutomatically;
    }

    public InferredMetadata getInferredMetadata() {
        return this.inferredMetadata;
    }

    public void setInferredMetadata(InferredMetadata inferredMetadata) {
        this.inferredMetadata = inferredMetadata;
    }

    public Map<String, Integer> getRecordsByExtension() {
        return this.recordsByExtension;
    }

    public void setRecordsByExtension(Map<String, Integer> recordsByExtension) {
        this.recordsByExtension = recordsByExtension;
    }

    public String generateResourceCitation(@NotNull String version, @NotNull String homepage) {
        try {
            return this.generateResourceCitation(new BigDecimal(version), new URI(homepage));
        }
        catch (URISyntaxException e) {
            LOG.error("Failed to generate URI for homepage string: " + homepage, (Throwable)e);
            return null;
        }
    }

    public String generateDataPackageResourceCitation(String version, String homepage) {
        try {
            return this.generateDataPackageResourceCitation(new BigDecimal(version), new URI(homepage));
        }
        catch (URISyntaxException e) {
            LOG.error("Failed to generate URI for homepage string: " + homepage, (Throwable)e);
            return null;
        }
    }

    public String generateResourceCitation(@NotNull BigDecimal version, @NotNull URI homepage) {
        String publisher;
        StringBuilder sb = new StringBuilder();
        LinkedHashSet verifiedAuthorList = new LinkedHashSet();
        List suitableAssociatedParties = this.getEml().getAssociatedParties().stream().filter(p -> "originator".equalsIgnoreCase(p.getRole()) || "metadataProvider".equalsIgnoreCase(p.getRole())).collect(Collectors.toList());
        Stream.of(this.getEml().getCreators(), this.getEml().getMetadataProviders(), suitableAssociatedParties).flatMap(Collection::stream).map(arg_0 -> this.getCitationAgentName(arg_0)).filter(StringUtils::isNotEmpty).forEach(verifiedAuthorList::add);
        Iterator iter = verifiedAuthorList.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        Date pubDate = this.getEml().getPubDate() != null ? this.getEml().getPubDate() : new Date();
        int publicationYear = this.getPublicationYear(pubDate);
        if (publicationYear > 0) {
            sb.append(" (");
            sb.append(publicationYear);
            sb.append("). ");
        }
        sb.append(StringUtils.trimToNull((String)this.getTitle()) == null ? this.getShortname() : StringUtils.trim((String)this.getTitle()));
        sb.append(". ");
        sb.append("Version ");
        sb.append(version.toPlainString());
        sb.append(". ");
        String string = publisher = this.getOrganisation() == null ? null : StringUtils.trimToNull((String)this.getOrganisation().getName());
        if (publisher != null) {
            sb.append(publisher);
            sb.append(". ");
        }
        if (this.getCoreType() != null) {
            sb.append(StringUtils.capitalize((String)this.getCoreType().toLowerCase()));
            sb.append(" dataset");
        }
        sb.append(". ");
        if (this.getDoi() != null) {
            sb.append(this.getDoi().getUrl());
        } else if (this.getEml().getCitation() != null && StringUtils.isNotBlank((CharSequence)this.getEml().getCitation().getIdentifier())) {
            sb.append(this.getEml().getCitation().getIdentifier());
        } else {
            sb.append(homepage.toString());
        }
        return sb.toString();
    }

    public String generateDataPackageResourceCitation(@NotNull BigDecimal version, @NotNull URI homepage) {
        StringBuilder sb = new StringBuilder();
        if (this.dataPackageMetadata instanceof CamtrapMetadata) {
            String publisher;
            LinkedHashSet contributorList = new LinkedHashSet();
            CamtrapMetadata metadata = (CamtrapMetadata)this.dataPackageMetadata;
            Stream.of(metadata.getContributors()).flatMap(Collection::stream).map(contributor -> (CamtrapContributor)contributor).filter(Objects::nonNull).filter(arg_0 -> this.hasCitationRole(arg_0)).map(arg_0 -> this.getCitationCamtrapContributorName(arg_0)).filter(StringUtils::isNotEmpty).forEach(contributorList::add);
            Iterator iter = contributorList.iterator();
            while (iter.hasNext()) {
                sb.append((String)iter.next());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            Date pubDate = metadata.getCreated() != null ? metadata.getCreated() : new Date();
            int publicationYear = this.getPublicationYear(pubDate);
            if (publicationYear > 0) {
                sb.append(" (");
                sb.append(publicationYear);
                sb.append("). ");
            }
            sb.append(StringUtils.trimToNull((String)this.getTitle()) == null ? this.getShortname() : StringUtils.trim((String)this.getTitle()));
            sb.append(". ");
            sb.append("Version ");
            sb.append(version.toPlainString());
            sb.append(". ");
            String string = publisher = this.getOrganisation() == null ? null : StringUtils.trimToNull((String)this.getOrganisation().getName());
            if (publisher != null) {
                sb.append(publisher);
                sb.append(". ");
            }
            if ("camtrap-dp".equals(this.getCoreType())) {
                sb.append("Camtrap DP dataset");
            } else if (this.getCoreType() != null) {
                sb.append(StringUtils.capitalize((String)this.getCoreType().toLowerCase()));
                sb.append(" dataset");
            }
            sb.append(". ");
            if (this.getDoi() != null) {
                sb.append(this.getDoi().getUrl());
            } else {
                sb.append(homepage.toString());
            }
        }
        return sb.toString();
    }

    private boolean hasCitationRole(CamtrapContributor contributor) {
        return CamtrapContributor.Role.CITATION_ROLES.contains(contributor.getRole());
    }

    protected String getCitationAgentName(Agent agent) {
        StringBuilder sb = new StringBuilder();
        String lastName = StringUtils.trimToNull((String)agent.getLastName());
        String firstNames = StringUtils.trimToNull((String)agent.getFirstName());
        String organisation = StringUtils.trimToNull((String)agent.getOrganisation());
        if (lastName != null) {
            sb.append(lastName);
            if (firstNames != null) {
                sb.append(" ");
                String[] names = firstNames.split("\\s+", -1);
                for (int i = 0; i < names.length; ++i) {
                    sb.append(StringUtils.upperCase((String)String.valueOf(names[i].charAt(0))));
                    if (i >= names.length - 1) continue;
                    sb.append(" ");
                }
            }
        } else if (firstNames == null && organisation != null) {
            sb.append(organisation);
        }
        return sb.toString();
    }

    protected String getCitationCamtrapContributorName(CamtrapContributor contributor) {
        StringBuilder sb = new StringBuilder();
        String lastNameTrimmed = StringUtils.trimToNull((String)contributor.getLastName());
        String firstNamesTrimmed = StringUtils.trimToNull((String)contributor.getFirstName());
        if (lastNameTrimmed != null) {
            sb.append(lastNameTrimmed);
            if (firstNamesTrimmed != null) {
                sb.append(" ");
                String[] names = firstNamesTrimmed.split("\\s+", -1);
                for (int i = 0; i < names.length; ++i) {
                    sb.append(StringUtils.upperCase((String)String.valueOf(names[i].charAt(0))));
                    if (i >= names.length - 1) continue;
                    sb.append(" ");
                }
            }
        }
        return sb.toString();
    }

    protected int getPublicationYear(Date publicationDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(publicationDate);
        return calendar.get(1);
    }

    public Date getMetadataModified() {
        return this.metadataModified;
    }

    public void setMetadataModified(Date metadataModified) {
        this.modified = metadataModified;
        this.metadataModified = metadataModified;
    }

    public Date getMappingsModified() {
        return this.mappingsModified;
    }

    public void setMappingsModified(Date mappingsModified) {
        this.modified = mappingsModified;
        this.mappingsModified = mappingsModified;
    }

    public Date getSourcesModified() {
        return this.sourcesModified;
    }

    public void setSourcesModified(Date sourcesModified) {
        this.modified = sourcesModified;
        this.sourcesModified = sourcesModified;
    }

    public synchronized void updateAlternateIdentifierForDOI() {
        Objects.requireNonNull(this.eml);
        if (this.doi != null) {
            List ids = this.eml.getAlternateIdentifiers();
            if (this.identifierStatus.equals((Object)IdentifierStatus.PUBLIC_PENDING_PUBLICATION) || this.identifierStatus.equals((Object)IdentifierStatus.PUBLIC)) {
                ArrayList<String> reorderedList = new ArrayList<String>();
                reorderedList.add(this.doi.toString());
                for (String id : ids) {
                    if (id.equalsIgnoreCase(this.doi.toString())) continue;
                    reorderedList.add(id);
                }
                if (!ids.isEmpty()) {
                    ids.clear();
                }
                ids.addAll(reorderedList);
                LOG.debug("DOI=" + this.doi.toString() + " added to resource's list of alt ids as first element");
            } else if (this.identifierStatus.equals((Object)IdentifierStatus.UNAVAILABLE) || this.identifierStatus.equals((Object)IdentifierStatus.UNRESERVED)) {
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    if (!id.equalsIgnoreCase(this.doi.toString())) continue;
                    iterator.remove();
                    LOG.debug("DOI=" + this.doi.toString() + " removed from resource's list of alt ids");
                }
            }
        }
    }

    public synchronized void updateCitationIdentifierForDOI() {
        Objects.requireNonNull(this.eml);
        if (this.doi != null) {
            Citation citation = this.eml.getCitation();
            if (this.identifierStatus.equals((Object)IdentifierStatus.PUBLIC_PENDING_PUBLICATION) || this.identifierStatus.equals((Object)IdentifierStatus.PUBLIC)) {
                if (citation == null) {
                    this.setCitationAutoGenerated(true);
                    this.eml.setCitation(new Citation("Will be replaced by auto-generated citation", this.doi.getUrl().toString()));
                } else {
                    citation.setIdentifier(this.doi.getUrl().toString());
                }
                LOG.debug("DOI=" + this.doi.getUrl().toString() + " set as resource's citation identifier");
            } else if (this.identifierStatus.equals((Object)IdentifierStatus.UNAVAILABLE) || this.identifierStatus.equals((Object)IdentifierStatus.UNRESERVED)) {
                if (citation == null) {
                    this.setCitationAutoGenerated(true);
                    Citation generated = new Citation();
                    generated.setCitation("Will be replaced by auto-generated citation");
                    this.eml.setCitation(generated);
                } else {
                    citation.setIdentifier(null);
                }
                LOG.debug("DOI=" + this.doi.getUrl().toString() + " unset as resource's citation identifier");
            }
        }
    }

    public boolean hasOccurrenceMapping() {
        return !this.getMappings(Constants.DWC_ROWTYPE_OCCURRENCE).isEmpty();
    }

    public Date getMakePublicDate() {
        return this.makePublicDate;
    }

    public void setMakePublicDate(Date makePublicDate) {
        this.makePublicDate = makePublicDate;
    }

    public boolean isDataPackage() {
        return this.dataPackageIdentifier != null;
    }

    public boolean isMetadataOnly() {
        return this.coreType != null && CoreRowType.METADATA.toString().equalsIgnoreCase(this.coreType);
    }

    public void inferCoverageMetadataAutomatically(boolean param) {
        this.setInferGeocoverageAutomatically(param);
        this.setInferTaxonomicCoverageAutomatically(param);
        this.setInferTemporalCoverageAutomatically(param);
    }

    public String getLastPublishedArchiveChecksum() {
        return this.lastPublishedArchiveChecksum;
    }

    public void setLastPublishedArchiveChecksum(String lastPublishedArchiveChecksum) {
        this.lastPublishedArchiveChecksum = lastPublishedArchiveChecksum;
    }

    public boolean isSkipPublicationIfNotChanged() {
        return this.skipPublicationIfNotChanged;
    }

    public void setSkipPublicationIfNotChanged(boolean skipPublicationIfNotChanged) {
        this.skipPublicationIfNotChanged = skipPublicationIfNotChanged;
    }

    public boolean isSkipPublicationIfRecordsDrop() {
        return this.skipPublicationIfRecordsDrop;
    }

    public void setSkipPublicationIfRecordsDrop(boolean skipPublicationIfRecordsDrop) {
        this.skipPublicationIfRecordsDrop = skipPublicationIfRecordsDrop;
    }

    public int getRecordsDropThreshold() {
        return this.recordsDropThreshold;
    }

    public void setRecordsDropThreshold(int recordsDropThreshold) {
        this.recordsDropThreshold = recordsDropThreshold;
    }
}

