/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import org.gbif.ipt.model.PublicationOptions;

public class PublicationOptions {
    private boolean skipPublicationIfNotChanged;
    private boolean skipPublicationIfRecordsDrop;
    private int recordsDropThreshold = 10;

    PublicationOptions(boolean skipPublicationIfNotChanged, boolean skipPublicationIfRecordsDrop, int recordsDropThreshold) {
        this.skipPublicationIfNotChanged = skipPublicationIfNotChanged;
        this.skipPublicationIfRecordsDrop = skipPublicationIfRecordsDrop;
        this.recordsDropThreshold = recordsDropThreshold;
    }

    public static PublicationOptionsBuilder builder() {
        return new PublicationOptionsBuilder();
    }

    public boolean isSkipPublicationIfNotChanged() {
        return this.skipPublicationIfNotChanged;
    }

    public boolean isSkipPublicationIfRecordsDrop() {
        return this.skipPublicationIfRecordsDrop;
    }

    public int getRecordsDropThreshold() {
        return this.recordsDropThreshold;
    }

    public void setSkipPublicationIfNotChanged(boolean skipPublicationIfNotChanged) {
        this.skipPublicationIfNotChanged = skipPublicationIfNotChanged;
    }

    public void setSkipPublicationIfRecordsDrop(boolean skipPublicationIfRecordsDrop) {
        this.skipPublicationIfRecordsDrop = skipPublicationIfRecordsDrop;
    }

    public void setRecordsDropThreshold(int recordsDropThreshold) {
        this.recordsDropThreshold = recordsDropThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PublicationOptions)) {
            return false;
        }
        PublicationOptions other = (PublicationOptions)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSkipPublicationIfNotChanged() != other.isSkipPublicationIfNotChanged()) {
            return false;
        }
        if (this.isSkipPublicationIfRecordsDrop() != other.isSkipPublicationIfRecordsDrop()) {
            return false;
        }
        return this.getRecordsDropThreshold() == other.getRecordsDropThreshold();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PublicationOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSkipPublicationIfNotChanged() ? 79 : 97);
        result = result * 59 + (this.isSkipPublicationIfRecordsDrop() ? 79 : 97);
        result = result * 59 + this.getRecordsDropThreshold();
        return result;
    }

    public String toString() {
        return "PublicationOptions(skipPublicationIfNotChanged=" + this.isSkipPublicationIfNotChanged() + ", skipPublicationIfRecordsDrop=" + this.isSkipPublicationIfRecordsDrop() + ", recordsDropThreshold=" + this.getRecordsDropThreshold() + ")";
    }
}

