/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gbif.ipt.model.AgentBase;
import org.gbif.ipt.model.Password;
import org.gbif.ipt.model.voc.DOIRegistrationAgency;

public class Organisation
extends AgentBase
implements Serializable {
    private static final long serialVersionUID = 2283765436256564L;
    private Password password = new Password();
    private String alias;
    private String nodeKey;
    private String nodeName;
    private String nodeContactEmail;
    private boolean canHost;
    private boolean agencyAccountPrimary;
    private DOIRegistrationAgency doiRegistrationAgency;
    private boolean associatedWithDoiRegistrationAgency;
    private String agencyAccountUsername;
    private Password agencyAccountPassword;
    private String doiPrefix;

    public Organisation() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof Organisation) {
            Organisation other = (Organisation)obj;
            return Objects.equals(this.getKey(), other.getKey());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @Nullable
    public String getNodeContactEmail() {
        return this.nodeContactEmail;
    }

    @Nullable
    public String getNodeKey() {
        return this.nodeKey;
    }

    @Nullable
    public String getNodeName() {
        return this.nodeName;
    }

    @Nullable
    public String getPassword() {
        if (this.password != null) {
            return StringUtils.trimToNull((String)this.password.password);
        }
        return null;
    }

    @Nullable
    public DOIRegistrationAgency getDoiRegistrationAgency() {
        return this.doiRegistrationAgency;
    }

    @Nullable
    public String getAgencyAccountUsername() {
        return this.agencyAccountUsername;
    }

    @Nullable
    public String getAgencyAccountPassword() {
        if (this.agencyAccountPassword != null) {
            return StringUtils.trimToNull((String)this.agencyAccountPassword.password);
        }
        return null;
    }

    @Nullable
    public String getDoiPrefix() {
        return this.doiPrefix;
    }

    public boolean isCanHost() {
        return this.canHost;
    }

    public void setCanHost(boolean canHost) {
        this.canHost = canHost;
    }

    public boolean isAgencyAccountPrimary() {
        return this.agencyAccountPrimary;
    }

    public void setAgencyAccountPrimary(boolean agencyAccountPrimary) {
        this.agencyAccountPrimary = agencyAccountPrimary;
    }

    public void setAlias(@Nullable String alias) {
        this.alias = StringUtils.trimToNull((String)alias);
    }

    public void setDescription(@Nullable String description) {
        this.description = StringUtils.trimToNull((String)description);
    }

    public void setNodeContactEmail(@Nullable String nodeContactEmail) {
        this.nodeContactEmail = StringUtils.trimToNull((String)nodeContactEmail);
    }

    public void setNodeKey(@Nullable String nodeKey) {
        this.nodeKey = StringUtils.trimToNull((String)nodeKey);
    }

    public void setNodeName(@Nullable String nodeName) {
        this.nodeName = StringUtils.trimToNull((String)nodeName);
    }

    public void setPassword(@Nullable String password) {
        if (password == null) {
            this.password = new Password();
        }
        this.password.password = password;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public void setDoiRegistrationAgency(@Nullable DOIRegistrationAgency doiRegistrationAgency) {
        this.doiRegistrationAgency = doiRegistrationAgency;
    }

    public void setAgencyAccountUsername(@Nullable String agencyAccountUsername) {
        this.agencyAccountUsername = StringUtils.trimToNull((String)agencyAccountUsername);
    }

    public void setAgencyAccountPassword(@Nullable String agencyAccountPassword) {
        if (this.agencyAccountPassword == null) {
            this.agencyAccountPassword = new Password();
        }
        this.agencyAccountPassword.password = agencyAccountPassword;
    }

    public void setDoiPrefix(@Nullable String doiPrefix) {
        this.doiPrefix = StringUtils.trimToNull((String)doiPrefix);
    }

    public String getTestDoiPrefix() {
        return "10.21373";
    }

    public boolean isAssociatedWithDoiRegistrationAgency() {
        return this.associatedWithDoiRegistrationAgency;
    }

    public void setAssociatedWithDoiRegistrationAgency(boolean associatedWithDoiRegistrationAgency) {
        this.associatedWithDoiRegistrationAgency = associatedWithDoiRegistrationAgency;
    }

    public Organisation(Organisation another) {
        this.setKey(another.getKey().toString());
        this.setName(another.getName());
        this.setAlias(another.getAlias());
        this.setPassword(another.getPassword());
        this.setCanHost(another.isCanHost());
        this.setAgencyAccountPrimary(another.isAgencyAccountPrimary());
        this.setDoiRegistrationAgency(another.getDoiRegistrationAgency());
        this.setAssociatedWithDoiRegistrationAgency(another.isAssociatedWithDoiRegistrationAgency());
        this.setAgencyAccountUsername(another.getAgencyAccountUsername());
        this.setAgencyAccountPassword(another.getAgencyAccountPassword());
        this.setDoiPrefix(another.getDoiPrefix());
        this.setDescription(another.getDescription());
        this.setHomepageURL(another.getHomepageURL());
        this.setPrimaryContactType(another.getPrimaryContactType());
        this.setPrimaryContactName(another.getPrimaryContactName());
        this.setPrimaryContactFirstName(another.getPrimaryContactFirstName());
        this.setPrimaryContactLastName(another.getPrimaryContactLastName());
        this.setPrimaryContactDescription(another.getPrimaryContactDescription());
        this.setPrimaryContactAddress(another.getPrimaryContactAddress());
        this.setPrimaryContactEmail(another.getPrimaryContactEmail());
        this.setPrimaryContactPhone(another.getPrimaryContactPhone());
        this.setNodeKey(another.getNodeKey());
        this.setNodeName(another.getNodeName());
        this.setNodeContactEmail(another.getNodeContactEmail());
    }
}

