/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gbif.dwc.terms.Term;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.PropertyMapping;
import org.gbif.ipt.model.RecordFilter;
import org.gbif.ipt.model.Source;

public class ExtensionMapping
implements Serializable {
    private static final long serialVersionUID = 23789961641L;
    public static final Integer IDGEN_LINE_NUMBER = -1;
    public static final Integer IDGEN_UUID = -2;
    public static final Integer NO_ID = -3;
    private Source source;
    private transient String extensionVerbatim;
    private Extension extension;
    private Set<PropertyMapping> fields = new TreeSet();
    private Integer idColumn;
    private String idSuffix;
    private RecordFilter filter;
    private boolean doiUsedForDatasetId;
    private Date lastModified;

    public List<String> getColumns(List<String[]> peek) {
        if (!peek.isEmpty()) {
            int columnsCount = peek.get(0).length;
            ArrayList<String> columns = new ArrayList<String>(columnsCount);
            for (int count = 0; count < columnsCount; ++count) {
                String value = null;
                for (String[] row : peek) {
                    if (row[count] == null || row[count].length() == 0) continue;
                    value = row[count].length() > 10 ? row[count].substring(0, 10) + "..." : row[count];
                    break;
                }
                if (value == null) {
                    columns.add("Column #" + (count + 1));
                    continue;
                }
                columns.add("Column #" + (count + 1) + " - " + value);
            }
            return columns;
        }
        return new ArrayList<String>();
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getExtensionVerbatim() {
        return this.extensionVerbatim;
    }

    public PropertyMapping getField(String qname) {
        for (PropertyMapping f : this.fields) {
            if (!f.getTerm().qualifiedName().equals(qname)) continue;
            return f;
        }
        return null;
    }

    public Set<PropertyMapping> getFields() {
        return this.fields;
    }

    public RecordFilter getFilter() {
        return this.filter;
    }

    public Integer getIdColumn() {
        return this.idColumn;
    }

    public String getIdSuffix() {
        return this.idSuffix;
    }

    public Source getSource() {
        return this.source;
    }

    public boolean isCore() {
        return this.extension != null && this.extension.isCore();
    }

    public boolean isTaxonCore() {
        return this.isCore() && this.extension.getRowType().equalsIgnoreCase(Constants.DWC_ROWTYPE_TAXON);
    }

    public boolean isMapped(Term t) {
        PropertyMapping pm = this.getField(t.qualifiedName());
        return pm != null && (pm.getIndex() != null || pm.getDefaultValue() != null);
    }

    public boolean isDoiUsedForDatasetId() {
        return this.doiUsedForDatasetId;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public void setExtensionVerbatim(String extensionVerbatim) {
        this.extensionVerbatim = extensionVerbatim;
    }

    public void setFields(Set<PropertyMapping> fields) {
        this.fields = fields;
    }

    public void setFilter(RecordFilter filter) {
        this.filter = filter;
    }

    public void setIdColumn(Integer idColumn) {
        this.idColumn = idColumn;
    }

    public void setIdSuffix(String idSuffix) {
        this.idSuffix = idSuffix;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setDoiUsedForDatasetId(boolean doiUsedForDatasetId) {
        this.doiUsedForDatasetId = doiUsedForDatasetId;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }
}

