/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.model;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gbif.dwc.terms.Term;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.Vocabulary;
import org.gbif.metadata.eml.ipt.util.DateUtils;

public class Extension
implements Serializable {
    private static final long serialVersionUID = 54294388543L;
    private String title;
    private String name;
    private URL url;
    @SerializedName(value="identifier")
    private String rowType;
    private String subject;
    private String description;
    private String namespace;
    private boolean isLatest;
    private Date issued;
    private URL link;
    private boolean installed;
    private List<ExtensionProperty> properties = new ArrayList();
    private Date modified = new Date();

    public void addProperty(ExtensionProperty property) {
        property.setExtension(this);
        this.properties.add(property);
    }

    public int compareTo(Extension object) {
        return new CompareToBuilder().append((Object)this.rowType, (Object)object.rowType).toComparison();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Extension)) {
            return false;
        }
        Extension o = (Extension)other;
        return Objects.equals(this.rowType, o.rowType);
    }

    public String getDescription() {
        return this.description;
    }

    public URL getLink() {
        return this.link;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<ExtensionProperty> getProperties() {
        return this.properties;
    }

    public ExtensionProperty getProperty(Term term) {
        return this.getProperty(term.qualifiedName());
    }

    public ExtensionProperty getProperty(String term) {
        if (term == null) {
            return null;
        }
        for (ExtensionProperty p : this.properties) {
            if (!term.equalsIgnoreCase(p.getQualname())) continue;
            return p;
        }
        return null;
    }

    public String getRowType() {
        return this.rowType;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTitle() {
        return this.title;
    }

    public URL getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hashCode(this.rowType);
    }

    public boolean hasProperty(Term term) {
        return this.getProperty(term) != null;
    }

    public boolean hasProperty(String term) {
        return this.getProperty(term) != null;
    }

    public boolean isCore() {
        return AppConfig.isCore((String)this.rowType);
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public Set<Vocabulary> listVocabularies() {
        HashSet<Vocabulary> vocabs = new HashSet<Vocabulary>();
        for (ExtensionProperty prop : this.getProperties()) {
            if (prop.getVocabulary() == null) continue;
            vocabs.add(prop.getVocabulary());
        }
        return vocabs;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public void setLink(String link) {
        try {
            this.link = new URL(link);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setLink(URL link) {
        this.link = link;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setName(String name) {
        this.name = name.replaceAll("\\s", "_");
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setProperties(List<ExtensionProperty> properties) {
        this.properties = properties;
    }

    public void setRowType(String rowType) {
        this.rowType = rowType;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("rowType", (Object)this.rowType).toString();
    }

    public boolean isLatest() {
        return this.isLatest;
    }

    public void setLatest(boolean isLatest) {
        this.isLatest = isLatest;
    }

    @Nullable
    public Date getIssued() {
        return this.issued;
    }

    public void setIssued(Date issued) {
        this.issued = issued;
    }

    public void setIssuedDateAsString(String dateString) throws ParseException {
        this.issued = DateUtils.calendarDate((String)dateString);
    }

    public List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        for (ExtensionProperty property : this.properties) {
            if (property.getGroup() == null || groups.contains(property.getGroup())) continue;
            groups.add(property.getGroup());
        }
        return groups;
    }
}

