/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.config;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.PublishingMonitor;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class PublishingMonitor {
    public static final int MONITOR_INTERVAL_MS = 10000;
    private static Thread monitorThread;
    private static final Logger LOG;
    private AtomicBoolean running;
    private final ResourceManager resourceManager;
    private final BaseAction baseAction;

    @Inject
    public PublishingMonitor(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.baseAction = new BaseAction(textProvider, cfg, registrationManager);
    }

    private void startMonitorThread() {
        monitorThread = new Thread((Runnable)new QueueMonitor(this));
        monitorThread.start();
        LOG.debug("The monitor thread has started.");
    }

    public void start() {
        if (monitorThread != null) {
            if (!monitorThread.isAlive()) {
                this.startMonitorThread();
            } else {
                LOG.error("The monitor thread is already running");
            }
        } else {
            this.startMonitorThread();
        }
    }

    public void stop() {
        this.running.set(false);
        monitorThread = null;
    }

    static {
        LOG = LogManager.getLogger(PublishingMonitor.class);
    }
}

