/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.config;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.HttpRequestInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.config.DataDirTemplateLoader;
import org.gbif.ipt.config.JdbcSupport;
import org.gbif.ipt.utils.InputStreamUtils;
import org.gbif.ipt.utils.PBEEncrypt;
import org.gbif.utils.HttpClient;
import org.gbif.utils.HttpUtil;
import org.gbif.utils.PreemptiveAuthenticationInterceptor;

public class IPTModule {
    private static final Logger LOG = LogManager.getLogger(IPTModule.class);
    private static final String DATA_DIR_ENV_VAR = "IPT_DATA_DIR";
    protected static final int CONNECTION_TIMEOUT_MSEC = 30000;
    protected static final int MAX_CONNECTIONS = 100;
    protected static final int MAX_PER_ROUTE = 10;
    private ServletContext servletContext;

    @Inject
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public DataDir provideDataDir() {
        DataDir dd;
        String dataDirectoryLocationParam = this.servletContext.getInitParameter(DATA_DIR_ENV_VAR);
        String dataDirectoryLocationEnv = System.getenv(DATA_DIR_ENV_VAR);
        if (dataDirectoryLocationParam != null) {
            LOG.info("Using context parameter IPT_DATA_DIR for data directory location: " + dataDirectoryLocationParam);
            dd = DataDir.buildFromString((String)dataDirectoryLocationParam);
        } else if (dataDirectoryLocationEnv != null) {
            LOG.info("Using environment variable IPT_DATA_DIR for data directory location: " + dataDirectoryLocationEnv);
            dd = DataDir.buildFromString((String)dataDirectoryLocationEnv);
        } else {
            File dataDirSettingFile = new File(this.servletContext.getRealPath("/") + "/WEB-INF/datadir.location");
            LOG.info("Using file " + dataDirSettingFile.getAbsolutePath() + " for data directory location.");
            dd = DataDir.buildFromLocationFile((File)dataDirSettingFile);
        }
        try {
            if (dd.isConfigured()) {
                dd.clearTmp();
            }
        }
        catch (IOException e) {
            LOG.warn("Couldn't clear temporary data dir folder", (Throwable)e);
        }
        return dd;
    }

    public Configuration provideFreemarker(DataDir datadir) {
        Configuration fm = new Configuration(Configuration.VERSION_2_3_31);
        ArrayList<Object> tLoader = new ArrayList<Object>();
        tLoader.add(new ClassTemplateLoader(AppConfig.class, "/"));
        try {
            DataDirTemplateLoader tlDataDir = new DataDirTemplateLoader(datadir.dataFile(""));
            tLoader.add(tlDataDir);
        }
        catch (IOException e) {
            LOG.warn("Cannot load custom templates from data dir: " + e.getMessage(), (Throwable)e);
        }
        MultiTemplateLoader tl = new MultiTemplateLoader(tLoader.toArray(new TemplateLoader[0]));
        fm.setDefaultEncoding("UTF-8");
        fm.setTemplateLoader((TemplateLoader)tl);
        return fm;
    }

    public HttpClient provideHttpClient() {
        String version = "unknown";
        try (InputStream configStream = new InputStreamUtils().classpathStream("application.properties");){
            Properties props = new Properties();
            if (configStream == null) {
                LOG.error("Could not load default configuration from application.properties in classpath");
            } else {
                props.load(configStream);
                LOG.debug("Loaded default configuration from application.properties in classpath");
                version = props.getProperty("dev.version");
            }
        }
        catch (Exception e) {
            LOG.error("Unable to read version from application.properties, continuing start-up.", (Throwable)e);
        }
        String userAgent = String.format("GBIF-IPT/%s (+https://www.gbif.org/ipt) Java/%s (%s)", version, System.getProperty("java.version", "?"), System.getProperty("os.name", "?"));
        return HttpUtil.newMultithreadedClient((int)30000, (int)100, (int)10, (String)userAgent, (HttpRequestInterceptor)new PreemptiveAuthenticationInterceptor());
    }

    public JdbcSupport provideJdbcSupport() {
        JdbcSupport jdbcs = new JdbcSupport();
        InputStreamUtils streamUtils = new InputStreamUtils();
        InputStream configStream = streamUtils.classpathStream("jdbc.properties");
        if (configStream == null) {
            LOG.error("Could not find supported jdbc driver information file jdbc.properties");
        } else {
            try {
                Properties props = new Properties();
                props.load(configStream);
                jdbcs.setProperties(props);
                LOG.debug("Loaded supported jdbc driver information from jdbc.properties");
            }
            catch (IOException e) {
                LOG.error("Could not load supported jdbc driver information from jdbc.properties", (Throwable)e);
            }
        }
        return jdbcs;
    }

    public SAXParserFactory provideNsAwareSaxParserFactory() {
        SAXParserFactory saxf = null;
        try {
            saxf = SAXParserFactory.newInstance();
            saxf.setValidating(false);
            saxf.setNamespaceAware(true);
        }
        catch (Exception e) {
            LOG.error("Cant create namespace aware SAX Parser Factory: " + e.getMessage(), (Throwable)e);
        }
        return saxf;
    }

    public PBEEncrypt providePasswordEncryption() {
        byte[] salt = new byte[]{0, 5, 2, 5, 4, 37, 6, 23};
        PBEEncrypt enc = null;
        try {
            enc = new PBEEncrypt("Carla Maria Luise", salt, 9);
        }
        catch (PBEEncrypt.EncryptionException e) {
            LOG.error("Cannot create password encryption", (Throwable)e);
        }
        return enc;
    }
}

