/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.config;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.config.ExtensionMonitor;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.registry.RegistryManager;

public class ExtensionMonitor {
    public static final int MONITOR_INTERVAL_MS = 86400000;
    private static Thread monitorThread;
    private static final Logger LOG;
    private AtomicBoolean running;
    private final ExtensionManager extensionManager;
    private final RegistryManager registryManager;

    @Inject
    public ExtensionMonitor(ExtensionManager extensionManager, RegistryManager registryManager) {
        this.extensionManager = extensionManager;
        this.registryManager = registryManager;
    }

    private void startMonitorThread() {
        monitorThread = new Thread((Runnable)new QueueMonitor(this));
        monitorThread.start();
        LOG.debug("The monitor thread has started.");
    }

    public void start() {
        if (monitorThread != null) {
            if (!monitorThread.isAlive()) {
                this.startMonitorThread();
            } else {
                LOG.error("The monitor thread is already running");
            }
        } else {
            this.startMonitorThread();
        }
    }

    public void stop() {
        this.running.set(false);
        monitorThread = null;
    }

    static {
        LOG = LogManager.getLogger(ExtensionMonitor.class);
    }
}

