/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.portal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.portal.PortalBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.FileSource;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class ResourceFileAction
extends PortalBaseAction {
    private static final Logger LOG = LogManager.getLogger(ResourceFileAction.class);
    private final DataDir dataDir;
    protected Source source;
    private InputStream inputStream;
    protected File data;
    protected String mimeType = "text/plain";
    protected String filename;

    @Inject
    public ResourceFileAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, DataDir dataDir, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.dataDir = dataDir;
    }

    public String archive() {
        if (this.resource == null) {
            return "404";
        }
        if (this.version == null) {
            BigDecimal latestVersion = this.resource.getLastPublishedVersionsVersion();
            if (latestVersion == null) {
                return "404";
            }
            this.version = latestVersion;
        }
        boolean isDataPackageResource = this.resource.getDataPackageIdentifier() != null;
        StringBuilder sb = new StringBuilder();
        if (isDataPackageResource) {
            this.data = this.dataDir.resourceDataPackageFile(this.resource.getShortname(), this.version);
            sb.append("datapackage-").append(this.resource.getShortname());
        } else {
            this.data = this.dataDir.resourceDwcaFile(this.resource.getShortname(), this.version);
            sb.append("dwca-").append(this.resource.getShortname());
        }
        if (this.version != null) {
            sb.append("-v").append(this.version.toPlainString());
        }
        sb.append(".zip");
        this.filename = sb.toString();
        this.mimeType = "application/zip";
        return this.execute();
    }

    public String metadata() {
        if (this.resource == null) {
            return "404";
        }
        if (this.version == null) {
            BigDecimal latestVersion = this.resource.getLastPublishedVersionsVersion();
            if (latestVersion == null) {
                return "404";
            }
            this.version = latestVersion;
        }
        boolean isDataPackageResource = this.resource.getDataPackageIdentifier() != null;
        StringBuilder sb = new StringBuilder();
        if (isDataPackageResource) {
            if ("coldp".equals(this.resource.getCoreType())) {
                this.data = this.dataDir.resourceDatapackageMetadataFile(this.resource.getShortname(), this.resource.getCoreType(), this.version);
                this.mimeType = "text/yaml";
                sb.append("metadata-").append(this.resource.getShortname());
                if (this.version != null) {
                    sb.append("-v").append(this.version.toPlainString());
                }
                sb.append(".yaml");
            } else {
                this.data = this.dataDir.resourceDatapackageMetadataFile(this.resource.getShortname(), this.resource.getCoreType(), this.version);
                this.mimeType = "application/json";
                sb.append("datapackage-").append(this.resource.getShortname());
                if (this.version != null) {
                    sb.append("-v").append(this.version.toPlainString());
                }
                sb.append(".json");
            }
        } else {
            this.data = this.dataDir.resourceEmlFile(this.resource.getShortname(), this.version);
            this.mimeType = "text/xml";
            sb.append("eml-").append(this.resource.getShortname());
            if (this.version != null) {
                sb.append("-v").append(this.version.toPlainString());
            }
            sb.append(".xml");
        }
        this.filename = sb.toString();
        return this.execute();
    }

    public String execute() {
        if (this.data == null) {
            return "404";
        }
        if (this.filename == null) {
            this.filename = this.data.getName();
        }
        try {
            this.inputStream = new FileInputStream(this.data);
            long lastModified = 1000L * ((this.data.lastModified() + 500L) / 1000L);
            this.response.setDateHeader("Last-Modified", lastModified);
            try {
                long since = this.req.getDateHeader("If-Modified-Since");
                if (since >= lastModified) {
                    return "304";
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Conditional get with If-Modified-Since header couldn't be interpreted", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("Data dir file not found", (Throwable)e);
            return "404";
        }
        return "success";
    }

    public File getData() {
        return this.data;
    }

    public String getFilename() {
        return this.filename;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String logo() {
        if (this.resource == null) {
            return "404";
        }
        for (String type : Constants.IMAGE_TYPES) {
            this.data = this.dataDir.resourceLogoFile(this.resource.getShortname(), type);
            if (!this.data.exists()) continue;
            this.mimeType = "image/" + type;
            this.filename = "logo" + type;
            break;
        }
        if (!this.data.exists()) {
            return "404";
        }
        return this.execute();
    }

    public String publicationLog() {
        if (this.resource == null) {
            return "404";
        }
        this.data = this.dataDir.resourcePublicationLogFile(this.resource.getShortname());
        if (!this.data.exists()) {
            return "404";
        }
        this.mimeType = "text/log";
        this.filename = "publication.log";
        return this.execute();
    }

    public String sourceLog() {
        if (this.resource == null) {
            return "404";
        }
        this.data = this.dataDir.sourceLogFile(this.resource.getShortname(), this.source.getName());
        if (!this.data.exists()) {
            return "404";
        }
        this.mimeType = "text/log";
        this.filename = this.source.getName() + ".log";
        return this.execute();
    }

    public void prepare() {
        super.prepare();
        String src = StringUtils.trimToNull((String)this.req.getParameter("s"));
        if (StringUtils.isNotBlank((CharSequence)src)) {
            this.source = this.resource.getSource(src);
        }
    }

    public String rtf() {
        if (this.resource == null) {
            return "404";
        }
        this.data = this.dataDir.resourceRtfFile(this.resource.getShortname(), this.version);
        this.mimeType = "application/rtf";
        StringBuilder sb = new StringBuilder();
        sb.append("rtf-").append(this.resource.getShortname());
        if (this.version != null) {
            sb.append("-v").append(this.version.toPlainString());
        }
        sb.append(".rtf");
        this.filename = sb.toString();
        return this.execute();
    }

    public String rawsource() {
        if (this.resource == null || this.id == null) {
            return "404";
        }
        Source source = this.resource.getSource(this.id);
        if (source instanceof FileSource) {
            FileSource frSrc = (FileSource)source;
            this.data = this.dataDir.sourceFile(this.resource, frSrc);
            this.mimeType = "application/octet-stream";
            this.filename = this.id + frSrc.getPreferredFileSuffix();
            return this.execute();
        }
        return "404";
    }
}

