/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.portal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.model.common.DOI;
import org.gbif.ipt.action.portal.OrganizedTaxonomicCoverage;
import org.gbif.ipt.action.portal.OrganizedTaxonomicKeywords;
import org.gbif.ipt.action.portal.PortalBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.User;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.voc.IdentifierStatus;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.MetadataReader;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.RequireManagerInterceptor;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.FileUtils;
import org.gbif.ipt.utils.MapUtils;
import org.gbif.ipt.utils.MetadataUtils;
import org.gbif.metadata.eml.ipt.EmlFactory;
import org.gbif.metadata.eml.ipt.model.Agent;
import org.gbif.metadata.eml.ipt.model.Citation;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.TaxonKeyword;
import org.gbif.metadata.eml.ipt.model.TaxonomicCoverage;
import org.xml.sax.SAXException;

public class ResourceAction
extends PortalBaseAction {
    private static final Logger LOG = LogManager.getLogger(ResourceAction.class);
    private MetadataReader metadataReader;
    private VocabulariesManager vocabManager;
    private ExtensionManager extensionManager;
    private List<Resource> resources;
    private Integer page = 1;
    private List<OrganizedTaxonomicCoverage> organizedCoverages;
    private Map<String, String> roles;
    private Map<String, String> preservationMethods;
    private Map<String, String> languages;
    private Map<String, String> countries;
    private Map<String, String> ranks;
    private DataDir dataDir;
    private Eml eml;
    private DataPackageMetadata dpMetadata;
    private Set<Agent> mergedContacts = new LinkedHashSet();
    private Set<Agent> deduplicatedProjectPersonnel = new LinkedHashSet();
    private Map<String, Set<String>> contactRoles = new HashMap();
    private Map<String, Set<String>> projectPersonnelRoles = new HashMap();
    private boolean metadataOnly;
    private boolean preview;
    private Map<String, String> frequencies;
    private Map<String, String> types;
    private int recordsPublishedForVersion;
    private Map<String, Integer> recordsByExtensionForVersion = new HashMap();
    private String coreType;
    private String dwcaSizeForVersion;
    private String dataPackageSizeForVersion;
    private String emlSizeForVersion;
    private String metadataSizeForVersion;
    private String rtfSizeForVersion;

    @Inject
    public ResourceAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, VocabulariesManager vocabManager, DataDir dataDir, ExtensionManager extensionManager, MetadataReader metadataReader) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.vocabManager = vocabManager;
        this.dataDir = dataDir;
        this.extensionManager = extensionManager;
        this.metadataReader = metadataReader;
    }

    public String execute() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        return "success";
    }

    private Eml loadEmlFromFile(String shortname, @NotNull BigDecimal version) throws IOException, SAXException, ParserConfigurationException {
        Objects.requireNonNull(version);
        File emlFile = this.dataDir.resourceEmlFile(shortname, version);
        LOG.debug("Loading EML from file: " + emlFile.getAbsolutePath());
        InputStream in = Files.newInputStream(emlFile.toPath(), new OpenOption[0]);
        return EmlFactory.build((InputStream)in);
    }

    private DataPackageMetadata loadDataPackageMetadataFromFile(String shortname, String type, @NotNull BigDecimal version) throws IOException {
        Objects.requireNonNull(version);
        File metadataFile = this.dataDir.resourceDatapackageMetadataFile(shortname, type, version);
        DataPackageMetadata result = (DataPackageMetadata)this.metadataReader.readValue(metadataFile, MetadataUtils.metadataClassForType((String)type));
        LOG.debug("Loading metadata from file: " + metadataFile.getAbsolutePath());
        return result;
    }

    private BigDecimal findLatestPublishedPublicVersion(Resource resource) {
        if (resource != null) {
            List history = resource.getVersionHistory();
            if (!history.isEmpty()) {
                VersionHistory latestVersion = (VersionHistory)history.get(0);
                if (!latestVersion.getPublicationStatus().equals((Object)PublicationStatus.DELETED) && !latestVersion.getPublicationStatus().equals((Object)PublicationStatus.PRIVATE)) {
                    return new BigDecimal(latestVersion.getVersion());
                }
            } else if (resource.isRegistered()) {
                return resource.getMetadataVersion();
            }
        }
        return null;
    }

    private BigDecimal findLatestPublishedVersion(Resource resource) {
        if (resource != null) {
            List history = resource.getVersionHistory();
            if (!history.isEmpty()) {
                return new BigDecimal(((VersionHistory)history.get(0)).getVersion());
            }
            return resource.getMetadataVersion();
        }
        return null;
    }

    private PublicationStatus getPublishedVersionsPublicationStatus(Resource resource, BigDecimal version) {
        Objects.requireNonNull(version);
        List history = resource.getVersionHistory();
        if (!history.isEmpty()) {
            for (VersionHistory vh : history) {
                BigDecimal vhVersion = new BigDecimal(vh.getVersion());
                if (vhVersion.compareTo(version) != 0) continue;
                return vh.getPublicationStatus();
            }
        } else if (resource.getMetadataVersion().compareTo(version) == 0) {
            return resource.getStatus();
        }
        return PublicationStatus.PRIVATE;
    }

    public DOI findDoiAssignedToPublishedVersion() {
        if (this.resource != null) {
            BigDecimal versionRequested = this.getVersion() == null ? this.resource.getMetadataVersion() : this.getVersion();
            for (VersionHistory history : this.resource.getVersionHistory()) {
                if (!history.getVersion().equalsIgnoreCase(versionRequested.toPlainString()) || history.getStatus() != IdentifierStatus.PUBLIC) continue;
                return history.getDoi();
            }
        }
        return null;
    }

    public Ipt getIpt() {
        if (this.registrationManager.getIpt() == null) {
            return new Ipt();
        }
        return this.registrationManager.getIpt();
    }

    public String rss() {
        Resource r;
        String resourceShortname = this.req.getParameter("r");
        this.resources = resourceShortname == null ? this.resourceManager.latest(this.page.intValue(), 25) : ((r = this.resourceManager.get(resourceShortname)).getStatus() == PublicationStatus.PUBLIC || r.getStatus() == PublicationStatus.REGISTERED ? Collections.singletonList(this.resourceManager.get(resourceShortname)) : new ArrayList());
        return "success";
    }

    public void finishLoadingDetail(@NotNull Resource resource, @NotNull Eml eml, @NotNull BigDecimal version) {
        String name = resource.getShortname();
        File dwcaFile = this.dataDir.resourceDwcaFile(name, version);
        if (dwcaFile.exists()) {
            this.dwcaSizeForVersion = FileUtils.formatSize((long)dwcaFile.length(), (int)0);
        } else {
            this.metadataOnly = true;
        }
        File emlFile = this.dataDir.resourceEmlFile(name, version);
        this.emlSizeForVersion = FileUtils.formatSize((long)emlFile.length(), (int)0);
        File rtfFile = this.dataDir.resourceRtfFile(name, version);
        this.rtfSizeForVersion = FileUtils.formatSize((long)rtfFile.length(), (int)0);
        for (VersionHistory history : resource.getVersionHistory()) {
            if (version.compareTo(new BigDecimal(history.getVersion())) != 0) continue;
            this.recordsPublishedForVersion = history.getRecordsPublished();
            this.setRecordsByExtensionForVersion(history.getRecordsByExtension());
        }
        if (this.recordsByExtensionForVersion == null) {
            HashMap m = new HashMap();
            this.setRecordsByExtensionForVersion(m);
        }
        if (this.metadataOnly && this.recordsPublishedForVersion > 0) {
            this.addActionWarning(this.getText("portal.resource.version.notArchived.count", new String[]{String.valueOf(this.recordsPublishedForVersion)}));
        }
        if (eml.getTaxonomicCoverages() != null) {
            this.organizedCoverages = this.constructOrganizedTaxonomicCoverages(eml.getTaxonomicCoverages());
        }
        this.roles = new LinkedHashMap();
        this.roles.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/agentRole", this.getLocaleLanguage(), false));
        this.preservationMethods = new LinkedHashMap();
        this.preservationMethods.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/preservation_method", this.getLocaleLanguage(), false));
        this.languages = this.vocabManager.getI18nVocab("http://iso.org/639-2", this.getLocaleLanguage(), true);
        this.countries = new LinkedHashMap();
        this.countries.putAll(this.vocabManager.getI18nVocab("http://iso.org/iso3166-1/alpha2", this.getLocaleLanguage(), true));
        this.ranks = new LinkedHashMap();
        this.ranks.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/rank", this.getLocaleLanguage(), false));
        this.frequencies = new LinkedHashMap();
        this.frequencies.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/eml/updateFrequency", this.getLocaleLanguage(), false));
        this.types = new LinkedHashMap();
        this.types.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/datasetType", this.getLocaleLanguage(), false));
        this.types = MapUtils.getMapWithLowercaseKeys((Map)this.types);
        this.coreType = resource.getCoreType() != null && this.types.containsKey(resource.getCoreType().toLowerCase()) ? (String)this.types.get(resource.getCoreType().toLowerCase()) : (String)this.types.get(Resource.CoreRowType.OTHER.toString().toLowerCase());
    }

    public void finishLoadingDetail(@NotNull Resource resource, @NotNull DataPackageMetadata metadata, @NotNull BigDecimal version) {
        String name = resource.getShortname();
        File dataPackageFile = this.dataDir.resourceDataPackageFile(name, version);
        this.dataPackageSizeForVersion = FileUtils.formatSize((long)dataPackageFile.length(), (int)0);
        File metadataFile = this.dataDir.resourceDatapackageMetadataFile(name, resource.getCoreType(), version);
        this.metadataSizeForVersion = FileUtils.formatSize((long)metadataFile.length(), (int)0);
        for (VersionHistory history : resource.getVersionHistory()) {
            if (version.compareTo(new BigDecimal(history.getVersion())) != 0) continue;
            this.recordsPublishedForVersion = history.getRecordsPublished();
            this.setRecordsByExtensionForVersion(history.getRecordsByExtension());
        }
    }

    public String preview() {
        if (this.resource.isDataPackage()) {
            return this.previewDataPackage();
        }
        String shortname = this.resource.getShortname();
        try {
            File emlFile = this.dataDir.resourceEmlFile(shortname);
            LOG.debug("Loading metadata from file: " + emlFile.getAbsolutePath());
            FileInputStream in = new FileInputStream(emlFile);
            this.eml = EmlFactory.build((InputStream)in);
        }
        catch (FileNotFoundException e) {
            LOG.error("Metadata file version #" + this.getStringVersion() + " for resource " + shortname + " not found");
            return "404";
        }
        catch (IOException e) {
            String msg = this.getText("portal.resource.metadata.error.load", new String[]{this.getStringVersion(), shortname});
            LOG.error(msg);
            this.addActionError(msg);
            return "error";
        }
        catch (ParserConfigurationException | SAXException e) {
            String msg = this.getText("portal.resource.eml.error.parse", new String[]{this.getStringVersion(), shortname});
            LOG.error(msg);
            this.addActionError(msg);
            return "error";
        }
        BigDecimal nextVersion = this.resource.getNextVersion();
        this.resource = this.generatePreviewResource(this.resource, this.eml, nextVersion);
        this.finishLoadingDetail(this.resource, this.eml, nextVersion);
        this.setPreview(true);
        return "success";
    }

    private String previewDataPackage() {
        String shortname = this.resource.getShortname();
        String type = this.resource.getCoreType();
        try {
            File metadataFile = this.dataDir.resourceDatapackageMetadataFile(shortname, type);
            LOG.debug("Loading metadata from file: " + metadataFile.getAbsolutePath());
            this.dpMetadata = (DataPackageMetadata)this.metadataReader.readValue(metadataFile, MetadataUtils.metadataClassForType((String)type));
        }
        catch (FileNotFoundException e) {
            LOG.error("Metadata file version #" + this.getStringVersion() + " for resource " + shortname + " not found");
            return "404";
        }
        catch (IOException e) {
            String msg = this.getText("portal.resource.metadata.error.load", new String[]{this.getStringVersion(), shortname});
            LOG.error(msg);
            this.addActionError(msg);
            return "error";
        }
        BigDecimal nextVersion = this.resource.getNextVersion();
        this.resource = this.generatePreviewDataPackageResource(this.resource, this.dpMetadata, nextVersion);
        this.finishLoadingDetail(this.resource, this.dpMetadata, nextVersion);
        this.setPreview(true);
        return "success";
    }

    private Resource generatePreviewResource(Resource resource, Eml eml, BigDecimal nextVersion) {
        Resource copy = new Resource();
        copy.setCoreType(resource.getCoreType());
        copy.setShortname(resource.getShortname());
        copy.setTitle(resource.getTitle());
        copy.setLastPublished(resource.getLastPublished());
        copy.setStatus(resource.getStatus());
        copy.setOrganisation(resource.getOrganisation());
        copy.setKey(resource.getKey());
        copy.setMetadataVersion(nextVersion);
        if (resource.isCitationAutoGenerated()) {
            Citation citation = new Citation();
            URI homepage = this.cfg.getResourceVersionUri(resource.getShortname(), nextVersion);
            citation.setCitation(resource.generateResourceCitation(nextVersion, homepage));
            eml.setCitation(citation);
        }
        Date releaseDate = new Date();
        copy.setLastPublished(releaseDate);
        eml.setPubDate(releaseDate);
        copy.setEml(eml);
        ArrayList histories = new ArrayList(resource.getVersionHistory());
        copy.setVersionHistory(histories);
        VersionHistory history = new VersionHistory(nextVersion, releaseDate, PublicationStatus.PUBLIC);
        User modifiedBy = this.getCurrentUser();
        if (modifiedBy != null) {
            history.setModifiedBy(modifiedBy);
        }
        if (resource.getDoi() != null && (resource.getIdentifierStatus() == IdentifierStatus.PUBLIC_PENDING_PUBLICATION || resource.getIdentifierStatus() == IdentifierStatus.PUBLIC)) {
            copy.setDoi(resource.getDoi());
            copy.setIdentifierStatus(IdentifierStatus.PUBLIC);
            history.setDoi(resource.getDoi());
            history.setStatus(IdentifierStatus.PUBLIC);
        }
        copy.addVersionHistory(history);
        return copy;
    }

    private Resource generatePreviewDataPackageResource(Resource resource, DataPackageMetadata metadata, BigDecimal nextVersion) {
        Resource copy = new Resource();
        copy.setCoreType(resource.getCoreType());
        copy.setShortname(resource.getShortname());
        copy.setTitle(resource.getTitle());
        copy.setLastPublished(resource.getLastPublished());
        copy.setStatus(resource.getStatus());
        copy.setOrganisation(resource.getOrganisation());
        copy.setKey(resource.getKey());
        copy.setDataPackageIdentifier(resource.getDataPackageIdentifier());
        copy.setMetadataVersion(nextVersion);
        Date releaseDate = new Date();
        copy.setLastPublished(releaseDate);
        copy.setDataPackageMetadata(metadata);
        ArrayList histories = new ArrayList(resource.getVersionHistory());
        copy.setVersionHistory(histories);
        VersionHistory history = new VersionHistory(nextVersion, releaseDate, PublicationStatus.PUBLIC);
        User modifiedBy = this.getCurrentUser();
        if (modifiedBy != null) {
            history.setModifiedBy(modifiedBy);
        }
        if (resource.getDoi() != null && (resource.getIdentifierStatus() == IdentifierStatus.PUBLIC_PENDING_PUBLICATION || resource.getIdentifierStatus() == IdentifierStatus.PUBLIC)) {
            copy.setDoi(resource.getDoi());
            copy.setIdentifierStatus(IdentifierStatus.PUBLIC);
            history.setDoi(resource.getDoi());
            history.setStatus(IdentifierStatus.PUBLIC);
        }
        copy.addVersionHistory(history);
        return copy;
    }

    public String detail() {
        if (this.resource == null) {
            return "404";
        }
        String name = this.resource.getShortname();
        try {
            if (this.getCurrentUser() != null && RequireManagerInterceptor.isAuthorized((User)this.getCurrentUser(), (Resource)this.resource)) {
                this.version = this.version == null ? this.findLatestPublishedVersion(this.resource) : this.version;
                PublicationStatus versionStatus = this.getPublishedVersionsPublicationStatus(this.resource, this.version);
                if (versionStatus.equals((Object)PublicationStatus.PRIVATE)) {
                    String status = this.getText("resource.status.private");
                    this.addActionWarning(this.getText("portal.resource.warning.notPublic", new String[]{status.toLowerCase()}));
                } else if (this.resource.getStatus().equals((Object)PublicationStatus.DELETED)) {
                    String status = this.getText("resource.status.deleted");
                    this.addActionWarning(this.getText("portal.resource.warning.notPublic", new String[]{status.toLowerCase()}));
                }
            } else if (this.version == null) {
                this.version = this.findLatestPublishedPublicVersion(this.resource);
                if (this.version == null) {
                    return "401";
                }
            } else {
                VersionHistory history = this.resource.findVersionHistory(this.version);
                if (history == null || history.getPublicationStatus().equals((Object)PublicationStatus.PRIVATE) || history.getPublicationStatus().equals((Object)PublicationStatus.DELETED)) {
                    return "401";
                }
            }
            if (this.resource.getLastPublishedVersionsVersion() != null && this.version.compareTo(this.resource.getLastPublishedVersionsVersion()) != 0) {
                this.addActionWarning(this.getText("portal.resource.warning.notLatest", new String[]{this.cfg.getBaseUrl() + "/resource?r=" + this.resource.getShortname()}));
            }
            if (this.resource.getDataPackageIdentifier() != null) {
                this.dpMetadata = this.loadDataPackageMetadataFromFile(name, this.resource.getCoreType(), this.version);
            } else {
                this.eml = this.loadEmlFromFile(name, this.version);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("Metadata file version #" + this.getStringVersion() + " for resource " + name + " not found");
            return "404";
        }
        catch (IOException e) {
            String msg = this.getText("portal.resource.metadata.error.load", new String[]{this.getStringVersion(), name});
            LOG.error(msg);
            this.addActionError(msg);
            return "error";
        }
        catch (ParserConfigurationException | SAXException e) {
            String msg = this.getText("portal.resource.eml.error.parse", new String[]{this.getStringVersion(), name});
            LOG.error(msg);
            this.addActionError(msg);
            return "error";
        }
        if (this.resource.isDataPackage()) {
            this.finishLoadingDetail(this.resource, this.dpMetadata, this.version);
        } else {
            this.finishLoadingDetail(this.resource, this.eml, this.version);
        }
        return "success";
    }

    List<OrganizedTaxonomicCoverage> constructOrganizedTaxonomicCoverages(List<TaxonomicCoverage> coverages) {
        ArrayList<OrganizedTaxonomicCoverage> organizedTaxonomicCoverages = new ArrayList<OrganizedTaxonomicCoverage>();
        for (TaxonomicCoverage coverage : coverages) {
            OrganizedTaxonomicCoverage organizedCoverage = new OrganizedTaxonomicCoverage();
            organizedCoverage.setDescription(coverage.getDescription());
            organizedCoverage.setKeywords(this.setOrganizedTaxonomicKeywords(coverage.getTaxonKeywords()));
            organizedTaxonomicCoverages.add(organizedCoverage);
        }
        return organizedTaxonomicCoverages;
    }

    private List<OrganizedTaxonomicKeywords> setOrganizedTaxonomicKeywords(List<TaxonKeyword> keywords) {
        ArrayList<OrganizedTaxonomicKeywords> organizedTaxonomicKeywordsList = new ArrayList<OrganizedTaxonomicKeywords>();
        HashSet<String> uniqueNamesForEmptyRank = new HashSet<String>();
        this.ranks = new LinkedHashMap();
        this.ranks.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/rank", this.getLocaleLanguage(), false));
        for (String rank : this.ranks.keySet()) {
            OrganizedTaxonomicKeywords organizedKeywords = new OrganizedTaxonomicKeywords();
            organizedKeywords.setRank(rank);
            for (TaxonKeyword keyword : keywords) {
                String displayName = this.createKeywordDisplayName(keyword);
                if (displayName == null) continue;
                if (rank.equalsIgnoreCase(keyword.getRank())) {
                    organizedKeywords.getDisplayNames().add(displayName);
                    continue;
                }
                if (StringUtils.trimToNull((String)keyword.getRank()) != null) continue;
                uniqueNamesForEmptyRank.add(displayName);
            }
            organizedTaxonomicKeywordsList.add(organizedKeywords);
        }
        if (!uniqueNamesForEmptyRank.isEmpty()) {
            OrganizedTaxonomicKeywords emptyRankKeywords = new OrganizedTaxonomicKeywords();
            emptyRankKeywords.setRank("Unranked");
            emptyRankKeywords.setDisplayNames(new ArrayList(uniqueNamesForEmptyRank));
            organizedTaxonomicKeywordsList.add(emptyRankKeywords);
        }
        return organizedTaxonomicKeywordsList;
    }

    private String createKeywordDisplayName(TaxonKeyword keyword) {
        Object combined = null;
        if (keyword != null) {
            String scientificName = StringUtils.trimToNull((String)keyword.getScientificName());
            String commonName = StringUtils.trimToNull((String)keyword.getCommonName());
            if (scientificName != null && commonName != null) {
                combined = scientificName + " (" + commonName + ")";
            } else if (scientificName != null) {
                combined = scientificName;
            } else if (commonName != null) {
                combined = commonName;
            }
        }
        return combined;
    }

    public Set<Agent> getMergedContacts() {
        if (this.mergedContacts.isEmpty()) {
            Stream.of(this.eml.getCreators(), this.eml.getMetadataProviders(), this.eml.getContacts(), this.eml.getAssociatedParties()).flatMap(Collection::stream).filter(Objects::nonNull).filter(arg_0 -> this.isValidAgent(arg_0)).filter(agent -> this.mergedContacts.stream().filter(Objects::nonNull).noneMatch(a -> this.agentsMatch(a, agent))).forEach(this.mergedContacts::add);
        }
        if (this.contactRoles.isEmpty()) {
            this.initializeContactRoles();
        }
        return this.mergedContacts;
    }

    public Set<Agent> getDeduplicatedProjectPersonnel() {
        if (this.eml.getProject() != null && this.eml.getProject().getPersonnel() != null && this.deduplicatedProjectPersonnel.isEmpty()) {
            this.eml.getProject().getPersonnel().stream().filter(Objects::nonNull).filter(agent -> this.deduplicatedProjectPersonnel.stream().filter(Objects::nonNull).noneMatch(a -> this.agentsMatch(a, agent))).forEach(this.deduplicatedProjectPersonnel::add);
        }
        if (this.projectPersonnelRoles.isEmpty()) {
            this.initializeProjectPersonnelRoles();
        }
        return this.deduplicatedProjectPersonnel;
    }

    private boolean isValidAgent(Agent agent) {
        boolean isEmptyFullName = StringUtils.isEmpty((CharSequence)agent.getFullName());
        boolean isEmptyOrganization = StringUtils.isEmpty((CharSequence)agent.getOrganisation());
        if (isEmptyFullName && isEmptyOrganization) {
            LOG.error("Invalid contact: fullname and/or organization not present. Check the metadata");
        }
        return !isEmptyFullName || !isEmptyOrganization;
    }

    private boolean agentsMatch(Agent agent1, Agent agent2) {
        boolean namesMatch = false;
        boolean emailsMatch = false;
        if (agent1.getFullName() != null && agent2.getFullName() != null) {
            namesMatch = agent1.getFullName().equals(agent2.getFullName());
        }
        if (agent1.getEmail() != null && agent2.getEmail() != null) {
            emailsMatch = true;
            if (agent1.getEmail().size() != agent2.getEmail().size()) {
                emailsMatch = false;
            } else {
                for (int i = 0; i < agent1.getEmail().size(); ++i) {
                    String email2;
                    String email1 = (String)agent1.getEmail().get(i);
                    if (email1.equalsIgnoreCase(email2 = (String)agent2.getEmail().get(i))) continue;
                    emailsMatch = false;
                    break;
                }
            }
        } else {
            emailsMatch = true;
        }
        boolean positionsMatch = agent1.getPosition() != null && agent2.getPosition() != null ? agent1.getPosition().equals(agent2.getPosition()) : true;
        return namesMatch && emailsMatch && positionsMatch;
    }

    private void initializeContactRoles() {
        for (Agent agent : this.mergedContacts) {
            HashSet<String> agentRoles = new HashSet<String>();
            if (this.eml.getCreators().stream().filter(Objects::nonNull).anyMatch(a -> this.agentsMatch(a, agent))) {
                agentRoles.add("originator");
            }
            if (this.eml.getContacts().stream().filter(Objects::nonNull).anyMatch(a -> this.agentsMatch(a, agent))) {
                agentRoles.add("pointOfContact");
            }
            if (this.eml.getMetadataProviders().stream().filter(Objects::nonNull).anyMatch(a -> this.agentsMatch(a, agent))) {
                agentRoles.add("metadataProvider");
            }
            this.eml.getAssociatedParties().stream().filter(Objects::nonNull).filter(a -> a.getRole() != null).filter(a -> this.agentsMatch(a, agent)).forEach(a -> agentRoles.add(a.getRole()));
            this.contactRoles.put(agent.getFullName(), agentRoles);
        }
    }

    private void initializeProjectPersonnelRoles() {
        if (this.eml.getProject() != null && this.eml.getProject().getPersonnel() != null) {
            for (Agent agent : this.eml.getProject().getPersonnel()) {
                if (this.projectPersonnelRoles.containsKey(agent.getFullName()) && StringUtils.isNotEmpty((CharSequence)agent.getRole())) {
                    ((Set)this.projectPersonnelRoles.get(agent.getFullName())).add(agent.getRole());
                    continue;
                }
                if (this.projectPersonnelRoles.containsKey(agent.getFullName())) continue;
                HashSet<String> agentRoles = new HashSet<String>();
                if (StringUtils.isNotEmpty((CharSequence)agent.getRole())) {
                    agentRoles.add(agent.getRole());
                }
                this.projectPersonnelRoles.put(agent.getFullName(), agentRoles);
            }
        }
    }

    public int getMaxRecordsInExtension() {
        int count = 0;
        if (!this.recordsByExtensionForVersion.isEmpty()) {
            for (String rowType : this.recordsByExtensionForVersion.keySet()) {
                int extensionCount = (Integer)this.recordsByExtensionForVersion.get(rowType);
                count = Math.max(extensionCount, count);
            }
        }
        return count;
    }

    public LinkedHashMap<String, Integer> getRecordsByExtensionOrdered() {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        this.recordsByExtensionForVersion.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder()).thenComparing(Map.Entry.comparingByKey())).forEachOrdered(x -> result.put((String)x.getKey(), (Integer)x.getValue()));
        return result;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public List<OrganizedTaxonomicCoverage> getOrganizedCoverages() {
        return this.organizedCoverages;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public Map<String, String> getPreservationMethods() {
        return this.preservationMethods;
    }

    public Map<String, String> getLanguages() {
        return this.languages;
    }

    public Map<String, String> getCountries() {
        return this.countries;
    }

    public Map<String, String> getRanks() {
        return this.ranks;
    }

    public Eml getEml() {
        return this.eml;
    }

    public void setEml(Eml eml) {
        this.eml = eml;
    }

    public DataPackageMetadata getDpMetadata() {
        return this.dpMetadata;
    }

    public Map<String, Set<String>> getContactRoles() {
        return this.contactRoles;
    }

    public Map<String, Set<String>> getProjectPersonnelRoles() {
        return this.projectPersonnelRoles;
    }

    public boolean isMetadataOnly() {
        return this.metadataOnly;
    }

    public void setMetadataOnly(boolean metadataOnly) {
        this.metadataOnly = metadataOnly;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public Map<String, String> getFrequencies() {
        return this.frequencies;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public int getRecordsPublishedForVersion() {
        return this.recordsPublishedForVersion;
    }

    public void setRecordsByExtensionForVersion(Map<String, Integer> recordsByExtensionForVersion) {
        this.recordsByExtensionForVersion = recordsByExtensionForVersion;
    }

    public String getCoreType() {
        return this.coreType;
    }

    public String getDwcaSizeForVersion() {
        return this.dwcaSizeForVersion;
    }

    public String getDataPackageSizeForVersion() {
        return this.dataPackageSizeForVersion;
    }

    public String getEmlSizeForVersion() {
        return this.emlSizeForVersion;
    }

    public String getMetadataSizeForVersion() {
        return this.metadataSizeForVersion;
    }

    public String getRtfSizeForVersion() {
        return this.rtfSizeForVersion;
    }
}

