/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.portal;

import java.math.BigDecimal;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class PortalBaseAction
extends BaseAction {
    protected ResourceManager resourceManager;
    protected Resource resource;
    protected BigDecimal version;
    public static final String UNSPECIFIED_VERSION = "unspecified";
    private static final Logger LOG = LogManager.getLogger(PortalBaseAction.class);

    @Inject
    public PortalBaseAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.resourceManager = resourceManager;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void prepare() {
        String v;
        super.prepare();
        String res = StringUtils.trimToNull((String)this.req.getParameter("r"));
        if (res == null) {
            try {
                res = (String)this.session.get("curr_resource");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (res != null) {
            this.resource = this.resourceManager.get(res);
        }
        if (StringUtils.isNotBlank((CharSequence)(v = StringUtils.trimToNull((String)this.req.getParameter("v"))))) {
            try {
                this.setVersion(new BigDecimal(v));
            }
            catch (NumberFormatException e) {
                LOG.error("Parameter version (v) was not a valid number: " + v);
            }
        }
    }

    @Nullable
    public BigDecimal getVersion() {
        return this.version;
    }

    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    protected String getStringVersion() {
        return this.version == null ? UNSPECIFIED_VERSION : String.valueOf(this.version);
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

