/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.math.BigDecimal;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.User;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class VersionHistoryAction
extends ManagerBaseAction {
    private static final Logger LOG = LogManager.getLogger(VersionHistoryAction.class);
    protected BigDecimal version;
    private String summary;

    @Inject
    public VersionHistoryAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
    }

    public void prepare() {
        super.prepare();
        String v = StringUtils.trimToNull((String)this.req.getParameter("v"));
        if (StringUtils.isNotBlank((CharSequence)v)) {
            try {
                this.setVersion(new BigDecimal(v));
            }
            catch (NumberFormatException e) {
                LOG.error("Parameter version (v) was not a valid number: " + String.valueOf(v));
            }
        }
    }

    public String save() {
        if (this.getVersion() != null && this.getResource() != null && this.getSummary() != null) {
            VersionHistory history = this.resource.findVersionHistory(this.getVersion());
            if (history != null) {
                history.setChangeSummary(this.getSummary());
                User user = this.getCurrentUser();
                if (user != null) {
                    history.setModifiedBy(user);
                }
                this.saveResource();
                return "success";
            }
            this.addActionError("The version history for version " + String.valueOf(this.getVersion()) + " does not exist!");
        }
        this.addActionError("The change summary for this version could not be updated. Please refresh the page and try again.");
        return "error";
    }

    public String back() {
        return "success";
    }

    @Nullable
    public BigDecimal getVersion() {
        return this.version;
    }

    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    public String getVersionString() {
        return this.version.toPlainString();
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = StringUtils.trimToEmpty((String)summary);
    }
}

