/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.action.manage.SourceAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.config.JdbcSupport;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.model.SqlSource;
import org.gbif.ipt.model.TextFileSource;
import org.gbif.ipt.model.UrlSource;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.ImportException;
import org.gbif.ipt.service.InvalidFilenameException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.URLUtils;
import org.gbif.utils.file.CompressionUtil;

public class SourceAction
extends ManagerBaseAction {
    private static final Logger LOG = LogManager.getLogger(SourceAction.class);
    private SourceManager sourceManager;
    private JdbcSupport jdbcSupport;
    private DataDir dataDir;
    private Source source;
    private String rdbms;
    private String problem;
    private String sqlSourcePassword;
    private String sqlSourcePasswordCache;
    private String url;
    private String sourceName;
    private File file;
    private String fileContentType;
    private String fileFileName;
    private boolean analyze = false;
    private List<String> columns;
    private List<String[]> peek;
    private int peekRows = 10;
    private int analyzeRows = 1000;
    private String sourceType;

    @Inject
    public SourceAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, SourceManager sourceManager, JdbcSupport jdbcSupport, DataDir dataDir) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.sourceManager = sourceManager;
        this.jdbcSupport = jdbcSupport;
        this.dataDir = dataDir;
    }

    public String add() throws IOException {
        if (UiSourceType.SOURCE_URL.value.equals(this.sourceType)) {
            return this.addUrlSource();
        }
        if (UiSourceType.SOURCE_FILE.value.equals(this.sourceType)) {
            return this.addFileSource();
        }
        if (UiSourceType.SOURCE_SQL.value.equals(this.sourceType)) {
            return this.addSqlSource();
        }
        this.addActionError(this.getText("manage.source.type.nullOrUnknown"));
        return "error";
    }

    private String addUrlSource() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            this.addActionError(this.getText("manage.source.url.empty"));
            return "error";
        }
        if (StringUtils.isEmpty((CharSequence)this.sourceName)) {
            this.addActionError(this.getText("manage.source.name.empty"));
            return "error";
        }
        this.source = new UrlSource();
        this.source.setResource(this.resource);
        URI urlWrapped = URI.create(this.url);
        try {
            boolean extensionNotAllowed;
            HttpURLConnection connection = (HttpURLConnection)urlWrapped.toURL().openConnection();
            int responseCode = connection.getResponseCode();
            if (responseCode == 404) {
                LOG.error("Can't read URL {} : Not Found", (Object)this.url);
                this.addActionError(this.getText("manage.source.url.notFound", new String[]{this.url}));
                return "error";
            }
            String extension = FilenameUtils.getExtension((String)this.url);
            boolean bl = extensionNotAllowed = !extension.isEmpty() && !StringUtils.equalsAny((CharSequence)extension, (CharSequence[])new CharSequence[]{"txt", "tsv", "csv", "zip"});
            if (extensionNotAllowed) {
                LOG.debug("No extension in the URL, checking content type.");
                String contentType = URLUtils.getUrlContentType((String)this.url);
                LOG.debug("Content type confirmed: {}", (Object)contentType);
                if (!URLUtils.VALID_CONTENT_TYPES.contains(contentType)) {
                    LOG.error("Not allowed content type: {}", (Object)contentType);
                    this.addActionError(this.getText("manage.source.url.invalidExtension", new String[]{this.url, extension}));
                    return "error";
                }
            }
        }
        catch (IOException | MimeTypeParseException e) {
            LOG.error("Failed to create a URL source: {}", (Object)e.getMessage());
            this.addActionError(this.getText("manage.source.url.invalid", new String[]{this.url}));
            return "error";
        }
        this.addUrl(urlWrapped);
        return "success";
    }

    private String addFileSource() {
        if (StringUtils.endsWithAny((CharSequence)this.fileContentType.toLowerCase(), (CharSequence[])new CharSequence[]{"zip", "gzip", "compressed"})) {
            try {
                File tmpDir = this.dataDir.tmpDir();
                String unzippedFileName = this.fileFileName != null ? this.fileFileName.substring(0, this.fileFileName.lastIndexOf(".")) : null;
                List files = CompressionUtil.decompressFile((File)tmpDir, (File)this.file, unzippedFileName);
                this.addActionMessage(this.getText("manage.source.compressed.files", new String[]{String.valueOf(files.size())}));
                for (File f : files) {
                    this.addDataFile(f, f.getName());
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                this.addErrorHeader("manage.source.filesystem.error");
                this.addActionError(this.getText("manage.source.filesystem.error", new String[]{e.getMessage()}));
                return "error";
            }
            catch (CompressionUtil.UnsupportedCompressionType e) {
                LOG.error((Object)e);
                this.addErrorHeader("manage.source.unsupported.compression.format");
                this.addActionError(this.getText("manage.source.unsupported.compression.format"));
                return "error";
            }
            catch (InvalidFilenameException e) {
                LOG.error((Object)e);
                this.addErrorHeader("manage.source.invalidFileName.archive");
                this.addActionError(this.getText("manage.source.invalidFileName.archive"));
                return "error";
            }
            catch (Exception e) {
                LOG.error((Object)e);
                this.addErrorHeader("manage.source.upload.unexpectedException");
                this.addActionError(this.getText("manage.source.upload.unexpectedException"));
                return "error";
            }
        }
        try {
            this.addDataFile(this.file, this.fileFileName);
        }
        catch (InvalidFilenameException e) {
            LOG.error((Object)e);
            this.addErrorHeader("manage.source.invalidFileName");
            this.addActionError(this.getText("manage.source.invalidFileName"));
            return "error";
        }
        catch (Exception e) {
            LOG.error((Object)e);
            this.addErrorHeader("manage.source.upload.unexpectedException");
            this.addActionError(this.getText("manage.source.upload.unexpectedException"));
            return "error";
        }
        return "success";
    }

    private void addErrorHeader(String value) {
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setHeader("X-Error-Message", this.getText(value));
    }

    private String addSqlSource() {
        if (StringUtils.isEmpty((CharSequence)this.sourceName)) {
            this.addActionError(this.getText("manage.source.name.empty"));
            return "error";
        }
        this.source = new SqlSource();
        this.source.setResource(this.resource);
        this.source.setName(this.sourceName);
        ((SqlSource)this.source).setRdbms(this.jdbcSupport.get("mysql"));
        try {
            this.resource.addSource(this.source, true);
        }
        catch (AlreadyExistingException e) {
            this.addActionError(this.getText("manage.source.existing"));
            return "error";
        }
        this.resource.setSourcesModified(new Date());
        this.saveResource();
        this.id = this.source.getName();
        return "success";
    }

    private void addUrl(URI url) {
        Source existingSource = this.resource.getSource(this.sourceName);
        boolean replaced = existingSource != null;
        try {
            this.source = this.sourceManager.add(this.resource, url, this.sourceName);
            this.resource.setSourcesModified(new Date());
            this.saveResource();
            this.id = this.source.getName();
            if (replaced) {
                this.addActionMessage(this.getText("manage.source.replaced.existing", new String[]{this.source.getName()}));
                this.alertColumnNumberChange(this.resource.hasMappedSource(existingSource), this.source.getColumns(), existingSource.getColumns());
            } else {
                this.addActionMessage(this.getText("manage.source.added.new", new String[]{this.source.getName()}));
            }
        }
        catch (ImportException e) {
            LOG.error("Cannot add URL source " + String.valueOf(url), (Throwable)e);
            this.addActionError(this.getText("manage.source.cannot.add", new String[]{this.sourceName, e.getMessage()}));
        }
    }

    private void addDataFile(File f, String filename) throws InvalidFilenameException {
        Source existingSource = this.resource.getSource(filename);
        boolean replaced = existingSource != null;
        try {
            this.source = this.sourceManager.add(this.resource, f, filename);
            this.resource.setSourcesModified(new Date());
            this.saveResource();
            this.id = this.source.getName();
            if (replaced) {
                this.addActionMessage(this.getText("manage.source.replaced.existing", new String[]{this.source.getName()}));
                this.alertColumnNumberChange(this.resource.hasMappedSource(existingSource), this.source.getColumns(), existingSource.getColumns());
            } else {
                this.addActionMessage(this.getText("manage.source.added.new", new String[]{this.source.getName()}));
            }
        }
        catch (ImportException e) {
            LOG.error("Cannot add source " + filename + ": " + e.getMessage(), (Throwable)e);
            this.addActionError(this.getText("manage.source.cannot.add", new String[]{filename, e.getMessage()}));
        }
        catch (InvalidFilenameException e) {
            throw e;
        }
    }

    protected boolean alertColumnNumberChange(boolean sourceIsMapped, int number, int originalNumber) {
        if (sourceIsMapped && originalNumber != number) {
            this.addActionWarning(this.getText("manage.source.numColumns.changed", new String[]{this.source.getName(), String.valueOf(originalNumber), String.valueOf(number)}));
            return true;
        }
        return false;
    }

    public String delete() {
        if (this.sourceManager.delete(this.resource, this.resource.getSource(this.id))) {
            this.addActionMessage(this.getText("manage.source.deleted", new String[]{this.id}));
            this.resource.setSourcesModified(new Date());
            this.saveResource();
        } else {
            this.addActionMessage(this.getText("manage.source.deleted.couldnt", new String[]{this.id}));
        }
        return "success";
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public TextFileSource getFileSource() {
        if (this.source instanceof TextFileSource) {
            return (TextFileSource)this.source;
        }
        return null;
    }

    public Map<String, String> getJdbcOptions() {
        return this.jdbcSupport.optionMap();
    }

    public boolean getLogExists() {
        return this.dataDir.sourceLogFile(this.resource.getShortname(), this.source.getName()).exists();
    }

    public List<String[]> getPeek() {
        return this.peek;
    }

    public int getPreviewSize() {
        return this.peekRows;
    }

    public String getProblem() {
        return this.problem;
    }

    public String getRdbms() {
        return this.rdbms;
    }

    public String getSqlSourcePassword() {
        return this.sqlSourcePassword;
    }

    public Source getSource() {
        return this.source;
    }

    public SqlSource getSqlSource() {
        if (this.source instanceof SqlSource) {
            return (SqlSource)this.source;
        }
        return null;
    }

    public String peek() {
        if (this.source == null) {
            return "404";
        }
        this.peek = this.sourceManager.peek(this.source, this.peekRows);
        this.columns = this.sourceManager.columns(this.source);
        return "success";
    }

    public void prepare() {
        super.prepare();
        this.session.remove("numberColumns");
        if (this.id != null) {
            String pw;
            this.source = this.resource.getSource(this.id);
            if (this.source == null) {
                LOG.error("No source with id " + this.id + " found!");
                this.addActionError(this.getText("manage.source.cannot.load", new String[]{this.id}));
            } else {
                this.session.put("numberColumns", this.source.getColumns());
            }
            if (this.source instanceof SqlSource && StringUtils.isNotEmpty((CharSequence)(pw = ((SqlSource)this.source).getPassword()))) {
                this.sqlSourcePasswordCache = pw;
            }
        } else if (this.file == null) {
            this.source = new SqlSource();
            this.source.setResource(this.resource);
            ((SqlSource)this.source).setRdbms(this.jdbcSupport.get("mysql"));
        } else {
            this.source = new TextFileSource();
            this.source.setResource(this.resource);
        }
    }

    public String save() throws IOException {
        if (this.source != null) {
            this.source.setLastModified(new Date());
        }
        if (this.source != null && this.rdbms != null) {
            ((SqlSource)this.source).setRdbms(this.jdbcSupport.get(this.rdbms));
        }
        String result = "input";
        if (this.id != null && this.source != null) {
            if (this.analyze || !this.source.isReadable()) {
                this.problem = this.sourceManager.analyze(this.source);
                result = "analyze";
                if (this.problem == null) {
                    if (this.source instanceof UrlSource) {
                        this.addActionMessage(this.getText("manage.source.analyze.inProcess"));
                    } else {
                        this.addActionMessage(this.getText("manage.source.analyzed"));
                    }
                } else {
                    this.addActionError(this.getText("manage.source.analyzed.problem", new String[]{this.problem}));
                }
            } else {
                result = "success";
            }
        }
        this.resource.setSourcesModified(new Date());
        this.saveResource();
        return result;
    }

    public void setAnalyze(String analyze) {
        if (StringUtils.trimToNull((String)analyze) != null) {
            this.analyze = true;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileContentType(String fileContentType) {
        this.fileContentType = fileContentType;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public void setRdbms(String jdbc) {
        this.rdbms = jdbc;
        if (this.source != null && this.source instanceof SqlSource) {
            ((SqlSource)this.source).setRdbms(this.jdbcSupport.get(this.rdbms));
        }
    }

    public void setSqlSourcePassword(String sqlSourcePassword) {
        if (this.source != null && this.source instanceof SqlSource && StringUtils.isNotBlank((CharSequence)sqlSourcePassword)) {
            ((SqlSource)this.source).setPassword(sqlSourcePassword);
            this.analyze = true;
        }
    }

    public void setRows(int previewSize) {
        this.peekRows = previewSize > 0 ? previewSize : 10;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void validateHttpPostOnly() {
        if (this.source != null) {
            Integer originalNumberColumns;
            if (StringUtils.trimToEmpty((String)this.source.getName()).length() == 0) {
                this.addFieldError("source.name", this.getText("validation.required", new String[]{this.getText("source.name")}));
            } else if (StringUtils.trimToEmpty((String)this.source.getName()).length() < 3) {
                this.addFieldError("source.name", this.getText("validation.short", new String[]{this.getText("source.name"), "3"}));
            } else if (this.id == null && this.resource.getSources().contains(this.source)) {
                this.addFieldError("source.name", this.getText("manage.source.unique"));
            }
            if (this.source instanceof SqlSource) {
                SqlSource src = (SqlSource)this.source;
                if (StringUtils.isEmpty((CharSequence)src.getPassword()) && StringUtils.isNotEmpty((CharSequence)this.sqlSourcePasswordCache)) {
                    ((SqlSource)this.source).setPassword(this.sqlSourcePasswordCache);
                }
                if (StringUtils.trimToEmpty((String)src.getHost()).length() == 0 && this.rdbms != null && !this.rdbms.equalsIgnoreCase("odbc")) {
                    this.addFieldError("sqlSource.host", this.getText("validation.required", new String[]{this.getText("sqlSource.host")}));
                } else if (StringUtils.trimToEmpty((String)src.getHost()).length() < 2) {
                    this.addFieldError("sqlSource.host", this.getText("validation.short", new String[]{this.getText("sqlSource.host"), "2"}));
                }
                if (StringUtils.trimToEmpty((String)src.getDatabase()).length() == 0) {
                    this.addFieldError("sqlSource.database", this.getText("validation.required", new String[]{this.getText("sqlSource.database")}));
                } else if (StringUtils.trimToEmpty((String)src.getDatabase()).length() < 2) {
                    this.addFieldError("sqlSource.database", this.getText("validation.short", new String[]{this.getText("sqlSource.database"), "2"}));
                }
            }
            if ((originalNumberColumns = (Integer)this.session.get("numberColumns")) != null) {
                this.alertColumnNumberChange(this.resource.hasMappedSource(this.source), this.sourceManager.columns(this.source).size(), originalNumberColumns.intValue());
            }
        }
    }
}

