/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class ResourceFileAction
extends ManagerBaseAction {
    private static final Logger LOG = LogManager.getLogger(ResourceFileAction.class);
    private static final long serialVersionUID = -3304799051086050164L;
    private final DataDir dataDir;
    private InputStream inputStream;
    protected File data;
    protected String mimeType = "text/plain";
    protected String filename;

    @Inject
    public ResourceFileAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, DataDir dataDir, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.dataDir = dataDir;
    }

    public String metadata() {
        if (this.resource == null) {
            return "404";
        }
        boolean isDataPackageResource = this.resource.getDataPackageIdentifier() != null;
        StringBuilder sb = new StringBuilder();
        if (isDataPackageResource) {
            if ("coldp".equals(this.resource.getCoreType())) {
                this.data = this.dataDir.resourceDatapackageMetadataFile(this.resource.getShortname(), this.resource.getCoreType());
                this.mimeType = "text/yaml";
                sb.append("metadata-").append(this.resource.getShortname());
                sb.append(".yaml");
            } else {
                this.data = this.dataDir.resourceDatapackageMetadataFile(this.resource.getShortname(), this.resource.getCoreType());
                this.mimeType = "application/json";
                sb.append("datapackage-").append(this.resource.getShortname());
                sb.append(".json");
            }
        } else {
            this.data = this.dataDir.resourceEmlFile(this.resource.getShortname());
            this.mimeType = "text/xml";
            sb.append("eml-").append(this.resource.getShortname());
            sb.append(".xml");
        }
        this.filename = sb.toString();
        return this.execute();
    }

    public String execute() {
        if (this.data == null) {
            return "404";
        }
        if (this.filename == null) {
            this.filename = this.data.getName();
        }
        try {
            this.inputStream = new FileInputStream(this.data);
            long lastModified = 1000L * ((this.data.lastModified() + 500L) / 1000L);
            this.response.setDateHeader("Last-Modified", lastModified);
            try {
                long since = this.req.getDateHeader("If-Modified-Since");
                if (since >= lastModified) {
                    return "304";
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Conditional get with If-Modified-Since header couldn't be interpreted", (Throwable)e);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn("Data dir file not found", (Throwable)e);
            return "404";
        }
        return "success";
    }

    public void prepare() {
        super.prepare();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public File getData() {
        return this.data;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFilename() {
        return this.filename;
    }
}

