/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.MapUtils;
import org.gbif.metadata.eml.ipt.model.MaintenanceUpdateFrequency;

public class PublicationSettingsAction
extends ManagerBaseAction {
    private final VocabulariesManager vocabManager;
    private Organisation organisation;
    private Map<String, String> organisations;
    private Map<String, String> autoPublishFrequencies;

    @Inject
    public PublicationSettingsAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, VocabulariesManager vocabManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.vocabManager = vocabManager;
    }

    public void prepare() {
        super.prepare();
        this.loadOrganisations();
        this.organisation = StringUtils.isEmpty((CharSequence)this.id) ? null : this.registrationManager.get(this.id);
        this.autoPublishFrequencies = new LinkedHashMap();
        Map filteredFrequencies = this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/eml/updateFrequency", this.getLocaleLanguage(), false);
        MapUtils.removeNonMatchingKeys((Map)filteredFrequencies, (List)MaintenanceUpdateFrequency.NON_ZERO_DAYS_UPDATE_PERIODS);
        this.autoPublishFrequencies.putAll(filteredFrequencies);
    }

    public String save() {
        if (StringUtils.isEmpty((CharSequence)this.id)) {
            this.addFieldError("id", this.getText("validation.required", new String[]{this.getText("portal.home.organisation")}));
            return "input";
        }
        this.organisation = this.registrationManager.get(this.id);
        if (this.organisation == null) {
            this.addFieldError("id", this.getText("eml.publishingOrganisation.notFound", this.id));
            return "input";
        }
        this.resource.setOrganisation(this.organisation);
        this.resourceManager.save(this.resource);
        if (this.resource.isAlreadyAssignedDoi() || this.resource.isRegistered()) {
            this.addActionMessage(this.getText("manage.publicationSettings.success.registered", new String[]{"<a href=\"mailto:helpdesk@gbif.org\">Help Desk</a>"}));
        } else {
            this.addActionMessage(this.getText("manage.publicationSettings.success"));
        }
        return "success";
    }

    private void loadOrganisations() {
        List associatedOrganisations = this.registrationManager.list();
        this.organisations = new LinkedHashMap();
        if (!associatedOrganisations.isEmpty()) {
            this.organisations.put("", this.getText("admin.organisation.name.select"));
            Organisation noOrganisation = this.getDefaultOrganisation();
            if (noOrganisation != null) {
                this.organisations.put(noOrganisation.getKey().toString(), this.getText("eml.publishingOrganisation.none"));
            }
            for (Organisation o : associatedOrganisations) {
                if (Constants.DEFAULT_ORG_KEY.equals(o.getKey())) continue;
                this.organisations.put(o.getKey().toString(), o.getName());
            }
        }
    }

    public Map<String, String> getOrganisations() {
        return this.organisations;
    }

    public Map<String, String> getAutoPublishFrequencies() {
        return this.autoPublishFrequencies;
    }
}

