/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.common.DoiData;
import org.gbif.api.model.common.DoiStatus;
import org.gbif.doi.metadata.datacite.DataCiteMetadata;
import org.gbif.doi.service.DoiException;
import org.gbif.doi.service.DoiExistsException;
import org.gbif.doi.service.InvalidMetadataException;
import org.gbif.dwc.Archive;
import org.gbif.dwc.ArchiveFile;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.i18n.I18n;
import org.gbif.ipt.i18n.StrutsI18n;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.KeyNamePair;
import org.gbif.ipt.model.Network;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.model.User;
import org.gbif.ipt.model.VersionHistory;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessLicense;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapLicense;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapMetadata;
import org.gbif.ipt.model.datapackage.metadata.col.ColMetadata;
import org.gbif.ipt.model.voc.DOIRegistrationAgency;
import org.gbif.ipt.model.voc.IdentifierStatus;
import org.gbif.ipt.model.voc.MetadataSection;
import org.gbif.ipt.model.voc.PublicationStatus;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.ImportException;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.PublicationException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.UndeletNotAllowedException;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.UserAccountManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.task.GenerateDataPackageFactory;
import org.gbif.ipt.task.GenerateDwca;
import org.gbif.ipt.task.GenerateDwcaFactory;
import org.gbif.ipt.task.ReportHandler;
import org.gbif.ipt.task.StatusReport;
import org.gbif.ipt.task.TaskMessage;
import org.gbif.ipt.utils.DOIUtils;
import org.gbif.ipt.utils.DataCiteMetadataBuilder;
import org.gbif.ipt.utils.MapUtils;
import org.gbif.ipt.utils.ResourceUtils;
import org.gbif.ipt.validation.ActionValidationResult;
import org.gbif.ipt.validation.DataPackageMetadataValidator;
import org.gbif.ipt.validation.EmlValidator;
import org.gbif.ipt.validation.SectionErrorCollector;
import org.gbif.metadata.eml.InvalidEmlException;
import org.gbif.metadata.eml.ipt.EmlFactory;
import org.gbif.metadata.eml.ipt.model.Citation;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.MaintenanceUpdateFrequency;
import org.gbif.utils.file.csv.CSVReader;
import org.gbif.utils.file.csv.CSVReaderFactory;
import org.xml.sax.SAXException;

public class OverviewAction
extends ManagerBaseAction
implements ReportHandler {
    private static final Logger LOG = LogManager.getLogger(OverviewAction.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    private static final DateFormat DATE_FORMAT_UI = new SimpleDateFormat("d MMMM yyyy HH:mm");
    private static final String PUBLISHING = "publishing";
    private static final TermFactory TERM_FACTORY = TermFactory.instance();
    private List<User> potentialManagers;
    private List<KeyNamePair> allNetworks = new ArrayList();
    private List<KeyNamePair> potentialNetworks = new ArrayList();
    private List<Extension> potentialCores;
    private List<Extension> potentialExtensions;
    private List<Organisation> organisations;
    private Organisation doiAccount;
    private final EmlValidator emlValidator;
    private final DataPackageMetadataValidator dataPackageMetadataValidator;
    private boolean missingBasicMetadata;
    private boolean validMetadata;
    private SectionErrorCollector errorCollector;
    private boolean missingRegistrationMetadata;
    private boolean missingValidPublishingOrganisation;
    private boolean metadataModifiedSinceLastPublication;
    private boolean mappingsModifiedSinceLastPublication;
    private boolean sourcesModifiedSinceLastPublication;
    private Map<String, String> autoPublishFrequencies;
    private StatusReport report;
    private Date now;
    private File emlFile;
    private File datapackageMetadataFile;
    private String datapackageMetadataRaw;
    private boolean unpublish = false;
    private boolean reserveDoi = false;
    private boolean deleteDoi = false;
    private boolean undelete = false;
    private boolean publish = false;
    private boolean validateEml = false;
    private boolean networksAvailable = true;
    private boolean outdatedExtensions = false;
    private boolean validateDatapackageMetadata = false;
    private String summary;
    private String makePublicDateTime;
    private long usableSpace;
    private String freeDiscSpaceReadable;
    private GenerateDwcaFactory dwcaFactory;
    private GenerateDataPackageFactory dataPackageFactory;
    private List<String> columns;
    private List<String[]> peek;
    private Integer mid;
    private static final int PEEK_ROWS = 100;
    private final VocabulariesManager vocabManager;
    private final RegistryManager registryManager;
    private final UserAccountManager userManager;
    private final ExtensionManager extensionManager;
    private final DataPackageSchemaManager schemaManager;

    @Inject
    public OverviewAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, UserAccountManager userAccountManager, ExtensionManager extensionManager, GenerateDwcaFactory dwcaFactory, GenerateDataPackageFactory dataPackageFactory, VocabulariesManager vocabManager, RegistryManager registryManager, DataPackageSchemaManager schemaManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.userManager = userAccountManager;
        this.extensionManager = extensionManager;
        this.emlValidator = new EmlValidator(cfg, registrationManager, textProvider);
        this.dataPackageMetadataValidator = new DataPackageMetadataValidator();
        this.dwcaFactory = dwcaFactory;
        this.dataPackageFactory = dataPackageFactory;
        this.doiAccount = registrationManager.findPrimaryDoiAgencyAccount();
        this.vocabManager = vocabManager;
        this.registryManager = registryManager;
        this.schemaManager = schemaManager;
    }

    public String addNetwork() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        try {
            this.registryManager.addResourceToNetwork(this.resource, this.id);
            this.saveResource();
            Optional<KeyNamePair> keyNameNetwork = this.getAllNetworks().stream().filter(n -> n.getKey().equals(this.id)).findFirst();
            if (keyNameNetwork.isPresent()) {
                this.addActionMessage(this.getText("manage.overview.networks.add.success", new String[]{keyNameNetwork.get().getName()}));
            } else {
                this.addActionMessage(this.getText("manage.overview.networks.add.success", new String[]{this.id}));
            }
            this.potentialNetworks.removeIf(n -> Objects.equals(n.getKey(), this.id));
        }
        catch (IllegalArgumentException e) {
            this.addActionError(this.getText("manage.overview.networks.add.failed"));
        }
        return this.execute();
    }

    public String addManager() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        User u = this.userManager.get(this.id);
        if (u != null && !this.potentialManagers.contains(u)) {
            this.addActionError(this.getText("manage.overview.manager.not.available", new String[]{this.id}));
        } else if (u != null) {
            this.resource.addManager(u);
            this.addActionMessage(this.getText("manage.overview.user.added", new String[]{u.getName()}));
            this.saveResource();
            this.potentialManagers.remove(u);
        }
        return this.execute();
    }

    public String cancel() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        boolean cancelled = this.resourceManager.cancelPublishing(this.resource.getShortname(), (BaseAction)this);
        if (cancelled) {
            BigDecimal version = this.resource.getMetadataVersion();
            String msg = this.getText("publishing.cancelled", new String[]{version.toPlainString(), this.resource.getShortname()});
            LOG.warn(msg);
            this.addActionError(msg);
            this.resourceManager.restoreVersion(this.resource, version, (BaseAction)this);
            this.report = new StatusReport(true, "Archive generation cancelled", this.report.getMessages());
            return this.execute();
        }
        this.addActionError(this.getText("manage.overview.failed.stop.publishing"));
        return "error";
    }

    public String deleteFromIpt() {
        if (this.resource == null) {
            return "404";
        }
        if (this.delete) {
            if (this.resource.getStatus().equals((Object)PublicationStatus.DELETED)) {
                this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
                return "input";
            }
            try {
                this.resourceManager.deleteResourceFromIpt(this.resource);
                this.addActionMessage(this.getText("manage.overview.resource.deleteFromIpt.successful", new String[]{this.resource.getShortname()}));
                return "home";
            }
            catch (IOException e) {
                String msg = this.getText("manage.resource.delete.failed");
                LOG.error(msg, (Throwable)e);
                this.addActionError(msg);
                this.addActionExceptionWarning((Exception)e);
            }
        } else {
            this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
        }
        return "success";
    }

    public String delete() {
        if (this.resource == null) {
            return "404";
        }
        if (this.delete) {
            if (this.resource.getStatus().equals((Object)PublicationStatus.DELETED)) {
                this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
                return "input";
            }
            try {
                DOI doi = this.resource.getDoi();
                if (doi != null) {
                    if (this.registrationManager.getDoiService() == null) {
                        String msg = this.getText("manage.overview.doi.operation.failed.noAccount");
                        LOG.error(msg);
                        this.addActionError(msg);
                        return "input";
                    }
                    if (this.resource.isRegistered()) {
                        this.resourceManager.delete(this.resource, false);
                    }
                    this.doDeactivateDOI(doi);
                    this.resource.setIdentifierStatus(this.resource.getIdentifierStatus().equals((Object)IdentifierStatus.PUBLIC_PENDING_PUBLICATION) ? IdentifierStatus.UNRESERVED : IdentifierStatus.UNAVAILABLE);
                    HashSet<String> deleted = new HashSet<String>();
                    deleted.add(doi.toString());
                    if (!this.resource.getVersionHistory().isEmpty()) {
                        for (VersionHistory history : this.resource.getVersionHistory()) {
                            DOI formerDoi = history.getDoi();
                            if (formerDoi == null || deleted.contains(formerDoi.toString())) continue;
                            this.doDeactivateDOI(formerDoi);
                            deleted.add(formerDoi.toString());
                        }
                    }
                    this.resource.setStatus(PublicationStatus.DELETED);
                    this.resource.updateAlternateIdentifierForDOI();
                    this.resource.updateCitationIdentifierForDOI();
                    this.saveResource();
                    this.addActionMessage(this.getText("manage.overview.resource.deleted", new String[]{this.resource.toString()}));
                } else {
                    this.resourceManager.delete(this.resource, true);
                }
                return "home";
            }
            catch (IOException | DeletionNotAllowedException e) {
                String msg = this.getText("manage.resource.delete.failed");
                LOG.error(msg, e);
                this.addActionError(msg);
                this.addActionExceptionWarning((Exception)e);
            }
        } else {
            this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
        }
        return "success";
    }

    private void doDeactivateDOI(DOI doi) throws DeletionNotAllowedException {
        block7: {
            Objects.requireNonNull(this.registrationManager.getDoiService());
            Objects.requireNonNull(doi);
            try {
                DoiData doiData = this.registrationManager.getDoiService().resolve(doi);
                if (doiData.getStatus() != null) {
                    if (doiData.getStatus().equals((Object)DoiStatus.RESERVED)) {
                        LOG.info("Deleting reserved DOI: " + String.valueOf(doi) + "...");
                        this.registrationManager.getDoiService().delete(doi);
                        String msg = this.getText("manage.overview.publishing.doi.delete.success", new String[]{doi.toString()});
                        LOG.info(msg);
                        this.addActionMessage(msg);
                    } else if (doiData.getStatus().equals((Object)DoiStatus.REGISTERED)) {
                        LOG.info("Deactivating registered DOI: " + String.valueOf(doi) + "...");
                        this.registrationManager.getDoiService().delete(doi);
                        String msg = this.getText("manage.overview.publishing.doi.deactivate.success", new String[]{doi.toString()});
                        LOG.info(msg);
                        this.addActionMessage(msg);
                    } else {
                        LOG.error("Not appropriate to delete DOI: " + String.valueOf(doi) + ". DOI status=" + doiData.getStatus().toString());
                    }
                    break block7;
                }
                throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.DOI_REGISTRATION_AGENCY_ERROR, this.getText("manage.overview.publishing.doi.delete.failed.notResolved", new String[]{doi.toString()}));
            }
            catch (DoiException e) {
                throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.DOI_REGISTRATION_AGENCY_ERROR, this.getText("manage.overview.publishing.doi.delete.failed.exception", new String[]{doi.toString(), e.getMessage()}));
            }
        }
    }

    public String undelete() {
        if (this.resource == null) {
            return "404";
        }
        if (this.undelete) {
            if (!this.resource.getStatus().equals((Object)PublicationStatus.DELETED)) {
                this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
                return "input";
            }
            DOI doi = this.resource.getAssignedDoi();
            if (doi != null) {
                try {
                    if (this.registrationManager.getDoiService() == null) {
                        String msg = this.getText("manage.overview.doi.operation.failed.noAccount");
                        LOG.error(msg);
                        this.addActionError(msg);
                        return "input";
                    }
                    Organisation organisation = this.resource.getOrganisation();
                    if (organisation == null) {
                        throw new InvalidConfigException(InvalidConfigException.TYPE.RESOURCE_CONFIG, "Resource being undeleted missing publishing organisation!");
                    }
                    Organisation retrieved = this.registrationManager.get(organisation.getKey());
                    if (retrieved == null) {
                        throw new UndeletNotAllowedException(UndeletNotAllowedException.Reason.ORGANISATION_NOT_ASSOCIATED_TO_IPT, this.getText("manage.overview.publishing.doi.undelete.failed.noOrganisation", new String[]{organisation.getKey().toString()}));
                    }
                    Organisation doiAccountActivated = this.registrationManager.findPrimaryDoiAgencyAccount();
                    if (doiAccountActivated != null && doiAccountActivated.getDoiPrefix() != null && !doi.getDoiName().toLowerCase().startsWith(doiAccountActivated.getDoiPrefix().toLowerCase())) {
                        throw new UndeletNotAllowedException(UndeletNotAllowedException.Reason.DOI_PREFIX_NOT_MATCHING, this.getText("manage.overview.publishing.doi.undelete.failed.badPrefix", new String[]{doi.toString(), doiAccountActivated.getDoiPrefix()}));
                    }
                    String shortname = this.resource.getShortname();
                    BigDecimal versionToUndelete = this.resource.getLastPublishedVersionsVersion();
                    UUID key = this.resource.getKey();
                    File versionToUndeleteEmlFile = this.cfg.getDataDir().resourceEmlFile(shortname, versionToUndelete);
                    Resource reconstructed = ResourceUtils.reconstructVersion((BigDecimal)versionToUndelete, (String)shortname, (String)this.resource.getCoreType(), (String)this.resource.getDataPackageIdentifier(), (DOI)doi, (Organisation)organisation, (VersionHistory)this.resource.findVersionHistory(versionToUndelete), (File)versionToUndeleteEmlFile, (UUID)key);
                    URI target = this.cfg.getResourceUri(shortname);
                    this.doUndeleteDOI(doi, reconstructed, target);
                    this.resource.setDoi(doi);
                    this.resource.setIdentifierStatus(IdentifierStatus.PUBLIC);
                    this.resource.updateCitationIdentifierForDOI();
                    HashSet<String> undeleted = new HashSet<String>();
                    undeleted.add(doi.toString());
                    if (!this.resource.getVersionHistory().isEmpty()) {
                        for (VersionHistory history : this.resource.getVersionHistory()) {
                            DOI formerDoi = history.getDoi();
                            if (formerDoi == null || undeleted.contains(formerDoi.toString())) continue;
                            BigDecimal formerVersionToUndelete = new BigDecimal(history.getVersion());
                            File formerVersionToUndeleteEmlFile = this.cfg.getDataDir().resourceEmlFile(shortname, formerVersionToUndelete);
                            Resource formerVersionReconstructed = ResourceUtils.reconstructVersion((BigDecimal)formerVersionToUndelete, (String)shortname, (String)this.resource.getCoreType(), (String)this.resource.getDataPackageIdentifier(), (DOI)formerDoi, (Organisation)organisation, (VersionHistory)this.resource.findVersionHistory(formerVersionToUndelete), (File)formerVersionToUndeleteEmlFile, (UUID)key);
                            URI formerTarget = this.cfg.getResourceVersionUri(shortname, formerVersionToUndelete);
                            this.doUndeleteDOI(formerDoi, formerVersionReconstructed, formerTarget);
                            undeleted.add(formerDoi.toString());
                        }
                    }
                    if (reconstructed.isRegistered()) {
                        this.resource.setStatus(PublicationStatus.REGISTERED);
                        this.addActionWarning(this.getText("manage.overview.resource.undelete.warning.gbif"));
                    } else {
                        this.resource.setStatus(PublicationStatus.PUBLIC);
                    }
                    this.saveResource();
                    this.addActionMessage(this.getText("manage.overview.resource.undeleted", new String[]{this.resource.getTitleAndShortname()}));
                    return "success";
                }
                catch (IllegalArgumentException | UndeletNotAllowedException e) {
                    String msg = this.getText("manage.resource.undelete.failed");
                    LOG.error(msg, e);
                    this.addActionError(msg);
                    this.addActionExceptionWarning((Exception)e);
                }
            } else {
                this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
            }
        } else {
            this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
        }
        return "input";
    }

    private void doUndeleteDOI(DOI doi, Resource resource, URI target) throws UndeletNotAllowedException {
        Objects.requireNonNull(this.registrationManager.getDoiService());
        Objects.requireNonNull(doi);
        Objects.requireNonNull(resource);
        Objects.requireNonNull(target);
        try {
            DoiData doiData = this.registrationManager.getDoiService().resolve(doi);
            if (doiData.getStatus() != DoiStatus.NEW && doiData.getStatus() != DoiStatus.DELETED) {
                throw new UndeletNotAllowedException(UndeletNotAllowedException.Reason.DOI_NOT_DELETED, this.getText("manage.overview.publishing.doi.undelete.failed.badStatus", new String[]{doi.toString(), doiData.getStatus().toString()}));
            }
            LOG.info("Undeleting deleted DOI: " + String.valueOf(doi) + "...");
            DataCiteMetadata dataCiteMetadata = DataCiteMetadataBuilder.createDataCiteMetadata((DOI)doi, (Resource)resource);
            this.registrationManager.getDoiService().register(doi, target, dataCiteMetadata);
            String msg = this.getText("manage.overview.publishing.doi.undelete.success", new String[]{doi.toString()});
            LOG.info(msg);
            this.addActionMessage(msg);
        }
        catch (DoiException e) {
            throw new UndeletNotAllowedException(UndeletNotAllowedException.Reason.DOI_REGISTRATION_AGENCY_ERROR, this.getText("manage.overview.publishing.doi.undelete.failed.exception", new String[]{doi.toString(), e.getMessage()}));
        }
    }

    public String deleteNetwork() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        try {
            this.registryManager.removeResourceFromNetwork(this.resource, this.id);
            this.saveResource();
            Optional<KeyNamePair> keyNameNetwork = this.getAllNetworks().stream().filter(n -> n.getKey().equals(this.id)).findFirst();
            if (keyNameNetwork.isPresent()) {
                this.addActionMessage(this.getText("manage.overview.networks.delete.success", new String[]{keyNameNetwork.get().getName()}));
            } else {
                this.addActionMessage(this.getText("manage.overview.networks.delete.success", new String[]{this.id}));
            }
            Optional<KeyNamePair> potentialNetwork = this.getAllNetworks().stream().filter(n -> Objects.equals(n.getKey(), this.id)).findFirst();
            potentialNetwork.ifPresent(this.potentialNetworks::add);
        }
        catch (IllegalArgumentException e) {
            this.addActionError(this.getText("manage.overview.networks.delete.failed"));
        }
        return this.execute();
    }

    public String deleteManager() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        User u = this.userManager.get(this.id);
        if (u == null || !this.resource.getManagers().contains(u)) {
            this.addActionError(this.getText("manage.overview.manager.not.available", new String[]{this.id}));
        } else {
            this.resource.getManagers().remove(u);
            this.addActionMessage(this.getText("manage.overview.user.removed", new String[]{u.getName()}));
            this.saveResource();
            this.potentialManagers.add(u);
        }
        return this.execute();
    }

    public String execute() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        return "success";
    }

    public boolean setMetadataModifiedSinceLastPublication(@NotNull Resource resource) {
        if (resource.getLastPublished() == null) {
            return resource.getMetadataModified() != null;
        }
        if (resource.getMetadataModified() != null) {
            return resource.getMetadataModified().compareTo(resource.getLastPublished()) > 0;
        }
        return false;
    }

    public boolean setMappingsModifiedSinceLastPublication(@NotNull Resource resource) {
        if (resource.getLastPublished() == null) {
            return resource.getMappingsModified() != null;
        }
        if (resource.getMappingsModified() != null) {
            return resource.getMappingsModified().compareTo(resource.getLastPublished()) > 0;
        }
        return false;
    }

    public boolean setSourcesModifiedSinceLastPublication(@NotNull Resource resource) {
        if (resource.getLastPublished() == null) {
            return resource.getSourcesModified() != null;
        }
        if (resource.getSourcesModified() != null) {
            return resource.getSourcesModified().compareTo(resource.getLastPublished()) > 0;
        }
        return false;
    }

    public boolean getMissingRegistrationMetadata() {
        return this.missingRegistrationMetadata;
    }

    public List<org.gbif.api.model.registry.Network> getResourceNetworks() {
        try {
            return this.registryManager.getResourceNetworks(this.resource);
        }
        catch (RegistryException e) {
            LOG.error("Failed to display resource's networks");
            return Collections.emptyList();
        }
    }

    private boolean hasMinimumRegistryInfo(Resource resource) {
        if (this.missingBasicMetadata) {
            return false;
        }
        return resource.isPublished();
    }

    public boolean hasValidPublishingOrganisation(Resource resource) {
        if (resource.getOrganisation() == null) {
            return false;
        }
        return !resource.getOrganisation().getKey().equals(Constants.DEFAULT_ORG_KEY);
    }

    public String locked() throws Exception {
        this.now = new Date();
        if (this.report != null && this.report.isCompleted()) {
            this.addActionMessage(this.getText("manage.overview.resource.published"));
            return "cancel";
        }
        return "success";
    }

    public String makePrivate() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        if (this.unpublish) {
            if (PublicationStatus.PUBLIC == this.resource.getStatus() && !this.resource.isAlreadyAssignedDoi()) {
                try {
                    this.resourceManager.visibilityToPrivate(this.resource, (BaseAction)this);
                    this.addActionMessage(this.getText("manage.overview.changed.publication.status", new String[]{this.resource.getStatus().toString()}));
                }
                catch (InvalidConfigException e) {
                    LOG.error("Cant unpublish resource " + String.valueOf(this.resource), (Throwable)e);
                }
            } else {
                this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
            }
        } else {
            this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
        }
        return this.execute();
    }

    public String makePublic() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        if (PublicationStatus.PRIVATE == this.resource.getStatus()) {
            if (StringUtils.isNotEmpty((CharSequence)this.makePublicDateTime)) {
                try {
                    Date date = DATE_FORMAT.parse(this.makePublicDateTime);
                    this.resource.setMakePublicDate(date);
                    this.saveResource();
                    this.addActionMessage(this.getText("manage.overview.changed.publication.status.become.public", new String[]{DATE_FORMAT_UI.format(date)}));
                }
                catch (Exception e) {
                    LOG.error("Can't set make public date " + String.valueOf(this.resource), (Throwable)e);
                }
            } else {
                try {
                    this.resourceManager.visibilityToPublic(this.resource, (BaseAction)this);
                    this.addActionMessage(this.getText("manage.overview.changed.publication.status", new String[]{this.resource.getStatus().toString()}));
                }
                catch (InvalidConfigException e) {
                    LOG.error("Can't publish resource " + String.valueOf(this.resource), (Throwable)e);
                }
            }
        } else {
            this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
        }
        return this.execute();
    }

    public String cancelMakePublic() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        this.resource.setMakePublicDate(null);
        this.saveResource();
        this.addActionMessage(this.getText("manage.overview.changed.publication.status", new String[]{this.resource.getStatus().toString()}));
        return this.execute();
    }

    public String reserveDoi() throws Exception {
        block22: {
            if (this.resource == null) {
                return "404";
            }
            if (this.reserveDoi) {
                if (this.registrationManager.getDoiService() == null) {
                    String msg = this.getText("manage.overview.doi.operation.failed.noAccount");
                    LOG.error(msg);
                    this.addActionError(msg);
                    return "input";
                }
                DOI existingDoi = this.findExistingDoi(this.resource);
                if (existingDoi == null && this.resource.getIdentifierStatus() == IdentifierStatus.UNRESERVED && !this.resource.isAlreadyAssignedDoi() || this.resource.getIdentifierStatus() == IdentifierStatus.PUBLIC && this.resource.isAlreadyAssignedDoi()) {
                    DOI doi = DOIUtils.mintDOI((DOIRegistrationAgency)this.doiAccount.getDoiRegistrationAgency(), (String)this.doiAccount.getDoiPrefix());
                    LOG.info("Reserving " + String.valueOf(doi) + " for " + this.resource.getTitleAndShortname());
                    try {
                        this.doReserveDOI(doi, this.resource);
                        String msg = this.getText("manage.overview.publishing.doi.reserve.success", new String[]{doi.toString()});
                        LOG.info(msg);
                        this.addActionMessage(msg);
                    }
                    catch (DoiExistsException e) {
                        LOG.error("Failed to reserve " + String.valueOf(doi) + " because it exists already. Trying again...", (Throwable)e);
                        this.reserveDoi();
                    }
                    catch (InvalidMetadataException e) {
                        String errorMsg = this.getText("manage.overview.publishing.doi.reserve.failed.metadata", new String[]{doi.toString(), e.getMessage()});
                        LOG.error(errorMsg, (Throwable)e);
                        this.addActionError(errorMsg);
                    }
                    catch (DoiException e) {
                        String errorMsg = this.getText("manage.overview.publishing.doi.reserve.failed", new String[]{doi.toString(), e.getMessage()});
                        LOG.error(errorMsg, (Throwable)e);
                        this.addActionError(errorMsg);
                    }
                } else if (existingDoi != null && this.resource.getIdentifierStatus() == IdentifierStatus.UNRESERVED && !this.resource.isAlreadyAssignedDoi()) {
                    String prefixAllowed = this.doiAccount.getDoiPrefix();
                    if (prefixAllowed != null && existingDoi.getDoiName().startsWith(prefixAllowed.toLowerCase())) {
                        try {
                            DoiData doiData = this.registrationManager.getDoiService().resolve(existingDoi);
                            if (doiData.getStatus().equals((Object)DoiStatus.RESERVED)) {
                                LOG.info("Assigning " + String.valueOf(existingDoi) + " (existing reserved DOI) to " + this.resource.getTitleAndShortname());
                                this.doReuseDOI(existingDoi, this.resource);
                                break block22;
                            }
                            if (doiData.getStatus().equals((Object)DoiStatus.REGISTERED)) {
                                LOG.info("Assigning " + String.valueOf(existingDoi) + " (existing registered DOI) to " + this.resource.getTitleAndShortname());
                                LOG.debug("Resource " + this.resource.getShortname() + " has status=" + String.valueOf(this.resource.getStatus()));
                                if (!this.resource.isPubliclyAvailable()) {
                                    String errorMsg = this.getText("manage.overview.publishing.doi.reserve.failed.notPublic", new String[]{existingDoi.toString()});
                                    LOG.error(errorMsg);
                                    this.addActionError(errorMsg);
                                } else {
                                    URI target = doiData.getTarget();
                                    LOG.debug(String.valueOf(existingDoi) + " has target URI=" + String.valueOf(target));
                                    URI homepage = this.cfg.getResourceUri(this.resource.getShortname());
                                    if (target != null && target.equals(homepage)) {
                                        LOG.debug("Verified target URI of existing registered DOI is equal to public resource homepage URI");
                                        this.doReuseDOI(existingDoi, this.resource);
                                    } else {
                                        String errorMsg = this.getText("manage.overview.publishing.doi.reserve.failed.invalid.target", new String[]{existingDoi.toString(), homepage.toString()});
                                        LOG.error(errorMsg);
                                        this.addActionError(errorMsg);
                                    }
                                }
                                break block22;
                            }
                            String errorMsg = this.getText("manage.overview.publishing.doi.reserve.reused.failed", new String[]{existingDoi.toString()});
                            LOG.error(errorMsg);
                            this.addActionError(errorMsg);
                        }
                        catch (DoiException e) {
                            String errorMsg = this.getText("manage.overview.publishing.doi.reserve.reused.failed.exception", new String[]{existingDoi.toString(), e.getMessage()});
                            LOG.error(errorMsg, (Throwable)e);
                            this.addActionError(errorMsg);
                        }
                    } else {
                        this.addActionError(this.getText("manage.overview.publishing.doi.reserve.notRreused", new String[]{existingDoi.toString(), prefixAllowed}));
                    }
                } else {
                    this.addActionWarning(this.getText("manage.overview.resource.doi.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getIdentifierStatus().toString()}));
                }
            } else {
                this.addActionWarning(this.getText("manage.overview.resource.doi.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getIdentifierStatus().toString()}));
            }
        }
        return this.execute();
    }

    private void doReuseDOI(DOI doi, Resource resource) {
        resource.setDoi(doi);
        resource.setDoiOrganisationKey(this.registrationManager.findPrimaryDoiAgencyAccount().getKey());
        resource.setIdentifierStatus(IdentifierStatus.PUBLIC_PENDING_PUBLICATION);
        resource.updateAlternateIdentifierForDOI();
        resource.updateCitationIdentifierForDOI();
        this.saveResource();
        String msg = this.getText("manage.overview.publishing.doi.reserve.reused", new String[]{doi.toString()});
        LOG.info(msg);
        this.addActionMessage(msg);
    }

    private void doReserveDOI(DOI doi, Resource resource) throws DoiException {
        Objects.requireNonNull(this.registrationManager.getDoiService());
        DataCiteMetadata dataCiteMetadata = DataCiteMetadataBuilder.createDataCiteMetadata((DOI)doi, (Resource)resource);
        this.registrationManager.getDoiService().reserve(doi, dataCiteMetadata);
        resource.setDoi(doi);
        resource.setDoiOrganisationKey(this.registrationManager.findPrimaryDoiAgencyAccount().getKey());
        resource.setIdentifierStatus(IdentifierStatus.PUBLIC_PENDING_PUBLICATION);
        resource.updateAlternateIdentifierForDOI();
        resource.updateCitationIdentifierForDOI();
        this.saveResource();
    }

    private void doDeleteReservedDOI(DOI reservedDoi, Resource resource, @Nullable DOI reassignedDoi) throws DoiException {
        Objects.requireNonNull(this.registrationManager.getDoiService());
        DoiData doiData = this.registrationManager.getDoiService().resolve(reservedDoi);
        if (doiData.getStatus() != null && !doiData.getStatus().equals((Object)DoiStatus.REGISTERED)) {
            LOG.debug("Deleting reserved DOI=" + reservedDoi.toString());
            this.registrationManager.getDoiService().delete(reservedDoi);
        } else {
            LOG.debug("Deleting reserved DOI bypassed because this is an existing registered DOI: " + reservedDoi.toString());
        }
        resource.setIdentifierStatus(IdentifierStatus.UNRESERVED);
        resource.updateAlternateIdentifierForDOI();
        resource.updateCitationIdentifierForDOI();
        resource.setDoi(null);
        resource.setDoiOrganisationKey(null);
        if (reassignedDoi != null) {
            resource.setIdentifierStatus(IdentifierStatus.PUBLIC);
            resource.setDoi(reassignedDoi);
            resource.updateAlternateIdentifierForDOI();
            resource.updateCitationIdentifierForDOI();
            resource.setDoiOrganisationKey(this.registrationManager.findPrimaryDoiAgencyAccount().getKey());
        }
        this.saveResource();
    }

    public DOI findExistingDoi(Resource resource) {
        Citation citation;
        if (resource != null && resource.getEml() != null && (citation = resource.getEml().getCitation()) != null && DOI.isParsable((String)StringUtils.trimToNull((String)citation.getIdentifier()))) {
            return new DOI(citation.getIdentifier());
        }
        return null;
    }

    public String deleteDoi() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        if (this.registrationManager.getDoiService() == null) {
            String msg = this.getText("manage.overview.doi.operation.failed.noAccount");
            LOG.error(msg);
            this.addActionError(msg);
        }
        if (this.deleteDoi) {
            DOI reservedDoi = this.resource.getDoi();
            if (reservedDoi != null && this.resource.getIdentifierStatus() == IdentifierStatus.PUBLIC_PENDING_PUBLICATION) {
                DOI assignedDoi = this.resource.getAssignedDoi();
                if (assignedDoi != null) {
                    LOG.info("Deleting reserved " + String.valueOf(reservedDoi) + " and reassigning " + String.valueOf(assignedDoi));
                    try {
                        this.doDeleteReservedDOI(reservedDoi, this.resource, assignedDoi);
                        String msg = this.getText("manage.overview.publishing.doi.delete.reassign.success", new String[]{reservedDoi.toString(), assignedDoi.toString()});
                        LOG.info(msg);
                        this.addActionMessage(msg);
                    }
                    catch (DoiException e) {
                        String errorMsg = this.getText("manage.overview.publishing.doi.delete.failed.exception", new String[]{this.resource.getDoi().toString(), e.getMessage()});
                        LOG.error(errorMsg, (Throwable)e);
                        this.addActionError(errorMsg);
                    }
                } else {
                    LOG.info("Deleting reserved " + String.valueOf(reservedDoi));
                    try {
                        this.doDeleteReservedDOI(reservedDoi, this.resource, null);
                        String msg = this.getText("manage.overview.publishing.doi.delete.success", new String[]{reservedDoi.toString()});
                        LOG.info(msg);
                        this.addActionMessage(msg);
                    }
                    catch (DoiException e) {
                        String errorMsg = this.getText("manage.overview.publishing.doi.delete.failed.exception", new String[]{this.resource.getDoi().toString(), e.getMessage()});
                        LOG.error(errorMsg, (Throwable)e);
                        this.addActionError(errorMsg);
                    }
                }
            } else {
                this.addActionWarning(this.getText("manage.overview.resource.doi.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getIdentifierStatus().toString()}));
            }
        } else {
            this.addActionWarning(this.getText("manage.overview.resource.doi.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getIdentifierStatus().toString()}));
        }
        return this.execute();
    }

    public void prepare() {
        super.prepare();
        if (this.resource != null) {
            this.updateReport();
            this.outdatedExtensions = this.resource.getMappings().stream().map(ExtensionMapping::getExtension).anyMatch(e -> !e.isLatest());
            try {
                if ("coldp".equals(this.resource.getCoreType())) {
                    File metadataFile = this.cfg.getDataDir().resourceDatapackageMetadataFile(this.resource.getShortname(), this.resource.getCoreType());
                    this.datapackageMetadataRaw = FileUtils.readFileToString((File)metadataFile, (Charset)StandardCharsets.UTF_8);
                }
            }
            catch (Exception e2) {
                LOG.error("Failed to read ColDP metadata", (Throwable)e2);
            }
            this.potentialManagers = this.userManager.list(User.Role.Publisher);
            this.potentialManagers.addAll(this.userManager.list(User.Role.Manager));
            for (User u : this.resource.getManagers()) {
                this.potentialManagers.remove(u);
            }
            this.organisations = this.registrationManager.list();
            for (ExtensionMapping em : this.resource.getCoreMappings()) {
                if (!em.getFields().isEmpty()) continue;
                LOG.debug("Deleting mapping {}\u2192{} for resource {}: no mapped fields", (Object)Optional.ofNullable(em.getSource()).map(Source::getName).orElse("NULL"), (Object)Optional.ofNullable(em.getExtension()).map(Extension::getName).orElse("NULL"), (Object)this.resource.getShortname());
                this.resource.deleteMapping(em);
            }
            String coreRowType = this.resource.getCoreRowType();
            this.potentialCores = new ArrayList();
            this.potentialExtensions = new ArrayList();
            if (!this.resource.getSources().isEmpty()) {
                if (coreRowType != null) {
                    Extension core = this.extensionManager.get(coreRowType);
                    if (core == null) {
                        this.addActionError(this.getText("manage.overview.no.DwC.extension", new String[]{coreRowType}));
                    } else {
                        this.potentialCores.add(core);
                        List otherCores = this.extensionManager.listCore(coreRowType);
                        this.potentialExtensions.addAll(otherCores);
                        List others = this.extensionManager.list(coreRowType);
                        this.potentialExtensions.addAll(others);
                    }
                } else {
                    this.potentialCores = this.extensionManager.listCore();
                    if (this.potentialCores.isEmpty()) {
                        this.addActionError(this.getText("manage.overview.no.DwC.extensions"));
                    }
                }
            }
            if (!this.isDataPackageResource()) {
                this.errorCollector = new SectionErrorCollector();
                StrutsI18n i18n = new StrutsI18n((BaseAction)this);
                this.validMetadata = this.emlValidator.areAllSectionsValid(this.resource, this.errorCollector, (I18n)i18n);
                ActionValidationResult basicMetadataValidationResult = (ActionValidationResult)this.errorCollector.getResult().get(MetadataSection.BASIC_SECTION.toString());
                ActionValidationResult contactsValidationResult = (ActionValidationResult)this.errorCollector.getResult().get(MetadataSection.CONTACTS_SECTION.toString());
                this.missingBasicMetadata = basicMetadataValidationResult.hasErrors() || contactsValidationResult.hasErrors();
            } else {
                this.validMetadata = this.dataPackageMetadataValidator.isValid(this.resource);
            }
            this.missingValidPublishingOrganisation = !this.hasValidPublishingOrganisation(this.resource);
            this.missingRegistrationMetadata = !this.hasMinimumRegistryInfo(this.resource);
            this.metadataModifiedSinceLastPublication = this.setMetadataModifiedSinceLastPublication(this.resource);
            this.mappingsModifiedSinceLastPublication = this.setMappingsModifiedSinceLastPublication(this.resource);
            this.sourcesModifiedSinceLastPublication = this.setSourcesModifiedSinceLastPublication(this.resource);
            this.autoPublishFrequencies = new LinkedHashMap();
            Map filteredFrequencies = this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/eml/updateFrequency", this.getLocaleLanguage(), false);
            MapUtils.removeNonMatchingKeys((Map)filteredFrequencies, (List)MaintenanceUpdateFrequency.NON_ZERO_DAYS_UPDATE_PERIODS);
            this.autoPublishFrequencies.putAll(filteredFrequencies);
            this.usableSpace = this.cfg.getDataDir().getDataDirUsableSpace();
            this.freeDiscSpaceReadable = FileUtils.byteCountToDisplaySize((long)this.usableSpace);
        }
    }

    private void updateReport() {
        this.report = this.resourceManager.status(this.resource.getShortname());
    }

    public String publish() throws Exception {
        if (this.resource == null) {
            return "404";
        }
        if (this.publish) {
            if (this.resource.isRegistered() && !this.resource.isDataPackage() && !this.resource.isAssignedGBIFSupportedLicense()) {
                String msg = this.getText("manage.overview.prevented.resource.publishing.noGBIFLicense");
                this.addActionError(msg);
                LOG.error(msg);
                return "input";
            }
            if (this.resource.getDoi() != null && this.resource.isPubliclyAvailable()) {
                if (this.registrationManager.getDoiService() == null) {
                    String msg = this.getText("manage.overview.doi.operation.failed.noAccount");
                    LOG.error(msg);
                    this.addActionError(msg);
                    return "input";
                }
                try {
                    DoiData doiData = this.registrationManager.getDoiService().resolve(this.resource.getDoi());
                    if (doiData.getStatus() != null) {
                        if (doiData.getStatus().compareTo((Enum)DoiStatus.RESERVED) != 0 && doiData.getStatus().compareTo((Enum)DoiStatus.REGISTERED) != 0) {
                            String errorMsg = this.getText("manage.overview.publishing.doi.publish.check.registered.failed", new String[]{this.resource.getDoi().toString(), doiData.getStatus().toString()});
                            LOG.error(errorMsg);
                            this.addActionError(errorMsg);
                            return "input";
                        }
                    } else {
                        String errorMsg = this.getText("manage.overview.publishing.doi.publish.check.existing.failed", new String[]{this.resource.getDoi().toString()});
                        LOG.error(errorMsg);
                        this.addActionError(errorMsg);
                        return "input";
                    }
                    LOG.info("Pre-publication check: successfully resolved " + this.resource.getDoi().toString());
                }
                catch (DoiException e) {
                    String errorMsg = this.getText("manage.overview.publishing.doi.publish.check.existing.failed.exception", new String[]{this.resource.getDoi().toString(), e.getMessage()});
                    LOG.error(errorMsg, (Throwable)e);
                    this.addActionError(errorMsg);
                    return "input";
                }
            }
            if (this.resourceManager.getProcessFailures().containsKey((Object)this.resource.getShortname())) {
                this.logProcessFailures(this.resource);
                LOG.info("Clearing publish event failures for resource: " + this.resource.getTitleAndShortname());
                this.resourceManager.getProcessFailures().remove((Object)this.resource.getShortname());
            }
            BigDecimal nextVersion = new BigDecimal(this.resource.getNextVersion().toPlainString());
            this.resource.setChangeSummary(this.getSummary());
            try {
                if (this.resourceManager.publish(this.resource, nextVersion, (BaseAction)this)) {
                    this.addActionMessage(this.getText("publishing.started", new String[]{String.valueOf(nextVersion), this.resource.getShortname()}));
                    this.updateReport();
                    return PUBLISHING;
                }
                if (this.resource.getCoreType() != null && this.resource.getDataPackageIdentifier() == null && !this.resource.getCoreType().equalsIgnoreCase("metadata")) {
                    this.addActionWarning(this.getText("manage.overview.data.missing"));
                }
                if (this.resource.getDataPackageIdentifier() != null && CollectionUtils.isEmpty((Collection)this.resource.getDataPackageMappings())) {
                    this.addActionWarning(this.getText("manage.overview.data.missing"));
                }
                this.missingRegistrationMetadata = !this.hasMinimumRegistryInfo(this.resource);
                this.metadataModifiedSinceLastPublication = this.setMetadataModifiedSinceLastPublication(this.resource);
                this.mappingsModifiedSinceLastPublication = this.setMappingsModifiedSinceLastPublication(this.resource);
                this.updateReport();
                return "success";
            }
            catch (PublicationException e) {
                LOG.error("Exception while publishing", (Throwable)e);
                if (PublicationException.TYPE.LOCKED == e.getType()) {
                    if (e.getAdditionalParameter("source") != null) {
                        LOG.error("Publication exception: {}", (Object)e.getMessage());
                        this.addActionError(this.getText("manage.overview.resource.source.being.processed", new String[]{(String)e.getAdditionalParameter("source")}));
                    }
                    LOG.error("Publication exception: resource {} is currently being published", (Object)this.resource.getShortname());
                    this.addActionError(this.getText("manage.overview.resource.being.published", new String[]{this.resource.getTitleAndShortname()}));
                }
                LOG.error("Publication exception: resource {} publication failed. Reason: {}", (Object)this.resource.getShortname(), (Object)e.getMessage());
                this.addActionError(this.getText("publishing.failed", new String[]{String.valueOf(nextVersion), this.resource.getShortname(), e.getMessage()}));
                this.resourceManager.restoreVersion(this.resource, nextVersion, (BaseAction)this);
                this.resourceManager.getProcessFailures().put((Object)this.resource.getShortname(), (Object)new Date());
            }
            catch (InvalidConfigException e) {
                String msg = this.getText("publishing.failed", new String[]{String.valueOf(nextVersion), this.resource.getShortname(), e.getMessage()});
                LOG.error(msg, (Throwable)e);
                this.addActionError(msg);
            }
        } else {
            return "home";
        }
        return "error";
    }

    public synchronized String registerResource() throws Exception {
        block16: {
            if (this.resource == null) {
                return "404";
            }
            if (this.resource.isRegistered()) {
                String msg = this.getText("manage.overview.failed.resource.registration.alreadyRegistered");
                this.addActionError(msg);
                LOG.error(msg);
                return "input";
            }
            if (!this.resource.isLastPublishedVersionPublic()) {
                String msg = this.getText("manage.overview.failed.resource.registration.notPublic");
                this.addActionError(msg);
                LOG.error(msg);
                return "input";
            }
            if (this.resource.getDataPackageIdentifier() == null && this.resource.hasOccurrenceMapping() && !this.isLastPublishedVersionAssignedGBIFSupportedLicense(this.resource)) {
                String msg = this.getText("manage.overview.prevented.resource.registration.noGBIFLicense");
                this.addActionError(msg);
                LOG.error(msg);
                return "input";
            }
            if (PublicationStatus.PUBLIC == this.resource.getStatus()) {
                if (this.unpublish) {
                    this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
                } else if (this.getCurrentUser().hasRegistrationRights()) {
                    try {
                        Organisation org = this.resource.getOrganisation();
                        if (org == null) {
                            return this.execute();
                        }
                        this.resourceManager.register(this.resource, org, this.registrationManager.getIpt(), (BaseAction)this);
                        Network defaultIptNetwork = this.registrationManager.getNetwork();
                        if (defaultIptNetwork != null && defaultIptNetwork.getKey() != null) {
                            this.registryManager.addResourceToNetwork(this.resource, defaultIptNetwork.getKey().toString());
                        }
                    }
                    catch (InvalidConfigException e) {
                        if (e.getType() == InvalidConfigException.TYPE.INVALID_RESOURCE_MIGRATION) {
                            String msg = this.getText("manage.resource.migrate.failed");
                            msg = StringUtils.isBlank((CharSequence)msg) ? e.getMessage() : msg + ": " + e.getMessage();
                            this.addActionError(msg);
                            LOG.error(msg);
                            break block16;
                        }
                        String msg = this.getText("manage.overview.failed.resource.registration");
                        this.addActionError(msg);
                        LOG.error(msg);
                    }
                    catch (RegistryException e) {
                        String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
                        this.addActionError(msg);
                        LOG.error(msg);
                        msg = this.getText("manage.overview.failed.resource.registration");
                        this.addActionError(msg);
                        LOG.error(msg);
                    }
                } else {
                    String sb = this.getText("manage.resource.status.registration.forbidden") + " " + this.getText("manage.resource.role.change");
                    this.addActionError(sb);
                }
            } else {
                this.addActionWarning(this.getText("manage.overview.resource.invalid.operation", new String[]{this.resource.getShortname(), this.resource.getStatus().toString()}));
            }
        }
        return this.execute();
    }

    public boolean isLastPublishedVersionAssignedGBIFSupportedLicense(Resource resource) {
        List history = resource.getVersionHistory();
        if (!history.isEmpty()) {
            VersionHistory latestVersionHistory = (VersionHistory)history.get(0);
            BigDecimal latestVersion = new BigDecimal(latestVersionHistory.getVersion());
            if (resource.isDataPackage()) {
                if ("camtrap-dp".equals(resource.getCoreType())) {
                    if (resource.getDataPackageMetadata() instanceof CamtrapMetadata) {
                        CamtrapMetadata metadata = (CamtrapMetadata)resource.getDataPackageMetadata();
                        Optional<CamtrapLicense> dataLicenceWrapped = metadata.getLicenses().stream().map(license -> (CamtrapLicense)license).filter(camtrapLicense -> camtrapLicense.getScope() == CamtrapLicense.Scope.DATA).findFirst();
                        return dataLicenceWrapped.map(FrictionlessLicense::getName).map(Constants.GBIF_SUPPORTED_LICENSES_CODES::contains).orElse(false);
                    }
                    LOG.error("Wrong metadata type for Camtrap DP resource {}: {}", (Object)resource.getShortname(), (Object)resource.getDataPackageMetadata().getClass().getSimpleName());
                    return false;
                }
                if ("coldp".equals(resource.getCoreType())) {
                    if (resource.getDataPackageMetadata() instanceof ColMetadata) {
                        ColMetadata metadata = (ColMetadata)resource.getDataPackageMetadata();
                        Optional<String> license2 = Optional.ofNullable(metadata.getLicense());
                        return license2.map(Constants.COLDP_LICENSES_CODES_TO_GBIF::get).map(Constants.GBIF_SUPPORTED_LICENSES_CODES::contains).orElse(false);
                    }
                    LOG.error("Wrong metadata type for ColDP resource {}: {}", (Object)resource.getShortname(), (Object)resource.getDataPackageMetadata().getClass().getSimpleName());
                    return false;
                }
            } else {
                File emlFile = this.cfg.getDataDir().resourceEmlFile(resource.getShortname(), latestVersion);
                if (emlFile.exists()) {
                    try {
                        LOG.debug("Loading EML from file: {}", (Object)emlFile.getAbsolutePath());
                        FileInputStream in = new FileInputStream(emlFile);
                        Eml eml = EmlFactory.build((InputStream)in);
                        String licenseUrlString = eml.parseLicenseUrl();
                        if (licenseUrlString != null) {
                            LOG.debug("Checking if license (URL={}) is supported by GBIF..", (Object)licenseUrlString);
                            boolean isSupported = Constants.GBIF_SUPPORTED_LICENSES.stream().anyMatch(supportedLicense -> supportedLicense.contains(licenseUrlString));
                            if (isSupported) {
                                LOG.debug("License URL {} is supported", (Object)licenseUrlString);
                            } else {
                                LOG.debug("License URL {} is not supported", (Object)licenseUrlString);
                            }
                            return isSupported;
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed to check if last published version of resource has been assigned a GBIF-supported license: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return false;
    }

    public String getLastPublishedVersionAssignedLicense(Resource resource) {
        List history = resource.getVersionHistory();
        if (!history.isEmpty()) {
            VersionHistory latestVersionHistory = (VersionHistory)history.get(0);
            BigDecimal latestVersion = new BigDecimal(latestVersionHistory.getVersion());
            File emlFile = this.cfg.getDataDir().resourceEmlFile(resource.getShortname(), latestVersion);
            if (emlFile.exists()) {
                try {
                    LOG.debug("Loading EML from file: {}", (Object)emlFile.getAbsolutePath());
                    FileInputStream in = new FileInputStream(emlFile);
                    Eml eml = EmlFactory.build((InputStream)in);
                    return eml.parseLicenseUrl();
                }
                catch (Exception e) {
                    LOG.error("Failed to check if last published version of resource has been assigned a GBIF-supported license: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public void setUnpublish(String unpublish) {
        this.unpublish = StringUtils.trimToNull((String)unpublish) != null;
    }

    public void setReserveDoi(String reserveDoi) {
        this.reserveDoi = StringUtils.trimToNull((String)reserveDoi) != null;
    }

    public void setDeleteDoi(String deleteDoi) {
        this.deleteDoi = StringUtils.trimToNull((String)deleteDoi) != null;
    }

    public void setUndelete(String undelete) {
        this.undelete = StringUtils.trimToNull((String)undelete) != null;
    }

    public void setPublish(String publish) {
        this.publish = StringUtils.trimToNull((String)publish) != null;
    }

    public String replaceEml() {
        try {
            this.resourceManager.replaceEml(this.resource, this.emlFile, this.validateEml);
            this.addActionMessage(this.getText("manage.overview.success.replace.eml"));
            return "success";
        }
        catch (ImportException e) {
            LOG.error("Failed to replace EML", (Throwable)e);
            this.addActionError(this.getText("manage.overview.failed.replace.eml"));
            return "error";
        }
        catch (ParserConfigurationException | SAXException e) {
            LOG.error("Failed to create EML validator", (Throwable)e);
            this.addActionError(this.getText("manage.overview.failed.replace.eml.validator"));
            return "error";
        }
        catch (IOException e) {
            LOG.error("Failed to read EML from file", (Throwable)e);
            this.addActionError(this.getText("manage.overview.failed.replace.eml.read"));
            return "error";
        }
        catch (InvalidEmlException e) {
            LOG.error("Validation failed for EML document", (Throwable)e);
            this.addActionError(this.getText("manage.overview.failed.replace.eml.validation") + " " + e.getMessage());
            return "error";
        }
    }

    public String replaceDatapackageMetadata() {
        try {
            this.resourceManager.replaceDatapackageMetadata((BaseAction)this, this.resource, this.datapackageMetadataFile, this.validateDatapackageMetadata);
            this.addActionMessage(this.getText("manage.overview.success.replace.metadata"));
            return "success";
        }
        catch (ImportException e) {
            LOG.error("Failed to replace data package metadata", (Throwable)e);
            this.addActionError(this.getText("manage.overview.failed.replace.metadata"));
            return "error";
        }
        catch (IOException e) {
            LOG.error("Failed to read data package metadata from file", (Throwable)e);
            this.addActionError(this.getText("manage.overview.failed.replace.metadata.read"));
            return "error";
        }
        catch (org.gbif.ipt.service.InvalidMetadataException e) {
            LOG.error("Validation failed for metadata file", (Throwable)e);
            this.addActionError(this.getText("manage.overview.failed.replace.metadata.validation"));
            return "error";
        }
    }

    protected void logProcessFailures(Resource resource) {
        StringBuilder sb = new StringBuilder();
        sb.append("Resource [");
        sb.append(resource.getTitleAndShortname());
        sb.append("] has ");
        if (this.resourceManager.getProcessFailures().containsKey((Object)resource.getShortname())) {
            List failures = this.resourceManager.getProcessFailures().get((Object)resource.getShortname());
            sb.append(failures.size());
            sb.append(" failed publications on: ");
            Iterator iter = failures.iterator();
            while (iter.hasNext()) {
                sb.append(DateFormatUtils.format((Date)((Date)iter.next()), (String)"yyyy-MM-dd HH:mm:ss"));
                if (iter.hasNext()) {
                    sb.append(", ");
                    continue;
                }
                sb.append(".");
            }
        } else {
            sb.append("0 failed publications");
        }
        LOG.debug(sb.toString());
    }

    public String peek() {
        ArrayList<TaskMessage> messages;
        Exception exception;
        block12: {
            if (this.resource == null) {
                return "404";
            }
            this.peek = new ArrayList();
            this.columns = new ArrayList();
            exception = null;
            messages = new ArrayList<TaskMessage>();
            Term rowType = null;
            if (this.id != null) {
                rowType = TERM_FACTORY.findTerm(this.id);
            }
            if (this.resource.getDataPackageIdentifier() == null) {
                if (rowType != null && this.mid != null) {
                    ExtensionMapping mapping = (ExtensionMapping)this.resource.getMappings(this.id).get(this.mid);
                    if (mapping != null) {
                        try {
                            GenerateDwca worker = this.dwcaFactory.create(this.resource, (ReportHandler)this);
                            worker.report();
                            File tmpDir = org.gbif.ipt.utils.FileUtils.createTempDir();
                            worker.setDwcaFolder(tmpDir);
                            Archive archive = new Archive();
                            worker.setArchive(archive);
                            ArrayList<ExtensionMapping> mappings = new ArrayList<ExtensionMapping>();
                            mappings.add(mapping);
                            worker.addDataFile(mappings, Integer.valueOf(100));
                            File[] files = tmpDir.listFiles();
                            if (files != null && files.length > 0) {
                                ArchiveFile core = archive.getCore();
                                ArchiveFile ext = archive.getExtension(rowType);
                                String delimiter = core == null ? ext.getFieldsTerminatedBy() : core.getFieldsTerminatedBy();
                                Character quotes = core == null ? ext.getFieldsEnclosedBy() : core.getFieldsEnclosedBy();
                                int headerRows = core == null ? ext.getIgnoreHeaderLines() : core.getIgnoreHeaderLines();
                                CSVReader reader = CSVReaderFactory.build((File)files[0], (String)"UTF-8", (String)delimiter, (Character)quotes, (Integer)headerRows);
                                while (reader.hasNext()) {
                                    this.peek.add(reader.next());
                                    if (!this.columns.isEmpty()) continue;
                                    this.columns = Arrays.asList(reader.header);
                                }
                                break block12;
                            }
                            messages.add(new TaskMessage(Level.ERROR, this.getText("mapping.preview.not.found")));
                        }
                        catch (Exception e) {
                            exception = e;
                            messages.add(new TaskMessage(Level.ERROR, this.getText("mapping.preview.error", new String[]{e.getMessage()})));
                        }
                    } else {
                        messages.add(new TaskMessage(Level.ERROR, this.getText("mapping.preview.mapping.not.found", new String[]{this.id, String.valueOf(this.mid)})));
                    }
                } else {
                    messages.add(new TaskMessage(Level.ERROR, this.getText("mapping.preview.bad.request")));
                }
            }
        }
        if (!messages.isEmpty()) {
            this.report.getMessages().addAll(messages);
        }
        this.report = exception == null ? new StatusReport(true, "succeeded", this.report.getMessages()) : new StatusReport(exception, "failed", messages);
        return "success";
    }

    public void report(String resourceShortname, StatusReport report) {
        this.report = report;
    }

    public Organisation getOrganisationWithPrimaryDoiAccount() {
        return this.doiAccount;
    }

    public void setSummary(String summary) {
        this.summary = StringUtils.trimToEmpty((String)summary);
    }

    public String getSummary() {
        return StringUtils.trimToNull((String)this.summary);
    }

    public boolean isDataPackageResource() {
        return this.resource.getDataPackageIdentifier() != null;
    }

    public boolean isDataPackageMappingsMissing() {
        return this.resource.getDataPackageMappings().isEmpty();
    }

    public boolean isResourceOrganisationAssociatedWithDoiAgency() {
        Optional<Organisation> firstOrganisationMatch;
        if (this.resource.getOrganisation() != null && this.resource.getOrganisation().getKey() != null && (firstOrganisationMatch = this.organisations.stream().filter(org -> this.resource.getOrganisation().getKey().equals(org.getKey())).findFirst()).isPresent()) {
            return firstOrganisationMatch.get().isAssociatedWithDoiRegistrationAgency();
        }
        return false;
    }

    public List<KeyNamePair> getAllNetworks() {
        if (this.allNetworks == null || this.allNetworks.isEmpty()) {
            try {
                this.allNetworks = this.registryManager.getNetworksBrief();
                this.networksAvailable = true;
            }
            catch (RegistryException e) {
                String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
                this.addActionWarning(this.getText("manage.overview.networks.registryAccessUrl", new String[]{this.cfg.getRegistryUrl()}) + msg);
                this.networksAvailable = false;
                this.allNetworks = Collections.emptyList();
            }
        }
        return this.allNetworks;
    }

    public List<KeyNamePair> getPotentialNetworks() {
        if (this.potentialNetworks == null || this.potentialNetworks.isEmpty()) {
            ArrayList<KeyNamePair> networksCopy = new ArrayList<KeyNamePair>(this.getAllNetworks());
            for (org.gbif.api.model.registry.Network net : this.getResourceNetworks()) {
                networksCopy.removeIf(n -> Objects.equals(net.getKey().toString(), n.getKey()));
            }
            this.potentialNetworks = networksCopy;
        }
        return this.potentialNetworks;
    }

    public List<User> getPotentialManagers() {
        return this.potentialManagers;
    }

    public List<Extension> getPotentialCores() {
        return this.potentialCores;
    }

    public List<Extension> getPotentialExtensions() {
        return this.potentialExtensions;
    }

    public List<Organisation> getOrganisations() {
        return this.organisations;
    }

    public boolean isMissingBasicMetadata() {
        return this.missingBasicMetadata;
    }

    public boolean isValidMetadata() {
        return this.validMetadata;
    }

    public SectionErrorCollector getErrorCollector() {
        return this.errorCollector;
    }

    public boolean isMissingValidPublishingOrganisation() {
        return this.missingValidPublishingOrganisation;
    }

    public boolean isMetadataModifiedSinceLastPublication() {
        return this.metadataModifiedSinceLastPublication;
    }

    public boolean isMappingsModifiedSinceLastPublication() {
        return this.mappingsModifiedSinceLastPublication;
    }

    public boolean isSourcesModifiedSinceLastPublication() {
        return this.sourcesModifiedSinceLastPublication;
    }

    public Map<String, String> getAutoPublishFrequencies() {
        return this.autoPublishFrequencies;
    }

    public StatusReport getReport() {
        return this.report;
    }

    public Date getNow() {
        return this.now;
    }

    public void setEmlFile(File emlFile) {
        this.emlFile = emlFile;
    }

    public File getEmlFile() {
        return this.emlFile;
    }

    public void setDatapackageMetadataFile(File datapackageMetadataFile) {
        this.datapackageMetadataFile = datapackageMetadataFile;
    }

    public String getDatapackageMetadataRaw() {
        return this.datapackageMetadataRaw;
    }

    public void setValidateEml(boolean validateEml) {
        this.validateEml = validateEml;
    }

    public boolean isValidateEml() {
        return this.validateEml;
    }

    public boolean isNetworksAvailable() {
        return this.networksAvailable;
    }

    public boolean isOutdatedExtensions() {
        return this.outdatedExtensions;
    }

    public void setValidateDatapackageMetadata(boolean validateDatapackageMetadata) {
        this.validateDatapackageMetadata = validateDatapackageMetadata;
    }

    public boolean isValidateDatapackageMetadata() {
        return this.validateDatapackageMetadata;
    }

    public void setMakePublicDateTime(String makePublicDateTime) {
        this.makePublicDateTime = makePublicDateTime;
    }

    public String getMakePublicDateTime() {
        return this.makePublicDateTime;
    }

    public long getUsableSpace() {
        return this.usableSpace;
    }

    public String getFreeDiscSpaceReadable() {
        return this.freeDiscSpaceReadable;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String[]> getPeek() {
        return this.peek;
    }

    public void setMid(Integer mid) {
        this.mid = mid;
    }

    public Integer getMid() {
        return this.mid;
    }
}

