/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.json.annotations.JSON;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.metadata.eml.ipt.model.Agent;

public class MetadataAgentSuggesterAction
extends ManagerBaseAction {
    private static final long serialVersionUID = -6982193399461813074L;
    public Map<String, String> suggestedResources = new HashMap();
    public Map<String, Agent> suggestedAgents = new HashMap();

    @Inject
    public MetadataAgentSuggesterAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
    }

    public void prepare() {
        super.prepare();
    }

    public String execute() {
        List resources = this.resourceManager.list(this.getCurrentUser());
        this.suggestedResources = resources.stream().collect(Collectors.toMap(Resource::getShortname, value -> (String)StringUtils.defaultIfEmpty((CharSequence)value.getTitle(), (CharSequence)value.getShortname())));
        String resourceShortname = this.req.getParameter("r");
        String agentType = this.req.getParameter("type");
        if (StringUtils.isNotEmpty((CharSequence)resourceShortname) && StringUtils.isNotEmpty((CharSequence)agentType)) {
            this.suggestedAgents = resources.stream().filter(res -> res.getShortname().equals(resourceShortname)).map(res -> this.getMetadataAgentsByType(res, agentType)).flatMap(Collection::stream).filter(agent -> agent.getFullName() != null || agent.getOrganisation() != null).collect(Collectors.toMap(agent -> agent.getFullName() != null ? agent.getFullName() : agent.getOrganisation(), value -> value, (existing, newOne) -> existing));
        }
        return "success";
    }

    private List<Agent> getMetadataAgentsByType(Resource resource, String type) {
        if (resource.getEml() == null) {
            return new ArrayList<Agent>();
        }
        if ("creators".equals(type)) {
            return resource.getEml().getCreators();
        }
        if ("contacts".equals(type)) {
            return resource.getEml().getContacts();
        }
        if ("metadataProviders".equals(type)) {
            return resource.getEml().getMetadataProviders();
        }
        if ("associatedParties".equals(type)) {
            return resource.getEml().getAssociatedParties();
        }
        if ("projectPersonnel".equals(type) && resource.getEml().getProject() != null) {
            return resource.getEml().getProject().getPersonnel();
        }
        return new ArrayList<Agent>();
    }

    @JSON
    public Map<String, String> getSuggestedResources() {
        return this.suggestedResources;
    }

    @JSON
    public Map<String, Agent> getSuggestedAgents() {
        return this.suggestedAgents;
    }
}

