/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import com.opensymphony.xwork2.ActionContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.Parameter;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.DatasetSubtype;
import org.gbif.common.parsers.CountryParser;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.action.manage.MetadataAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.i18n.I18n;
import org.gbif.ipt.i18n.StrutsI18n;
import org.gbif.ipt.model.InferredEmlMetadata;
import org.gbif.ipt.model.InferredMetadata;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.voc.IdentifierStatus;
import org.gbif.ipt.model.voc.MetadataSection;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.ResourceMetadataInferringService;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.LangUtils;
import org.gbif.ipt.utils.MapUtils;
import org.gbif.ipt.validation.ActionErrorCollector;
import org.gbif.ipt.validation.EmlValidator;
import org.gbif.ipt.validation.ErrorCollector;
import org.gbif.ipt.validation.ResourceValidator;
import org.gbif.metadata.eml.ipt.model.Address;
import org.gbif.metadata.eml.ipt.model.Agent;
import org.gbif.metadata.eml.ipt.model.Eml;
import org.gbif.metadata.eml.ipt.model.JGTICuratorialUnitType;
import org.gbif.metadata.eml.ipt.model.TemporalCoverageType;

/*
 * Exception performing whole class analysis ignored.
 */
public class MetadataAction
extends ManagerBaseAction {
    private static final Logger LOG = LogManager.getLogger(MetadataAction.class);
    private final ResourceValidator validatorRes = new ResourceValidator();
    private final EmlValidator emlValidator;
    private final VocabulariesManager vocabManager;
    private final ResourceMetadataInferringService resourceMetadataInferringService;
    private static final String LICENSES_PROPFILE_PATH = "/org/gbif/metadata/eml/licenses.properties";
    private static final String LICENSE_NAME_PROPERTY_PREFIX = "license.name.";
    private static final String LICENSE_TEXT_PROPERTY_PREFIX = "license.text.";
    private static final String LICENSE_URL_PROPERTY_PREFIX = "license.url.";
    private static final String DIRECTORIES_PROPFILE_PATH = "/org/gbif/metadata/eml/UserDirectories.properties";
    private MetadataSection section = MetadataSection.BASIC_SECTION;
    private MetadataSection next = MetadataSection.GEOGRAPHIC_COVERAGE_SECTION;
    private Map<String, String> languages;
    private Map<String, String> countries;
    private Map<String, String> ranks;
    private Map<String, String> roles;
    private Map<String, String> preservationMethods;
    private Map<String, String> types;
    private Map<String, String> datasetSubtypes;
    private Map<String, String> frequencies;
    private List<String> checklistSubtypeKeys;
    private List<String> occurrenceSubtypeKeys;
    private List<String> samplingEventSubtypeKeys;
    private static final CountryParser COUNTRY_PARSER = CountryParser.getInstance();
    private Agent primaryContact;
    private boolean doiReservedOrAssigned = false;
    private InferredEmlMetadata inferredMetadata;
    private final ConfigWarnings configWarnings;
    private static Properties licenseProperties;
    private static Properties directoriesProperties;
    private static Map<String, String> licenses;
    private static Map<String, String> licenseTexts;
    private static Map<String, String> licenseUrls;
    private static Map<String, String> userIdDirectories;
    private DataDir dataDir;
    private File file;

    @Inject
    public MetadataAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, VocabulariesManager vocabManager, ResourceMetadataInferringService resourceMetadataInferringService, ConfigWarnings configWarnings, DataDir dataDir) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.vocabManager = vocabManager;
        this.resourceMetadataInferringService = resourceMetadataInferringService;
        this.emlValidator = new EmlValidator(cfg, registrationManager, textProvider);
        this.configWarnings = configWarnings;
        this.dataDir = dataDir;
    }

    public Map<String, String> getCountries() {
        return this.countries;
    }

    public String getCurrentSideMenu() {
        return this.section.getName();
    }

    public Eml getEml() {
        return this.resource.getEml();
    }

    public boolean isInferGeocoverageAutomatically() {
        return this.resource.isInferGeocoverageAutomatically();
    }

    public void setInferGeocoverageAutomatically(boolean inferGeocoverageAutomatically) {
        this.resource.setInferGeocoverageAutomatically(inferGeocoverageAutomatically);
    }

    public boolean isInferTaxonomicCoverageAutomatically() {
        return this.resource.isInferTaxonomicCoverageAutomatically();
    }

    public void setInferTaxonomicCoverageAutomatically(boolean inferTaxonomicCoverageAutomatically) {
        this.resource.setInferTaxonomicCoverageAutomatically(inferTaxonomicCoverageAutomatically);
    }

    public boolean isInferTemporalCoverageAutomatically() {
        return this.resource.isInferTemporalCoverageAutomatically();
    }

    public void setInferTemporalCoverageAutomatically(boolean inferTemporalCoverageAutomatically) {
        this.resource.setInferTemporalCoverageAutomatically(inferTemporalCoverageAutomatically);
    }

    public Map<String, String> getJGTICuratorialUnitTypeOptions() {
        return JGTICuratorialUnitType.HTML_SELECT_MAP;
    }

    public String getLanguageIso3() {
        String iso3 = LangUtils.iso3((String)this.resource.getEml().getLanguage());
        if (this.languages.containsKey(iso3)) {
            return iso3;
        }
        return null;
    }

    public Map<String, String> getLanguages() {
        return this.languages;
    }

    public String getLicenseKeySelected() {
        String licenseText = this.resource.getEml().getIntellectualRights();
        if (StringUtils.isNotBlank((CharSequence)licenseText)) {
            String licenseTextUpdated = licenseText.replace(") 4.0", " 4.0)");
            for (Map.Entry entry : licenses.entrySet()) {
                String licenseName = (String)entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)licenseName) || !licenseTextUpdated.contains(licenseName)) continue;
                return (String)entry.getKey();
            }
            for (Map.Entry entry : licenseUrls.entrySet()) {
                String licenseUrl = (String)entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)licenseUrl) || !licenseTextUpdated.contains(licenseUrl)) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public Map<String, String> getLicenses() {
        return licenses;
    }

    public Map<String, String> getLicenseTexts() {
        return licenseTexts;
    }

    public Map<String, String> getLicenseUrls() {
        return licenseUrls;
    }

    public Map<String, String> getListSubtypes() {
        if (this.resource.getCoreType() == null) {
            if (this.resource.getCoreTypeTerm() != null) {
                String core = this.resource.getCoreTypeTerm().simpleName().toLowerCase();
                if (Constants.DWC_ROWTYPE_TAXON.toLowerCase().contains(core)) {
                    return this.getChecklistSubtypesMap();
                }
                if (Constants.DWC_ROWTYPE_OCCURRENCE.toLowerCase().contains(core)) {
                    return this.getOccurrenceSubtypesMap();
                }
                if (Constants.DWC_ROWTYPE_EVENT.toLowerCase().contains(core)) {
                    return this.getEmptySubtypeMap();
                }
            }
        } else {
            if (this.resource.getCoreType().equalsIgnoreCase(Resource.CoreRowType.CHECKLIST.toString())) {
                return this.getChecklistSubtypesMap();
            }
            if (this.resource.getCoreType().equalsIgnoreCase(Resource.CoreRowType.OCCURRENCE.toString())) {
                return this.getOccurrenceSubtypesMap();
            }
            if (this.resource.getCoreType().equalsIgnoreCase(Resource.CoreRowType.SAMPLINGEVENT.toString())) {
                return this.getSamplingEventSubtypesMap();
            }
            if (Resource.CoreRowType.OTHER.toString().equalsIgnoreCase(this.resource.getCoreType())) {
                return this.getEmptySubtypeMap();
            }
        }
        return new LinkedHashMap<String, String>();
    }

    public String getMetadataLanguageIso3() {
        String iso3 = LangUtils.iso3((String)this.resource.getEml().getMetadataLanguage());
        if (this.languages.containsKey(iso3)) {
            return iso3;
        }
        return null;
    }

    public String getNext() {
        return this.next.getName();
    }

    public Map<String, String> getPreservationMethods() {
        return this.preservationMethods;
    }

    public Map<String, String> getRanks() {
        return this.ranks;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public String getSection() {
        return this.section.getName();
    }

    public Map<String, String> getTempTypes() {
        return TemporalCoverageType.HTML_SELECT_MAP;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public void prepare() {
        boolean mappingsChangedAfterLastTry;
        super.prepare();
        if (this.session.get("curr_user") == null) {
            return;
        }
        String requestURI = this.req.getRequestURI();
        this.section = MetadataSection.fromName((String)StringUtils.substringBetween((String)this.req.getRequestURI(), (String)"metadata-", (String)"."));
        if (requestURI.contains("uploadlogo")) {
            this.section = MetadataSection.ADDITIONAL_SECTION;
        }
        boolean reinferMetadata = Boolean.parseBoolean(StringUtils.trimToNull((String)this.req.getParameter("reinferMetadata")));
        boolean bl = mappingsChangedAfterLastTry = !"metadata".equals(this.resource.getCoreType()) && this.resource.getInferredMetadata() != null && this.resource.getInferredMetadata().getLastModified() != null && this.resource.getMappingsModified() != null && this.resource.getMappingsModified().after(this.resource.getInferredMetadata().getLastModified());
        if (reinferMetadata || this.resource.getInferredMetadata() == null || mappingsChangedAfterLastTry) {
            InferredMetadata inferredMetadataRaw = this.resourceMetadataInferringService.inferMetadata(this.resource);
            if (inferredMetadataRaw instanceof InferredEmlMetadata) {
                this.inferredMetadata = (InferredEmlMetadata)inferredMetadataRaw;
            } else {
                LOG.error("Wrong type of the inferred metadata class, expected {} got {}", (Object)InferredEmlMetadata.class.getSimpleName(), (Object)inferredMetadataRaw.getClass().getSimpleName());
                this.inferredMetadata = new InferredEmlMetadata();
            }
            this.resource.setInferredMetadata((InferredMetadata)this.inferredMetadata);
            this.resourceManager.saveInferredMetadata(this.resource);
        } else if (this.resource.getInferredMetadata() instanceof InferredEmlMetadata) {
            this.inferredMetadata = (InferredEmlMetadata)this.resource.getInferredMetadata();
        } else {
            LOG.error("Wrong type of the stored inferred metadata class, expected {} got {}", (Object)InferredEmlMetadata.class.getSimpleName(), (Object)this.resource.getInferredMetadata().getClass().getSimpleName());
            this.inferredMetadata = new InferredEmlMetadata();
        }
        switch (1.$SwitchMap$org$gbif$ipt$model$voc$MetadataSection[this.section.ordinal()]) {
            case 1: {
                this.types = new LinkedHashMap();
                this.types.put("", this.getText("resource.coreType.selection"));
                this.types.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/datasetType", this.getLocaleLanguage(), false));
                this.types = MapUtils.getMapWithLowercaseKeys((Map)this.types);
                this.datasetSubtypes = new LinkedHashMap();
                this.datasetSubtypes.put("", this.getText("resource.subtype.selection"));
                this.datasetSubtypes.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/datasetSubtype", this.getLocaleLanguage(), false));
                this.datasetSubtypes = MapUtils.getMapWithLowercaseKeys((Map)this.datasetSubtypes);
                this.groupDatasetSubtypes();
                this.frequencies = new LinkedHashMap();
                this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/eml/updateFrequency", this.getLocaleLanguage(), false).entrySet().stream().filter(p -> !"unkown".equals(p.getKey())).forEach(p -> this.frequencies.put((String)p.getKey(), (String)p.getValue()));
                if (this.getEml().getIntellectualRights() != null) {
                    this.getEml().setIntellectualRights(this.removeNewlineCharacters(this.getEml().getIntellectualRights()));
                }
                if (Resource.CoreRowType.OCCURRENCE.toString().equalsIgnoreCase(this.resource.getCoreType()) && this.resource.isPublished() && this.resource.isPubliclyAvailable()) {
                    this.resource.getEml().setDistributionDownloadUrl(this.cfg.getBaseUrl() + "/archive.do?r=" + this.resource.getShortname());
                }
                this.loadAgentVocabularies();
                try {
                    MetadataAction.loadLicenseMaps((String)this.getText("eml.intellectualRights.nolicenses"));
                }
                catch (InvalidConfigException e) {
                    this.configWarnings.addStartupError(e.getMessage(), (Exception)((Object)e));
                }
                try {
                    MetadataAction.loadDirectories((String)this.getText("eml.contact.noDirectory"));
                }
                catch (InvalidConfigException e) {
                    this.configWarnings.addStartupError(e.getMessage(), (Exception)((Object)e));
                }
                if (this.getRegisteredIpt() == null && this.getDefaultOrganisation() != null) {
                    this.resource.setOrganisation(this.getDefaultOrganisation());
                    this.addActionWarning(this.getText("manage.overview.visibility.missing.organisation"));
                }
                if (!this.isHttpPost()) break;
                this.resource.getEml().setIntellectualRights(null);
                break;
            }
            case 2: {
                this.loadAgentVocabularies();
                if (!this.isHttpPost()) break;
                this.resource.getEml().getContacts().clear();
                this.resource.getEml().getCreators().clear();
                this.resource.getEml().getMetadataProviders().clear();
                this.resource.getEml().getAssociatedParties().clear();
                break;
            }
            case 3: {
                if (!this.isHttpPost()) break;
                this.resource.getEml().getGeospatialCoverages().clear();
                break;
            }
            case 4: {
                this.ranks = new LinkedHashMap();
                this.ranks.put("", this.getText("eml.rank.selection"));
                this.ranks.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/rank", this.getLocaleLanguage(), false));
                if (!this.isHttpPost()) break;
                this.resource.getEml().getTaxonomicCoverages().clear();
                break;
            }
            case 5: {
                if (!this.isHttpPost()) break;
                this.resource.getEml().getTemporalCoverages().clear();
                break;
            }
            case 6: {
                if (!this.isHttpPost()) break;
                this.resource.getEml().getKeywords().clear();
                break;
            }
            case 7: {
                this.loadAgentVocabularies();
                if (!this.isHttpPost()) break;
                this.resource.getEml().getProject().getPersonnel().clear();
                this.resource.getEml().getProject().getAwards().clear();
                this.resource.getEml().getProject().getRelatedProjects().clear();
                break;
            }
            case 8: {
                if (!this.isHttpPost()) break;
                this.resource.getEml().getMethodSteps().clear();
                break;
            }
            case 9: {
                if (this.isHttpPost()) {
                    this.resource.getEml().getBibliographicCitationSet().getBibliographicCitations().clear();
                }
                this.doiReservedOrAssigned = this.hasDoiReservedOrAssigned(this.resource);
                if (!this.doiReservedOrAssigned || this.isHttpPost()) break;
                this.addActionMessage("The DOI reserved or registered for this resource is being used as the citation identifier");
                break;
            }
            case 10: {
                this.preservationMethods = new LinkedHashMap();
                this.preservationMethods.put("", this.getText("eml.preservation.methods.selection"));
                this.preservationMethods.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/preservation_method", this.getLocaleLanguage(), false));
                if (!this.isHttpPost()) break;
                this.resource.getEml().getCollections().clear();
                this.resource.getEml().getSpecimenPreservationMethods().clear();
                this.resource.getEml().getJgtiCuratorialUnits().clear();
                break;
            }
            case 11: {
                if (!this.isHttpPost()) break;
                this.resource.getEml().getPhysicalData().clear();
                break;
            }
            case 12: {
                if (!this.isHttpPost()) break;
                this.resource.getEml().getAlternateIdentifiers().clear();
                break;
            }
        }
    }

    public String save() throws Exception {
        if (this.emlValidator.isSectionValid(this.resource, this.section, (ErrorCollector)new ActionErrorCollector((BaseAction)this), (I18n)new StrutsI18n((BaseAction)this))) {
            this.resourceManager.saveEml(this.resource);
            this.resource.setMetadataModified(new Date());
            this.addActionMessage(this.getText("manage.success", new String[]{this.getText("submenu." + this.section.getName())}));
            this.resourceManager.save(this.resource);
            switch (1.$SwitchMap$org$gbif$ipt$model$voc$MetadataSection[this.section.ordinal()]) {
                case 1: {
                    this.next = MetadataSection.CONTACTS_SECTION;
                    break;
                }
                case 2: {
                    this.next = MetadataSection.ACKNOWLEDGEMENTS_SECTION;
                    break;
                }
                case 13: {
                    this.next = MetadataSection.GEOGRAPHIC_COVERAGE_SECTION;
                    break;
                }
                case 3: {
                    this.next = MetadataSection.TAXANOMIC_COVERAGE_SECTION;
                    break;
                }
                case 4: {
                    this.next = MetadataSection.TEMPORAL_COVERAGE_SECTION;
                    break;
                }
                case 5: {
                    this.next = MetadataSection.ADDITIONAL_DESCRIPTION_SECTION;
                    break;
                }
                case 14: {
                    this.next = MetadataSection.KEYWORDS_SECTION;
                    break;
                }
                case 6: {
                    this.next = MetadataSection.PROJECT_SECTION;
                    break;
                }
                case 7: {
                    this.next = MetadataSection.METHODS_SECTION;
                    break;
                }
                case 8: {
                    this.next = MetadataSection.CITATIONS_SECTION;
                    break;
                }
                case 9: {
                    this.next = MetadataSection.COLLECTIONS_SECTION;
                    break;
                }
                case 10: {
                    this.next = MetadataSection.PHYSICAL_SECTION;
                    break;
                }
                case 11: {
                    this.next = MetadataSection.ADDITIONAL_SECTION;
                    break;
                }
                case 12: {
                    this.next = MetadataSection.BASIC_SECTION;
                    break;
                }
            }
        } else {
            this.next = this.section;
        }
        return "success";
    }

    public void validateHttpPostOnly() {
        this.validatorRes.validate((BaseAction)this, this.resource);
        this.emlValidator.validate(this.resource, this.section, (ErrorCollector)new ActionErrorCollector((BaseAction)this), (I18n)new StrutsI18n((BaseAction)this));
    }

    public Map<String, String> getDatasetSubtypes() {
        return this.datasetSubtypes;
    }

    public Map<String, String> getOccurrenceSubtypesMap() {
        LinkedHashMap<String, String> datasetSubtypesCopy = new LinkedHashMap<String, String>(this.datasetSubtypes);
        for (String key : this.checklistSubtypeKeys) {
            datasetSubtypesCopy.remove(key);
        }
        return datasetSubtypesCopy;
    }

    public Map<String, String> getSamplingEventSubtypesMap() {
        LinkedHashMap<String, String> datasetSubtypesCopy = new LinkedHashMap<String, String>(this.datasetSubtypes);
        for (String key : this.checklistSubtypeKeys) {
            datasetSubtypesCopy.remove(key);
        }
        return datasetSubtypesCopy;
    }

    public Map<String, String> getChecklistSubtypesMap() {
        LinkedHashMap<String, String> datasetSubtypesCopy = new LinkedHashMap<String, String>(this.datasetSubtypes);
        for (String key : this.occurrenceSubtypeKeys) {
            datasetSubtypesCopy.remove(key);
        }
        return datasetSubtypesCopy;
    }

    public Map<String, String> getEmptySubtypeMap() {
        LinkedHashMap<String, String> subtypeMap = new LinkedHashMap<String, String>();
        subtypeMap.put("", this.getText("resource.subtype.none"));
        return subtypeMap;
    }

    void groupDatasetSubtypes() {
        ArrayList<String> occurrenceKeys = new ArrayList<String>();
        for (Object type : DatasetSubtype.OCCURRENCE_DATASET_SUBTYPES) {
            occurrenceKeys.add(type.name().replaceAll("_", "").toLowerCase());
        }
        this.occurrenceSubtypeKeys = Collections.unmodifiableList(occurrenceKeys);
        ArrayList<String> checklistKeys = new ArrayList<String>();
        for (DatasetSubtype type : DatasetSubtype.CHECKLIST_DATASET_SUBTYPES) {
            checklistKeys.add(type.name().replaceAll("_", "").toLowerCase());
        }
        this.checklistSubtypeKeys = Collections.unmodifiableList(checklistKeys);
        ArrayList<String> samplingEventKeys = new ArrayList<String>();
        for (DatasetSubtype type : DatasetSubtype.SAMPLING_EVENT_DATASET_SUBTYPES) {
            samplingEventKeys.add(type.name().replaceAll("_", "").toLowerCase());
        }
        this.samplingEventSubtypeKeys = Collections.unmodifiableList(samplingEventKeys);
    }

    void setDatasetSubtypes(Map<String, String> datasetSubtypes) {
        this.datasetSubtypes = datasetSubtypes;
    }

    List<String> getChecklistSubtypeKeys() {
        return this.checklistSubtypeKeys;
    }

    List<String> getOccurrenceSubtypeKeys() {
        return this.occurrenceSubtypeKeys;
    }

    List<String> getSamplingEventSubtypeKeys() {
        return this.samplingEventSubtypeKeys;
    }

    public String getResourceHasCore() {
        return this.resource.hasCore() ? "true" : "false";
    }

    public Map<String, String> getFrequencies() {
        return this.frequencies;
    }

    public Agent getPrimaryContact() {
        return this.primaryContact;
    }

    public void setPrimaryContact(Agent primaryContact) {
        this.primaryContact = primaryContact;
    }

    public Map<String, String> getUserIdDirectories() {
        if (userIdDirectories == null) {
            MetadataAction.loadDirectories((String)this.getText("eml.contact.noDirectory"));
        }
        return userIdDirectories;
    }

    public static synchronized Properties licenseProperties() throws InvalidConfigException {
        if (licenseProperties == null) {
            Properties p = new Properties();
            try {
                p.load(MetadataAction.class.getResourceAsStream("/org/gbif/metadata/eml/licenses.properties"));
                LOG.debug("Loaded licenses from /org/gbif/metadata/eml/licenses.properties");
            }
            catch (IOException e) {
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, "Failed to load licenses from /org/gbif/metadata/eml/licenses.properties");
            }
            finally {
                licenseProperties = p;
            }
        }
        return licenseProperties;
    }

    public static synchronized Properties directoriesProperties() throws InvalidConfigException {
        if (directoriesProperties == null) {
            Properties p = new Properties();
            try {
                p.load(MetadataAction.class.getResourceAsStream("/org/gbif/metadata/eml/UserDirectories.properties"));
                LOG.debug("Loaded directories from /org/gbif/metadata/eml/UserDirectories.properties");
            }
            catch (IOException e) {
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, "Failed to load directories from /org/gbif/metadata/eml/UserDirectories.properties");
            }
            finally {
                directoriesProperties = p;
            }
        }
        return directoriesProperties;
    }

    public static synchronized void loadLicenseMaps(String firstOption) throws InvalidConfigException {
        if (licenses == null || licenseTexts == null || licenseUrls == null) {
            licenses = new TreeMap(new LicenceComparator());
            licenses.put("", firstOption == null ? "-" : firstOption);
            licenseTexts = new TreeMap();
            licenseUrls = new TreeMap();
            Properties properties = MetadataAction.licenseProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = StringUtils.trim((String)((String)entry.getKey()));
                String value = StringUtils.trim((String)((String)entry.getValue()));
                if (key == null || !key.startsWith("license.name.") || value == null) continue;
                String keyMinusPrefix = StringUtils.trimToNull((String)key.replace("license.name.", ""));
                if (keyMinusPrefix != null) {
                    String licenseText = StringUtils.trimToNull((String)properties.getProperty("license.text." + keyMinusPrefix));
                    String licenseUrl = StringUtils.trimToNull((String)properties.getProperty("license.url." + keyMinusPrefix));
                    if (licenseText == null) continue;
                    licenses.put(keyMinusPrefix, value);
                    licenseTexts.put(keyMinusPrefix, licenseText);
                    licenseUrls.put(keyMinusPrefix, licenseUrl);
                    continue;
                }
                String error = "/org/gbif/metadata/eml/licenses.properties has been been configured wrong.";
                LOG.error(error);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, error);
            }
            if (licenses.size() - 1 == 0) {
                String error = "No licenses could be loaded from /org/gbif/metadata/eml/licenses.properties. Please check configuration.";
                LOG.error(error);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, error);
            }
        }
    }

    public static synchronized void loadDirectories(String firstOption) throws InvalidConfigException {
        if (userIdDirectories == null) {
            userIdDirectories = new TreeMap();
            userIdDirectories.put("", firstOption == null ? "-" : firstOption);
            Properties properties = MetadataAction.directoriesProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = StringUtils.trim((String)((String)entry.getKey()));
                String value = StringUtils.trim((String)((String)entry.getValue()));
                if (key != null && value != null) {
                    userIdDirectories.put(key, value);
                    continue;
                }
                String error = "/org/gbif/metadata/eml/UserDirectories.properties has been been configured wrong.";
                LOG.error(error);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, error);
            }
            if (userIdDirectories.size() - 1 == 0) {
                String error = "No licenses could be loaded from /org/gbif/metadata/eml/UserDirectories.properties. Please check configuration.";
                LOG.error(error);
                throw new InvalidConfigException(InvalidConfigException.TYPE.INVALID_PROPERTIES_FILE, error);
            }
        }
    }

    private void loadAgentVocabularies() {
        block9: {
            ParseResult result;
            String countryValue;
            block10: {
                this.languages = this.vocabManager.getI18nVocab("http://iso.org/639-2", this.getLocaleLanguage(), true);
                this.countries = new LinkedHashMap();
                this.countries.put("", this.getText("eml.country.selection"));
                this.countries.putAll(this.vocabManager.getI18nVocab("http://iso.org/iso3166-1/alpha2", this.getLocaleLanguage(), true));
                this.roles = new LinkedHashMap();
                this.roles.put("", this.getText("eml.agent.role.selection"));
                this.roles.putAll(this.vocabManager.getI18nVocab("http://rs.gbif.org/vocabulary/gbif/agentRole", this.getLocaleLanguage(), false));
                if (this.resource == null || this.resource.getEml() == null) break block9;
                Agent firstContact = null;
                if (!this.resource.getEml().getContacts().isEmpty()) {
                    for (Agent contact : this.resource.getEml().getContacts()) {
                        if (firstContact == null) {
                            firstContact = contact;
                        }
                        if ((countryValue = contact.getAddress().getCountry()) == null || !(result = COUNTRY_PARSER.parse(countryValue)).isSuccessful()) continue;
                        contact.getAddress().setCountry(((Country)result.getPayload()).getIso2LetterCode());
                    }
                }
                if (firstContact == null) {
                    firstContact = new Agent();
                }
                if (firstContact.getUserIds().isEmpty()) {
                    ArrayList userIds = new ArrayList();
                    firstContact.setUserIds(userIds);
                }
                this.setPrimaryContact(firstContact);
                if (!this.resource.getEml().getCreators().isEmpty()) {
                    for (Agent creator : this.resource.getEml().getCreators()) {
                        countryValue = creator.getAddress().getCountry();
                        if (countryValue == null) continue;
                        result = COUNTRY_PARSER.parse(countryValue);
                        creator.getAddress().setCountry(((Country)result.getPayload()).getIso2LetterCode());
                    }
                }
                if (this.resource.getEml().getMetadataProviders().isEmpty()) break block10;
                for (Agent metadataProvider : this.resource.getEml().getMetadataProviders()) {
                    countryValue = metadataProvider.getAddress().getCountry();
                    if (countryValue == null) continue;
                    result = COUNTRY_PARSER.parse(countryValue);
                    metadataProvider.getAddress().setCountry(((Country)result.getPayload()).getIso2LetterCode());
                }
                break block9;
            }
            if (this.resource.getEml().getAssociatedParties().isEmpty()) break block9;
            for (Agent party : this.resource.getEml().getAssociatedParties()) {
                countryValue = Optional.ofNullable(party).map(Agent::getAddress).map(Address::getCountry).orElse(null);
                if (countryValue == null || !(result = COUNTRY_PARSER.parse(countryValue)).isSuccessful()) continue;
                party.getAddress().setCountry(((Country)result.getPayload()).getIso2LetterCode());
            }
        }
    }

    public boolean hasDoiReservedOrAssigned(Resource resource) {
        return resource.getDoi() != null && resource.getIdentifierStatus() != IdentifierStatus.UNRESERVED;
    }

    public boolean isDoiReservedOrAssigned() {
        return this.doiReservedOrAssigned;
    }

    protected String removeNewlineCharacters(String s) {
        if (s != null) {
            s = s.replaceAll("\\r\\n|\\r|\\n", " ");
        }
        return s;
    }

    public InferredEmlMetadata getInferredMetadata() {
        return this.inferredMetadata;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String uploadLogo() {
        if (this.file != null) {
            for (String suffix : Constants.IMAGE_TYPES) {
                FileUtils.deleteQuietly((File)this.dataDir.resourceLogoFile(this.resource.getShortname(), suffix));
            }
            String type = "jpeg";
            String fileContentType = Optional.ofNullable(ActionContext.getContext()).map(ActionContext::getParameters).map(p -> p.get((Object)"fileContentType")).map(Parameter::getValue).orElse(null);
            if (fileContentType != null) {
                type = StringUtils.substringAfterLast((String)fileContentType, (String)"/");
            }
            File logoFile = this.dataDir.resourceLogoFile(this.resource.getShortname(), type);
            try {
                FileUtils.copyFile((File)this.file, (File)logoFile);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
            }
        }
        return "input";
    }
}

