/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import com.opensymphony.xwork2.interceptor.ValidationErrorAware;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Extension;
import org.gbif.ipt.model.ExtensionMapping;
import org.gbif.ipt.model.ExtensionProperty;
import org.gbif.ipt.model.PropertyMapping;
import org.gbif.ipt.model.RecordFilter;
import org.gbif.ipt.model.Source;
import org.gbif.ipt.model.SourceWithHeader;
import org.gbif.ipt.service.admin.ExtensionManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.VocabulariesManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.SourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.ExtensionMappingValidator;

public class MappingAction
extends ManagerBaseAction
implements ValidationErrorAware {
    private static final long serialVersionUID = -831969146160030857L;
    private static final Logger LOG = LogManager.getLogger(MappingAction.class);
    private static final Pattern NORM_TERM = Pattern.compile("[^a-zA-Z0-9:]+");
    public static final String DC_NAMESPACE = "http://purl.org/dc/elements/1.1";
    public static final String DC_TERMS_NAMESPACE = "http://purl.org/dc/terms";
    public static final String DWC_NAMESPACE = "https://dwc.tdwg.org/terms";
    public static final String DC_PREFIX = "dc:";
    public static final String DC_TERMS_PREFIX = "dcterms:";
    public static final String DWC_PREFIX = "dwc:";
    private final ExtensionManager extensionManager;
    private final SourceManager sourceManager;
    private final VocabulariesManager vocabManager;
    private ExtensionMapping mapping;
    private List<String> columns = new ArrayList();
    private final RecordFilter.Comparator[] comparators = RecordFilter.Comparator.values();
    private List<String[]> peek;
    private List<PropertyMapping> fields;
    private Map<String, Integer> fieldsTermIndices = new HashMap();
    private Map<String, List<PropertyMapping>> fieldsByGroup = new LinkedHashMap();
    private final Map<String, Map<String, String>> vocabTerms = new HashMap();
    private ExtensionProperty coreid;
    private ExtensionProperty datasetId;
    private Integer mid;
    private PropertyMapping mappingCoreid;
    private boolean doiUsedForDatasetId;

    @Inject
    public MappingAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, ExtensionManager extensionManager, SourceManager sourceManager, VocabulariesManager vocabManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.extensionManager = extensionManager;
        this.sourceManager = sourceManager;
        this.vocabManager = vocabManager;
    }

    private void validateAndReport() {
        if (this.mapping.getSource() == null) {
            return;
        }
        ExtensionMappingValidator validator = new ExtensionMappingValidator();
        ExtensionMappingValidator.ValidationStatus v = validator.validate(this.mapping, this.resource, this.peek, this.columns);
        if (v != null && !v.isValid()) {
            if (v.getIdProblem() != null) {
                this.addActionWarning(this.getText(v.getIdProblem(), v.getIdProblemParams()));
            }
            for (Term t : v.getMissingRequiredFields()) {
                this.addActionWarning(this.getText("validation.required", new String[]{t.simpleName()}));
            }
            for (Term t : v.getWrongDataTypeFields()) {
                this.addActionWarning(this.getText("validation.wrong.datatype", new String[]{t.simpleName()}));
            }
            for (String columnName : v.getMultipleTranslationsForSameColumn()) {
                this.addActionError(this.getText("validation.column.multipleTranslations", new String[]{columnName}));
            }
        }
    }

    int automap() {
        int automapped = 0;
        int idx1 = 0;
        for (String col : this.columns) {
            String normCol = this.normalizeColumnName(col);
            if (normCol != null && (this.termNormalizedPrefixedName(this.mappingCoreid.getTerm()).equalsIgnoreCase(normCol) || TermFactory.normaliseTerm((String)this.mappingCoreid.getTerm().simpleName()).equalsIgnoreCase(normCol))) {
                this.mappingCoreid.setIndex(Integer.valueOf(idx1));
                this.mapping.setIdColumn(Integer.valueOf(idx1));
                ++automapped;
                break;
            }
            ++idx1;
        }
        block1: for (PropertyMapping f : this.fields) {
            int idx2 = 0;
            for (String col : this.columns) {
                String normCol = this.normalizeColumnName(col);
                if (normCol != null && (this.termNormalizedPrefixedName(f.getTerm()).equalsIgnoreCase(normCol) || TermFactory.normaliseTerm((String)f.getTerm().simpleName()).equalsIgnoreCase(normCol))) {
                    f.setIndex(Integer.valueOf(idx2));
                    ++automapped;
                    continue block1;
                }
                ++idx2;
            }
        }
        return automapped;
    }

    public String cancel() {
        if (this.mapping != null && this.mapping.getSource() == null && this.mapping.getFields().isEmpty()) {
            this.resource.deleteMapping(this.mapping);
            this.saveResource();
        }
        return "cancel";
    }

    public String delete() {
        if (this.resource.deleteMapping(this.mapping)) {
            this.addActionMessage(this.getText("manage.mapping.deleted", new String[]{this.id}));
            this.resource.setMappingsModified(new Date());
            this.saveResource();
        } else {
            this.addActionMessage(this.getText("manage.mapping.couldnt.delete", new String[]{this.id}));
        }
        return "success";
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public RecordFilter.Comparator[] getComparators() {
        return this.comparators;
    }

    public ExtensionProperty getCoreid() {
        return this.coreid;
    }

    public List<PropertyMapping> getFields() {
        return this.fields;
    }

    public ExtensionMapping getMapping() {
        return this.mapping;
    }

    public PropertyMapping getMappingCoreid() {
        return this.mappingCoreid;
    }

    public ExtensionProperty getDatasetId() {
        return this.datasetId;
    }

    public Integer getMid() {
        return this.mid;
    }

    public List<String> getNonMappedColumns() {
        ArrayList<String> mapped = new ArrayList<String>();
        if (this.columns.isEmpty()) {
            return mapped;
        }
        for (PropertyMapping field : this.fields) {
            String sourceColumn;
            if (field.getIndex() == null || field.getIndex() < 0 || field.getIndex() >= this.columns.size() || (sourceColumn = (String)this.columns.get(field.getIndex())) == null) continue;
            mapped.add(sourceColumn);
        }
        if (this.mappingCoreid.getIndex() != null && this.mappingCoreid.getIndex() >= 0 && this.mappingCoreid.getIndex() < this.columns.size() && this.columns.get(this.mappingCoreid.getIndex()) != null) {
            mapped.add((String)this.columns.get(this.mappingCoreid.getIndex()));
        }
        ArrayList<String> nonMapped = new ArrayList<String>(this.columns);
        nonMapped.removeAll(mapped);
        return nonMapped;
    }

    public List<String> getRedundantGroups() {
        List<String> redundantGroups = new ArrayList<String>();
        if (this.resource.getCoreRowType() != null && this.mapping != null && this.mapping.getExtension() != null && !this.resource.getCoreRowType().equalsIgnoreCase(this.mapping.getExtension().getRowType())) {
            Extension core = this.extensionManager.get(this.resource.getCoreRowType());
            redundantGroups = this.extensionManager.getRedundantGroups(this.mapping.getExtension(), core);
        }
        return redundantGroups;
    }

    public List<String[]> getPeek() {
        return this.peek;
    }

    public Map<String, Map<String, String>> getVocabTerms() {
        return this.vocabTerms;
    }

    String normalizeColumnName(String col) {
        if (StringUtils.isNotBlank((CharSequence)col)) {
            col = NORM_TERM.matcher(col.toLowerCase()).replaceAll("");
            return col;
        }
        return null;
    }

    String termNormalizedPrefixedName(Term term) {
        String termNamespace = term.namespace().toString();
        if (termNamespace.startsWith(DC_NAMESPACE)) {
            return DC_PREFIX + TermFactory.normaliseTerm((String)term.simpleName());
        }
        if (termNamespace.startsWith(DC_TERMS_NAMESPACE)) {
            return DC_TERMS_PREFIX + TermFactory.normaliseTerm((String)term.simpleName());
        }
        if (termNamespace.startsWith(DWC_NAMESPACE)) {
            return DWC_PREFIX + TermFactory.normaliseTerm((String)term.simpleName());
        }
        return TermFactory.normaliseTerm((String)term.simpleName());
    }

    public void prepare() {
        super.prepare();
        String midStr = StringUtils.trimToNull((String)this.req.getParameter("mid"));
        if (midStr != null) {
            this.mid = Integer.valueOf(midStr);
        }
        if (this.id != null) {
            if (this.mid == null) {
                Extension ext = this.extensionManager.get(this.id);
                if (ext != null) {
                    this.mapping = new ExtensionMapping();
                    this.mapping.setExtension(ext);
                } else {
                    this.addActionError(this.getText("manage.overview.DwC.Mappings.select.invalid"));
                    this.defaultResult = "error";
                }
            } else {
                List maps = this.resource.getMappings(this.id);
                this.mapping = (ExtensionMapping)maps.get(this.mid);
                Extension ext = this.extensionManager.get(this.id);
                if (!ext.isLatest()) {
                    this.addActionWarning(this.getText("manage.overview.mappings.extension.outdated"));
                }
            }
        } else {
            this.notFound = true;
        }
        if (!this.cancel && !this.delete && this.mapping != null && this.mapping.getExtension() != null) {
            int automapped;
            String coreRowType;
            if (this.mapping.getSource() == null) {
                String source = StringUtils.trimToNull((String)this.req.getParameter("source"));
                if (source != null) {
                    Source src = this.resource.getSource(source);
                    this.mapping.setSource(src);
                } else {
                    this.defaultResult = "source";
                }
            }
            if (this.mapping.getFilter() == null) {
                this.mapping.setFilter(new RecordFilter());
            }
            if ((coreRowType = this.resource.getCoreRowType()) == null) {
                coreRowType = this.mapping.getExtension().getRowType();
            }
            LOG.info("Core row type: " + coreRowType);
            String coreIdTerm = AppConfig.coreIdTerm((String)coreRowType);
            this.coreid = this.extensionManager.get(coreRowType).getProperty(coreIdTerm);
            LOG.info("Field representing the id for the core: " + String.valueOf(this.coreid));
            this.mappingCoreid = this.mapping.getField(this.coreid.getQualname());
            if (this.mappingCoreid == null) {
                this.mappingCoreid = new PropertyMapping();
                this.mappingCoreid.setTerm((Term)this.coreid);
                this.mappingCoreid.setIndex(this.mapping.getIdColumn());
                this.fields = new ArrayList(this.mapping.getExtension().getProperties().size());
            } else {
                this.fields = new ArrayList(this.mapping.getExtension().getProperties().size() - 1);
            }
            this.readSource();
            this.datasetId = this.extensionManager.get(this.mapping.getExtension().getRowType()).getProperty("http://rs.tdwg.org/dwc/terms/datasetID");
            for (int i = 0; i < this.mapping.getExtension().getProperties().size(); ++i) {
                ExtensionProperty ep = (ExtensionProperty)this.mapping.getExtension().getProperties().get(i);
                if (ep.equals((Object)this.coreid)) continue;
                PropertyMapping pm = this.populatePropertyMapping(ep);
                this.fields.add(pm);
                String group = StringUtils.trimToEmpty((String)ep.getGroup());
                this.fieldsByGroup.computeIfAbsent(group, k -> new ArrayList());
                ((List)this.fieldsByGroup.get(group)).add(pm);
                this.fieldsTermIndices.put(ep.getQualname(), this.fields.lastIndexOf(pm));
                if (ep.getVocabulary() == null) continue;
                String id = ep.getVocabulary().getUriString();
                this.vocabTerms.put(id, this.vocabManager.getI18nVocab(id, this.getLocaleLanguage(), true));
            }
            if (this.mapping.getFields().isEmpty() && (automapped = this.automap()) > 0) {
                this.addActionMessage(this.getText("manage.mapping.automaped", new String[]{String.valueOf(automapped)}));
            }
            this.setDoiUsedForDatasetId(this.mapping.isDoiUsedForDatasetId());
            if (!this.isHttpPost()) {
                this.validateAndReport();
            }
        }
    }

    private PropertyMapping populatePropertyMapping(ExtensionProperty ep) {
        PropertyMapping pm = this.mapping.getField(ep.getQualname());
        if (pm == null) {
            pm = new PropertyMapping();
        }
        pm.setTerm((Term)ep);
        return pm;
    }

    private void readSource() {
        Source src = this.mapping.getSource();
        if (src == null) {
            this.columns = new ArrayList();
        } else {
            try {
                this.peek = this.sourceManager.peek(src, 5);
                this.columns = (src.isUrlSource() || src.isFileSource()) && ((SourceWithHeader)src).getIgnoreHeaderLines() == 0 ? this.mapping.getColumns(this.peek) : this.sourceManager.columns(src);
                if (this.columns.isEmpty() && src.getName() != null) {
                    this.addActionWarning(this.getText("manage.mapping.source.no.columns", new String[]{src.getName()}));
                }
            }
            catch (Exception e) {
                this.addActionError(this.getText("manage.mapping.source.read.failed", new String[]{src.getName()}));
            }
        }
    }

    public String save() throws IOException {
        if (this.resource.getMapping(this.id, this.mid) == null) {
            this.mid = this.resource.addMapping(this.mapping);
        } else {
            TreeSet<PropertyMapping> mappedFields = new TreeSet<PropertyMapping>();
            for (PropertyMapping f : this.fields) {
                int index;
                int n = index = f.getIndex() != null ? f.getIndex() : -9999;
                if (index < 0 && StringUtils.trimToNull((String)f.getDefaultValue()) == null) continue;
                mappedFields.add(f);
            }
            if (this.resource.getCoreRowType() != null && this.resource.getCoreRowType().equalsIgnoreCase(this.mapping.getExtension().getRowType())) {
                int index;
                this.mappingCoreid.setIndex(this.mapping.getIdColumn());
                this.mappingCoreid.setDefaultValue(this.mapping.getIdSuffix());
                int n = index = this.mappingCoreid.getIndex() != null ? this.mappingCoreid.getIndex() : -9999;
                if (index >= 0 || StringUtils.trimToNull((String)this.mappingCoreid.getDefaultValue()) != null) {
                    mappedFields.add(this.mappingCoreid);
                }
            }
            this.mapping.setFields(mappedFields);
            this.mapping.setDoiUsedForDatasetId(this.doiUsedForDatasetId);
        }
        Date lastModified = new Date();
        this.mapping.setLastModified(lastModified);
        this.resource.setMappingsModified(lastModified);
        this.saveResource();
        this.validateAndReport();
        LOG.debug("mapping saved..");
        this.id = URLEncoder.encode(this.id, StandardCharsets.UTF_8.toString());
        return "save";
    }

    public String saveSetSource() {
        return "input";
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void setFields(List<PropertyMapping> fields) {
        this.fields = fields;
    }

    public void setMapping(ExtensionMapping mapping) {
        this.mapping = mapping;
    }

    public void setMappingCoreid(PropertyMapping mappingCoreid) {
        this.mappingCoreid = mappingCoreid;
    }

    public void setDatasetId(ExtensionProperty datasetId) {
        this.datasetId = datasetId;
    }

    public void setMid(Integer mid) {
        this.mid = mid;
    }

    public boolean isDoiUsedForDatasetId() {
        return this.doiUsedForDatasetId;
    }

    public void setDoiUsedForDatasetId(boolean doiUsedForDatasetId) {
        this.doiUsedForDatasetId = doiUsedForDatasetId;
    }

    public Map<String, List<PropertyMapping>> getFieldsByGroup() {
        return this.fieldsByGroup;
    }

    public Map<String, Integer> getFieldsTermIndices() {
        return this.fieldsTermIndices;
    }

    public boolean isCoreMapping() {
        if (this.mapping.isCore() && this.resource.getCoreRowType() != null) {
            return this.resource.getCoreRowType().equalsIgnoreCase(this.mapping.getExtension().getRowType());
        }
        return false;
    }

    public String actionErrorOccurred(String currentResultName) {
        return this.defaultResult;
    }
}

