/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.InvalidConfigException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class ManagerBaseAction
extends POSTAction {
    private static final long serialVersionUID = -7385261456013846954L;
    protected final ResourceManager resourceManager;
    protected Resource resource;

    @Inject
    public ManagerBaseAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.resourceManager = resourceManager;
    }

    public void prepare() {
        super.prepare();
        String res = StringUtils.trimToNull((String)this.req.getParameter("r"));
        if (res == null) {
            try {
                res = (String)this.session.get("curr_resource");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resource = this.resourceManager.get(res);
        if (this.resource == null) {
            this.notFound = true;
        }
    }

    protected void saveResource() {
        try {
            this.resourceManager.save(this.resource);
        }
        catch (InvalidConfigException e) {
            this.addActionError(e.getMessage());
        }
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }
}

