/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.manage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.manage.DataPackageMetadataAction;
import org.gbif.ipt.action.manage.ManagerBaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.InferredCamtrapGeographicScope;
import org.gbif.ipt.model.InferredCamtrapMetadata;
import org.gbif.ipt.model.InferredCamtrapTaxonomicScope;
import org.gbif.ipt.model.InferredCamtrapTemporalScope;
import org.gbif.ipt.model.InferredMetadata;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.datapackage.metadata.DataPackageMetadata;
import org.gbif.ipt.model.datapackage.metadata.FrictionlessMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapContributor;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapLicense;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapMetadata;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CaptureMethod;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Geojson;
import org.gbif.ipt.model.datapackage.metadata.camtrap.ObservationLevel;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Project;
import org.gbif.ipt.model.datapackage.metadata.camtrap.RelatedIdentifier;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Taxonomic;
import org.gbif.ipt.model.datapackage.metadata.camtrap.Temporal;
import org.gbif.ipt.model.voc.CamtrapMetadataSection;
import org.gbif.ipt.model.voc.DataPackageMetadataSection;
import org.gbif.ipt.model.voc.FrictionlessMetadataSection;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.manage.ResourceMetadataInferringService;
import org.gbif.ipt.service.manage.impl.ResourceManagerImpl;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.DataPackageMetadataValidator;

public class DataPackageMetadataAction
extends ManagerBaseAction {
    private static final Logger LOG = LogManager.getLogger(DataPackageMetadataAction.class);
    private static final long serialVersionUID = -1669636958170716515L;
    private final ResourceMetadataInferringService metadataInferringService;
    private final DataPackageMetadataValidator metadataValidator;
    private final ObjectMapper objectMapper;
    private final DataPackageSchemaManager dataPackageSchemaManager;
    private DataPackageMetadataSection section = FrictionlessMetadataSection.BASIC_SECTION;
    private DataPackageMetadataSection next = FrictionlessMetadataSection.BASIC_SECTION;
    private Map<String, String> organisations = new LinkedHashMap();
    private InferredMetadata inferredMetadata;
    private String customGeoJson;
    public static final Map<String, String> GBIF_SUPPORTED_LICENSES_VOCABULARY = new LinkedHashMap();
    public static final Map<String, String> OPEN_DEFINITION_LICENSES_VOCABULARY = new LinkedHashMap();

    @Inject
    public DataPackageMetadataAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager, DataPackageMetadataValidator metadataValidator, ResourceMetadataInferringService metadataInferringService, DataPackageSchemaManager dataPackageSchemaManager) {
        super(textProvider, cfg, registrationManager, resourceManager);
        this.metadataValidator = metadataValidator;
        this.dataPackageSchemaManager = dataPackageSchemaManager;
        this.objectMapper = new ObjectMapper();
        this.metadataInferringService = metadataInferringService;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void prepare() {
        super.prepare();
        if (this.session.get("curr_user") == null) {
            return;
        }
        if (this.resource != null && "camtrap-dp".equals(this.resource.getCoreType())) {
            this.prepareCamtrap();
        } else {
            this.prepareFrictionless();
        }
    }

    private void prepareFrictionless() {
        FrictionlessMetadata metadata = (FrictionlessMetadata)this.resource.getDataPackageMetadata();
        if (this.isHttpPost()) {
            metadata.getContributors().clear();
            metadata.getLicenses().clear();
            metadata.getSources().clear();
        }
    }

    private void prepareCamtrap() {
        boolean mappingsChangedAfterLastTry;
        this.section = CamtrapMetadataSection.fromName((String)StringUtils.substringBetween((String)this.req.getRequestURI(), (String)"camtrap-metadata-", (String)"."));
        CamtrapMetadataSection camtrapMetadataSection = (CamtrapMetadataSection)this.section;
        CamtrapMetadata metadata = (CamtrapMetadata)this.resource.getDataPackageMetadata();
        DataPackageSchema dataPackageSchema = this.dataPackageSchemaManager.get("camtrap-dp");
        if (dataPackageSchema != null) {
            metadata.setProfile(dataPackageSchema.getProfile());
        }
        if (camtrapMetadataSection == null) {
            return;
        }
        boolean reinferMetadata = Boolean.parseBoolean(StringUtils.trimToNull((String)this.req.getParameter("reinferMetadata")));
        boolean bl = mappingsChangedAfterLastTry = this.resource.getInferredMetadata() != null && this.resource.getInferredMetadata().getLastModified() != null && this.resource.getMappingsModified() != null && this.resource.getMappingsModified().after(this.resource.getInferredMetadata().getLastModified());
        if (reinferMetadata || this.resource.getInferredMetadata() == null || mappingsChangedAfterLastTry) {
            InferredMetadata inferredMetadataRaw = this.metadataInferringService.inferMetadata(this.resource);
            if (inferredMetadataRaw instanceof InferredCamtrapMetadata) {
                this.inferredMetadata = inferredMetadataRaw;
            } else {
                LOG.error("Wrong type of the inferred metadata class, expected {} got {}", (Object)InferredCamtrapMetadata.class.getSimpleName(), (Object)inferredMetadataRaw.getClass().getSimpleName());
                this.inferredMetadata = new InferredCamtrapMetadata();
            }
            this.resource.setInferredMetadata(this.inferredMetadata);
            this.resourceManager.saveInferredMetadata(this.resource);
        } else if (this.resource.getInferredMetadata() instanceof InferredCamtrapMetadata) {
            this.inferredMetadata = this.resource.getInferredMetadata();
        } else {
            LOG.error("Wrong type of the stored inferred metadata class, expected {} got {}", (Object)InferredCamtrapMetadata.class.getSimpleName(), (Object)this.resource.getInferredMetadata().getClass().getSimpleName());
            this.inferredMetadata = new InferredCamtrapMetadata();
        }
        switch (1.$SwitchMap$org$gbif$ipt$model$voc$CamtrapMetadataSection[camtrapMetadataSection.ordinal()]) {
            case 1: {
                Organisation organisation;
                if (!this.isHttpPost()) break;
                metadata.getContributors().clear();
                metadata.getLicenses().clear();
                metadata.getSources().clear();
                String id = this.getId();
                Organisation organisation2 = organisation = id == null ? null : this.registrationManager.get(id);
                if (organisation == null || this.resource.isAlreadyAssignedDoi() || this.resource.isRegistered()) break;
                this.resource.setOrganisation(organisation);
                break;
            }
            case 2: {
                InferredCamtrapGeographicScope inferredGeographicScope = ((InferredCamtrapMetadata)this.inferredMetadata).getInferredGeographicScope();
                if (!reinferMetadata || inferredGeographicScope == null || inferredGeographicScope.getErrors().isEmpty()) break;
                for (String errorMessage : inferredGeographicScope.getErrors()) {
                    this.addActionError(this.getText(errorMessage));
                }
                break;
            }
            case 3: {
                InferredCamtrapTaxonomicScope inferredTaxonomicScope = ((InferredCamtrapMetadata)this.inferredMetadata).getInferredTaxonomicScope();
                if (!reinferMetadata || inferredTaxonomicScope == null || inferredTaxonomicScope.getErrors().isEmpty()) break;
                for (String errorMessage : inferredTaxonomicScope.getErrors()) {
                    this.addActionError(this.getText(errorMessage));
                }
                break;
            }
            case 4: {
                InferredCamtrapTemporalScope inferredTemporalScope = ((InferredCamtrapMetadata)this.inferredMetadata).getInferredTemporalScope();
                if (!reinferMetadata || inferredTemporalScope == null || inferredTemporalScope.getErrors().isEmpty()) break;
                for (String errorMessage : inferredTemporalScope.getErrors()) {
                    this.addActionError(this.getText(errorMessage));
                }
                break;
            }
            case 5: {
                if (!this.isHttpPost()) break;
                metadata.getKeywords().clear();
                break;
            }
            case 6: {
                if (!this.isHttpPost() || metadata.getProject() == null) break;
                metadata.getProject().getCaptureMethod().clear();
                break;
            }
            case 7: {
                if (!this.isHttpPost()) break;
                metadata.getReferences().clear();
                metadata.getRelatedIdentifiers().clear();
                break;
            }
        }
    }

    public String save() throws Exception {
        boolean isCamtrap = this.resource.getDataPackageMetadata() instanceof CamtrapMetadata;
        if (isCamtrap) {
            this.preProcessCamtrapMetadata();
        }
        if (this.metadataValidator.isSectionValid((BaseAction)this, this.resource, this.section)) {
            this.resourceManager.saveDatapackageMetadata(this.resource);
            this.resource.setMetadataModified(new Date());
            this.addActionMessage(this.getText("manage.success", new String[]{this.getText("submenu.datapackagemetadata." + (isCamtrap ? "camtrap." : "") + this.section.getName())}));
            this.resourceManager.save(this.resource);
            if (this.section instanceof CamtrapMetadataSection) {
                this.nextSectionCamtrap();
            }
        } else {
            return "input";
        }
        return "success";
    }

    private void preProcessCamtrapMetadata() {
        if (this.section == CamtrapMetadataSection.GEOGRAPHIC_SECTION) {
            this.convertCamtrapGeographicMetadata();
        } else if (this.section == CamtrapMetadataSection.TAXONOMIC_SECTION) {
            this.convertCamtrapTaxonomicMetadata();
        } else if (this.section == CamtrapMetadataSection.TEMPORAL_SECTION) {
            this.convertCamtrapTemporalMetadata();
        }
    }

    private void convertCamtrapGeographicMetadata() {
        InferredCamtrapMetadata inferredCamtrapMetadata;
        CamtrapMetadata camtrapMetadata = (CamtrapMetadata)this.resource.getDataPackageMetadata();
        if (!this.resource.isInferGeocoverageAutomatically()) {
            if (StringUtils.isNotEmpty((CharSequence)this.customGeoJson)) {
                try {
                    Geojson geojson = (Geojson)this.objectMapper.readValue(this.customGeoJson, Geojson.class);
                    camtrapMetadata.setSpatial(geojson);
                    camtrapMetadata.setCoordinatePrecision(null);
                }
                catch (JsonProcessingException e) {
                    this.addActionError(this.getText("datapackagemetadata.geographic.error.customGeojson"));
                    LOG.error("Error processing custom GeoJSON object", (Throwable)e);
                }
            }
        } else if (this.inferredMetadata instanceof InferredCamtrapMetadata && (inferredCamtrapMetadata = (InferredCamtrapMetadata)this.inferredMetadata).getInferredGeographicScope() != null) {
            if (inferredCamtrapMetadata.getInferredGeographicScope().isInferred() && inferredCamtrapMetadata.getInferredGeographicScope().getErrors().isEmpty()) {
                Geojson geojson = new Geojson();
                geojson.setType(Geojson.Type.POLYGON);
                ArrayList<List<List>> coordinates = new ArrayList<List<List>>();
                InferredCamtrapGeographicScope inferredScope = inferredCamtrapMetadata.getInferredGeographicScope();
                coordinates.add(Arrays.asList(Arrays.asList(inferredScope.getMinLongitude(), inferredScope.getMinLatitude()), Arrays.asList(inferredScope.getMaxLongitude(), inferredScope.getMinLatitude()), Arrays.asList(inferredScope.getMaxLongitude(), inferredScope.getMaxLatitude()), Arrays.asList(inferredScope.getMinLongitude(), inferredScope.getMaxLatitude()), Arrays.asList(inferredScope.getMinLongitude(), inferredScope.getMinLatitude())));
                geojson.setCoordinates(coordinates);
                camtrapMetadata.setSpatial(geojson);
                camtrapMetadata.setCoordinatePrecision(null);
            } else {
                for (String error : inferredCamtrapMetadata.getInferredGeographicScope().getErrors()) {
                    this.addActionError(this.getText(error));
                }
            }
        }
    }

    private void convertCamtrapTaxonomicMetadata() {
        InferredCamtrapMetadata inferredCamtrapMetadata;
        CamtrapMetadata camtrapMetadata = (CamtrapMetadata)this.resource.getDataPackageMetadata();
        if (this.resource.isInferTaxonomicCoverageAutomatically() && this.inferredMetadata instanceof InferredCamtrapMetadata && (inferredCamtrapMetadata = (InferredCamtrapMetadata)this.inferredMetadata).getInferredTaxonomicScope() != null && inferredCamtrapMetadata.getInferredTaxonomicScope().isInferred() && inferredCamtrapMetadata.getInferredTaxonomicScope().getErrors().isEmpty()) {
            InferredCamtrapTaxonomicScope inferredTaxonomicScope = inferredCamtrapMetadata.getInferredTaxonomicScope();
            camtrapMetadata.setTaxonomic(inferredTaxonomicScope.getData());
        }
    }

    private void convertCamtrapTemporalMetadata() {
        InferredCamtrapMetadata inferredCamtrapMetadata;
        CamtrapMetadata camtrapMetadata = (CamtrapMetadata)this.resource.getDataPackageMetadata();
        if (this.resource.isInferTemporalCoverageAutomatically() && this.inferredMetadata instanceof InferredCamtrapMetadata && (inferredCamtrapMetadata = (InferredCamtrapMetadata)this.inferredMetadata).getInferredTemporalScope() != null && inferredCamtrapMetadata.getInferredTemporalScope().isInferred() && inferredCamtrapMetadata.getInferredTemporalScope().getErrors().isEmpty()) {
            InferredCamtrapTemporalScope inferredTemporalScope = inferredCamtrapMetadata.getInferredTemporalScope();
            Temporal temporal = new Temporal();
            temporal.setStart(ResourceManagerImpl.CAMTRAP_TEMPORAL_METADATA_DATE_FORMAT.format(inferredTemporalScope.getStartDate()));
            temporal.setEnd(ResourceManagerImpl.CAMTRAP_TEMPORAL_METADATA_DATE_FORMAT.format(inferredTemporalScope.getEndDate()));
            camtrapMetadata.setTemporal(temporal);
        }
    }

    private void nextSectionCamtrap() {
        CamtrapMetadataSection camtrapMetadataSection = (CamtrapMetadataSection)this.section;
        switch (1.$SwitchMap$org$gbif$ipt$model$voc$CamtrapMetadataSection[camtrapMetadataSection.ordinal()]) {
            case 1: {
                this.next = CamtrapMetadataSection.GEOGRAPHIC_SECTION;
                break;
            }
            case 2: {
                this.next = CamtrapMetadataSection.TAXONOMIC_SECTION;
                break;
            }
            case 3: {
                this.next = CamtrapMetadataSection.TEMPORAL_SECTION;
                break;
            }
            case 4: {
                this.next = CamtrapMetadataSection.KEYWORDS_SECTION;
                break;
            }
            case 5: {
                this.next = CamtrapMetadataSection.PROJECT_SECTION;
                break;
            }
            case 6: {
                this.next = CamtrapMetadataSection.CITATION_SECTION;
                break;
            }
            case 8: {
                this.next = CamtrapMetadataSection.OTHER_SECTION;
                break;
            }
            case 7: {
                this.next = CamtrapMetadataSection.BASIC_SECTION;
                break;
            }
        }
    }

    public String getNext() {
        return this.next.getName();
    }

    public String getSection() {
        return this.section.getName();
    }

    public DataPackageMetadata getMetadata() {
        return this.resource.getDataPackageMetadata();
    }

    public Map<String, String> getLicenseScopes() {
        return CamtrapLicense.Scope.VOCABULARY;
    }

    public Map<String, String> getGbifSupportedLicenseNames() {
        return GBIF_SUPPORTED_LICENSES_VOCABULARY;
    }

    public Map<String, String> getOpenDefinitionLicenseNames() {
        return OPEN_DEFINITION_LICENSES_VOCABULARY;
    }

    public Map<String, String> getContributorRoles() {
        return CamtrapContributor.Role.VOCABULARY;
    }

    public Map<String, String> getTaxonRanks() {
        return Taxonomic.TaxonRank.VOCABULARY;
    }

    public Map<String, String> getSamplingDesigns() {
        return Project.SamplingDesign.VOCABULARY;
    }

    public Map<String, String> getCaptureMethods() {
        return CaptureMethod.VOCABULARY;
    }

    public Map<String, String> getObservationLevels() {
        return ObservationLevel.VOCABULARY;
    }

    public Map<String, String> getRelationTypes() {
        return RelatedIdentifier.RelationType.VOCABULARY;
    }

    public Map<String, String> getResourceTypeGenerals() {
        return RelatedIdentifier.ResourceTypeGeneral.VOCABULARY;
    }

    public Map<String, String> getRelatedIdentifierTypes() {
        return RelatedIdentifier.RelatedIdentifierType.VOCABULARY;
    }

    public Map<String, String> getOrganisations() {
        return this.organisations;
    }

    public InferredMetadata getInferredMetadata() {
        return this.inferredMetadata;
    }

    public void setCustomGeoJson(String customGeoJson) {
        this.customGeoJson = customGeoJson;
    }

    public String getCustomGeoJson() {
        return this.customGeoJson;
    }

    static {
        GBIF_SUPPORTED_LICENSES_VOCABULARY.put("CC0-1.0", "CC0-1.0");
        GBIF_SUPPORTED_LICENSES_VOCABULARY.put("CC-BY-4.0", "CC-BY-4.0");
        GBIF_SUPPORTED_LICENSES_VOCABULARY.put("CC-BY-NC-4.0", "CC-BY-NC-4.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("AAL", "AAL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("AFL-3.0", "AFL-3.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("AGPL-3.0", "AGPL-3.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("APL-1.0", "APL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("APSL-2.0", "APSL-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Against-DRM", "Against-DRM");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Apache-1.1", "Apache-1.1");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Apache-2.0", "Apache-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Artistic-2.0", "Artistic-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("BSD-2-Clause", "BSD-2-Clause");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("BSD-3-Clause", "BSD-3-Clause");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("BSL-1.0", "BSL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("BitTorrent-1.1", "BitTorrent-1.1");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CATOSL-1.1", "CATOSL-1.1");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CC-BY-4.0", "CC-BY-4.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CC-BY-NC-4.0", "CC-BY-NC-4.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CC-BY-NC-ND-4.0", "CC-BY-NC-ND-4.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CC-BY-NC-SA-4.0", "CC-BY-NC-SA-4.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CC-BY-ND-4.0", "CC-BY-ND-4.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CC-BY-SA-4.0", "CC-BY-SA-4.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CC0-1.0", "CC0-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CDDL-1.0", "CDDL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CECILL-2.1", "CECILL-2.1");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CNRI-Python", "CNRI-Python");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CPAL-1.0", "CPAL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("CUA-OPL-1.0", "CUA-OPL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("DSL", "DSL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ECL-2.0", "ECL-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("EFL-2.0", "EFL-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("EPL-1.0", "EPL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("EPL-2.0", "EPL-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("EUDatagrid", "EUDatagrid");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("EUPL-1.1", "EUPL-1.1");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Entessa", "Entessa");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("FAL-1.3", "FAL-1.3");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Fair", "Fair");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Frameworx-1.0", "Frameworx-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("GFDL-1.3-no-cover-texts-no-invariant-sections", "GFDL-1.3-no-cover-texts-no-invariant-sections");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("GPL-2.0", "GPL-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("GPL-3.0", "GPL-3.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("HPND", "HPND");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("IPA", "IPA");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("IPL-1.0", "IPL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ISC", "ISC");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Intel", "Intel");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("LGPL-2.1", "LGPL-2.1");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("LGPL-3.0", "LGPL-3.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("LO-FR-2.0", "LO-FR-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("LPL-1.0", "LPL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("LPL-1.02", "LPL-1.02");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("LPPL-1.3c", "LPPL-1.3c");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("MIT", "MIT");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("MPL-1.0", "MPL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("MPL-1.1", "MPL-1.1");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("MPL-2.0", "MPL-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("MS-PL", "MS-PL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("MS-RL", "MS-RL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("MirOS", "MirOS");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Motosoto", "Motosoto");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Multics", "Multics");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("NASA-1.3", "NASA-1.3");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("NCSA", "NCSA");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("NGPL", "NGPL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("NPOSL-3.0", "NPOSL-3.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("NTP", "NTP");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Naumen", "Naumen");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Nokia", "Nokia");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("OCLC-2.0", "OCLC-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ODC-BY-1.0", "ODC-BY-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ODbL-1.0", "ODbL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("OFL-1.1", "OFL-1.1");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("OGL-Canada-2.0", "OGL-Canada-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("OGL-UK-1.0", "OGL-UK-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("OGL-UK-2.0", "OGL-UK-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("OGL-UK-3.0", "OGL-UK-3.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("OGTSL", "OGTSL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("OSL-3.0", "OSL-3.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("PDDL-1.0", "PDDL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("PHP-3.0", "PHP-3.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("PostgreSQL", "PostgreSQL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Python-2.0", "Python-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("QPL-1.0", "QPL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("RPL-1.5", "RPL-1.5");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("RPSL-1.0", "RPSL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("RSCPL", "RSCPL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("SISSL", "SISSL");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("SPL-1.0", "SPL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("SimPL-2.0", "SimPL-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Sleepycat", "Sleepycat");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Talis", "Talis");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Unlicense", "Unlicense");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("VSL-1.0", "VSL-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("W3C", "W3C");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("WXwindows", "WXwindows");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Watcom-1.0", "Watcom-1.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Xnet", "Xnet");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ZPL-2.0", "ZPL-2.0");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("Zlib", "Zlib");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("dli-model-use", "dli-model-use");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("geogratis", "geogratis");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("hesa-withrights", "hesa-withrights");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("localauth-withrights", "localauth-withrights");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("met-office-cp", "met-office-cp");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("mitre", "mitre");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("notspecified", "notspecified");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("other-at", "other-at");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("other-closed", "other-closed");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("other-nc", "other-nc");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("other-open", "other-open");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("other-pd", "other-pd");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ukclickusepsi", "ukclickusepsi");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ukcrown", "ukcrown");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ukcrown-withrights", "ukcrown-withrights");
        OPEN_DEFINITION_LICENSES_VOCABULARY.put("ukpsi", "ukpsi");
    }
}

