/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.model.IptColorScheme;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class UIManagementAction
extends POSTAction {
    private static final long serialVersionUID = 2001100185337026057L;
    private static final Logger LOG = LogManager.getLogger(UIManagementAction.class);
    private final DataDir dataDir;
    private IptColorScheme colorScheme;
    private File file;
    private String fileContentType;
    private boolean removeLogo;

    @Inject
    public UIManagementAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, DataDir dataDir) {
        super(textProvider, cfg, registrationManager);
        this.dataDir = dataDir;
    }

    public void prepare() {
        super.prepare();
        this.colorScheme = this.getCfg().getColorSchemeConfig();
    }

    public String save() {
        try {
            this.getCfg().saveColorSchemeConfig(this.colorScheme);
            if (this.removeLogo) {
                this.dataDir.removeLogoFile();
            }
        }
        catch (Exception e) {
            LOG.error("Exception while trying to change IPT UI settings", (Throwable)e);
            this.addActionError(this.getText("admin.uiManagement.error.failedToSafe"));
            return "input";
        }
        this.addActionMessage(this.getText("admin.uiManagement.success"));
        return "success";
    }

    public String uploadLogo() {
        if (this.file != null) {
            for (String suffix : Constants.IMAGE_TYPES) {
                FileUtils.deleteQuietly((File)this.dataDir.appLogoFile(suffix));
            }
            String type = "jpeg";
            if (this.fileContentType != null) {
                type = StringUtils.substringAfterLast((String)this.fileContentType, (String)"/");
            }
            File logoFile = this.dataDir.appLogoFile(type);
            try {
                FileUtils.copyFile((File)this.file, (File)logoFile);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
            }
        }
        return "input";
    }

    public IptColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(IptColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileContentType(String fileContentType) {
        this.fileContentType = fileContentType;
    }

    public boolean isRemoveLogo() {
        return this.removeLogo;
    }

    public void setRemoveLogo(boolean removeLogo) {
        this.removeLogo = removeLogo;
    }
}

