/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.struts2.json.annotations.JSON;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.task.StatusReport;

public class PublishingStatusApiAction
extends BaseAction {
    private final ResourceManager resourceManager;
    private Date publicationStartedDate;
    private String r;
    private String status;
    private StatusReport report;
    private Map<String, StatusReport> filteredReports;
    private List<String> resources;
    private long since;

    @Inject
    public PublishingStatusApiAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.resourceManager = resourceManager;
    }

    public String execute() {
        this.publicationStartedDate = new Date();
        Map allReports = this.resourceManager.getProcessReports();
        if (this.r != null) {
            this.report = (StatusReport)allReports.get(this.r);
            this.filteredReports = null;
        } else {
            this.filteredReports = new HashMap();
            for (Map.Entry entry : allReports.entrySet()) {
                StatusReport sr = (StatusReport)entry.getValue();
                if (!this.shouldInclude(sr)) continue;
                this.filteredReports.put((String)entry.getKey(), sr);
            }
            this.report = null;
            if ("completed".equalsIgnoreCase(this.status)) {
                this.filteredReports = this.filteredReports.entrySet().stream().filter(e -> ((StatusReport)e.getValue()).isCompleted()).filter(e -> ((StatusReport)e.getValue()).getTimestamp() > this.since).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
        }
        this.resources = this.resourceManager.list().stream().map(Resource::getShortname).collect(Collectors.toList());
        return "success";
    }

    private boolean shouldInclude(StatusReport sr) {
        if ("running".equalsIgnoreCase(this.status)) {
            return sr != null && !sr.isCompleted();
        }
        if ("completed".equalsIgnoreCase(this.status)) {
            return sr != null && sr.isCompleted();
        }
        return true;
    }

    @JSON
    public Map<String, StatusReport> getReports() {
        return this.filteredReports;
    }

    @JSON
    public List<String> getResources() {
        return this.resources;
    }

    @JSON
    public StatusReport getReport() {
        return this.report;
    }

    public void setR(String r) {
        this.r = r;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSince(long since) {
        this.since = since;
    }

    public Date getPublicationStartedDate() {
        return this.publicationStartedDate;
    }
}

