/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.task.StatusReport;

public class PublishingStatusAction
extends BaseAction {
    private static final long serialVersionUID = -3984381818825518246L;
    private final ResourceManager resourceManager;
    private Map<String, StatusReport> runningPublications = new HashMap();
    private Map<String, StatusReport> completedPublications = new HashMap();

    @Inject
    public PublishingStatusAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.resourceManager = resourceManager;
    }

    public String execute() {
        Map allReports = this.resourceManager.getProcessReports();
        this.completedPublications = allReports.entrySet().stream().filter(entry -> ((StatusReport)entry.getValue()).isCompleted()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.runningPublications = allReports.entrySet().stream().filter(entry -> !((StatusReport)entry.getValue()).isCompleted()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return "success";
    }

    public Map<String, StatusReport> getRunningPublications() {
        return this.runningPublications;
    }

    public Map<String, StatusReport> getCompletedPublications() {
        return this.completedPublications;
    }
}

