/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.gbif.api.model.common.DOI;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.voc.DOIRegistrationAgency;
import org.gbif.ipt.service.AlreadyExistingException;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.OrganisationSupport;

public class OrganisationsAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(OrganisationsAction.class);
    private static final long serialVersionUID = 7297470324204084809L;
    private static final String SESSION_ORGANISATIONS_KEY = "organisations";
    private static final String SESSION_ORGANISATIONS_LAST_UPDATED_KEY = "organisations.lastUpdated";
    private RegistryManager registryManager;
    private ResourceManager resourceManager;
    private final OrganisationSupport organisationValidation;
    private Organisation organisation;
    private List<Organisation> organisations = new ArrayList();
    private List<Organisation> linkedOrganisations;
    private Boolean synchronise = false;
    private boolean organisationWithDoiRegistrationAgencyPresent = false;
    private static final Map<String, DOIRegistrationAgency> DOI_REGISTRATION_AGENCIES = new HashMap();

    @Inject
    public OrganisationsAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, OrganisationSupport organisationValidation, ResourceManager resourceManager, RegistryManager registryManager) {
        super(textProvider, cfg, registrationManager);
        this.organisationValidation = organisationValidation;
        this.resourceManager = resourceManager;
        this.registryManager = registryManager;
    }

    private void loadOrganisations() {
        HttpSession session = ServletActionContext.getRequest().getSession();
        List sessionOrganisations = (List)session.getAttribute(SESSION_ORGANISATIONS_KEY);
        if (sessionOrganisations == null) {
            LOG.debug("Fetching list of organisations from registry");
            try {
                this.organisations = this.registryManager.getOrganisations();
                LOG.debug("Organisations returned from the Registry: {}", (Object)this.organisations.size());
                Organisation o = new Organisation();
                o.setName("");
                this.organisations.add(0, o);
                session.setAttribute(SESSION_ORGANISATIONS_KEY, (Object)this.organisations);
                session.setAttribute(SESSION_ORGANISATIONS_LAST_UPDATED_KEY, (Object)new Date());
            }
            catch (RegistryException e) {
                LOG.error("Failed to load organisations", (Throwable)e);
                this.addActionError("Failed to load organisations");
                this.organisations = new ArrayList();
            }
        } else {
            this.organisations = sessionOrganisations;
        }
    }

    private void clearCache() {
        this.organisations = new ArrayList();
    }

    public Map<String, DOIRegistrationAgency> getDoiRegistrationAgencies() {
        return DOI_REGISTRATION_AGENCIES;
    }

    public String delete() {
        try {
            List resources = this.resourceManager.list();
            Organisation removedOrganisation = this.registrationManager.delete(this.id, resources);
            if (removedOrganisation == null) {
                return "404";
            }
            this.clearCache();
            this.registrationManager.save();
            this.addActionMessage(this.getText("admin.organisation.deleted"));
            return "success";
        }
        catch (DeletionNotAllowedException e) {
            if (e.getReason().equals((Object)DeletionNotAllowedException.Reason.RESOURCE_REGISTERED_WITH_ORGANISATION)) {
                this.addActionError(this.getText("admin.organisation.deleted.cant.resources"));
            } else if (e.getReason().equals((Object)DeletionNotAllowedException.Reason.IPT_REGISTERED_WITH_ORGANISATION)) {
                this.addActionError(this.getText("admin.organisation.deleted.cant.ipt"));
            }
            this.addActionExceptionWarning((Exception)((Object)e));
        }
        catch (IOException e) {
            this.addActionError(this.getText("admin.organisation.cantSave") + ": " + e.getMessage());
        }
        return "input";
    }

    public List<Organisation> getLinkedOrganisations() {
        return this.linkedOrganisations;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public List<Organisation> getOrganisations() {
        this.loadOrganisations();
        ArrayList<Organisation> filteredOrganisations = new ArrayList<Organisation>(this.organisations);
        filteredOrganisations.removeAll(this.linkedOrganisations);
        return filteredOrganisations;
    }

    public String getRegistryURL() {
        return this.cfg.getRegistryUrl() + "/registry/";
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public String list() {
        return "success";
    }

    public void prepare() {
        super.prepare();
        try {
            this.loadOrganisations();
        }
        catch (RegistryException e) {
            String msg = this.getText("admin.registration.error.registry");
            LOG.error(msg, (Throwable)e);
            this.addActionError(msg);
        }
        this.linkedOrganisations = this.registrationManager.listAll();
        this.linkedOrganisations.removeIf(entry -> entry.getKey().equals(Constants.DEFAULT_ORG_KEY));
        for (Organisation org : this.linkedOrganisations) {
            if (!org.isAgencyAccountPrimary()) continue;
            this.organisationWithDoiRegistrationAgencyPresent = true;
            break;
        }
        if (this.id == null) {
            this.organisation = new Organisation();
        } else if (!this.isHttpPost()) {
            Organisation fromDisk = this.registrationManager.getFromDisk(this.id);
            if (fromDisk != null) {
                this.organisation = new Organisation(fromDisk);
            } else {
                this.notFound = true;
            }
        }
    }

    public String save() {
        try {
            if (this.id == null) {
                if (this.registrationManager.get(this.organisation.getKey()) != null) {
                    LOG.error("The organisation association already exists");
                    this.addActionError(this.getText("admin.organisation.error.existing"));
                    return "input";
                }
                this.registrationManager.addAssociatedOrganisation(this.organisation);
                this.resourceManager.updateOrganisationNameForResources(this.organisation);
                this.addActionMessage(this.getText("admin.organisation.associated.ipt"));
            } else {
                this.registrationManager.addAssociatedOrganisation(this.organisation);
                this.resourceManager.updateOrganisationNameForResources(this.organisation);
                this.addActionMessage(this.getText("admin.organisation.updated.ipt"));
            }
            this.registrationManager.save();
            return "success";
        }
        catch (IOException e) {
            LOG.error("The organisation association couldn't be saved: " + e.getMessage(), (Throwable)e);
            this.addActionError(this.getText("admin.organisation.error.save"));
            this.addActionError(e.getMessage());
            return "input";
        }
        catch (AlreadyExistingException e) {
            this.addActionError(this.getText("admin.organisation.exists", new String[]{this.id}));
            return "input";
        }
    }

    public String synchronize() {
        try {
            this.registrationManager.updateAssociatedOrganisationsMetadata();
            this.addActionMessage(this.getText("admin.organisations.synchronized"));
        }
        catch (IOException e) {
            LOG.error("Failed to synchronize organizations with the registry", (Throwable)e);
            this.addActionError(this.getText("admin.organisation.error.save"));
        }
        return "success";
    }

    public void setLinkedOrganisations(List<Organisation> linkedOrganisations) {
        this.linkedOrganisations = linkedOrganisations;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void validate() {
        if (this.isHttpPost() && !this.cancel && !this.delete & this.synchronise == false) {
            boolean validated = true;
            if (this.organisation.isAgencyAccountPrimary()) {
                for (Organisation org : this.linkedOrganisations) {
                    if (this.organisation.getKey().equals(org.getKey()) || !org.isAgencyAccountPrimary()) continue;
                    validated = false;
                    this.addFieldError("organisation.agencyAccountPrimary", this.getText("admin.organisation.doiAccount.activated.exists"));
                    break;
                }
            }
            if (!this.organisationValidation.validate((BaseAction)this, this.organisation)) {
                validated = false;
            } else if (this.organisation.isAgencyAccountPrimary() && this.isAnotherAccountInUseAlready(this.organisation)) {
                validated = false;
            }
            if (!validated) {
                this.organisation.setAgencyAccountPrimary(false);
            }
        }
    }

    protected boolean isAnotherAccountInUseAlready(Organisation organisation) {
        for (Resource resource : this.resourceManager.list()) {
            DOI doi = resource.getDoi();
            Organisation fromDisk = this.registrationManager.getFromDisk(organisation.getKey().toString());
            if (doi == null || fromDisk == null || organisation.getDoiRegistrationAgency() == null || fromDisk.getDoiRegistrationAgency() == null || organisation.getDoiRegistrationAgency().equals((Object)fromDisk.getDoiRegistrationAgency())) continue;
            String msg = this.getText("admin.organisation.doiAccount.differentTypeInUse", new String[]{fromDisk.getDoiRegistrationAgency().toString().toLowerCase(), doi.toString()});
            LOG.error(msg);
            this.addActionError(msg);
            return true;
        }
        return false;
    }

    public String getPortalUrl() {
        return this.cfg.getPortalUrl();
    }

    public void setSynchronise(String synchronise) {
        this.synchronise = StringUtils.trimToNull((String)synchronise) != null;
    }

    public boolean isOrganisationWithDoiRegistrationAgencyPresent() {
        return this.organisationWithDoiRegistrationAgencyPresent;
    }

    static {
        DOI_REGISTRATION_AGENCIES.put(DOIRegistrationAgency.DATACITE.name(), DOIRegistrationAgency.DATACITE);
    }
}

