/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.DataDir;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class LogsAction
extends BaseAction {
    private static final long serialVersionUID = -5038153790552063249L;
    private static final Logger LOG = LogManager.getLogger(LogsAction.class);
    private final DataDir dataDir;
    private InputStream inputStream;
    private String log;

    @Inject
    public LogsAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, DataDir dataDir) {
        super(textProvider, cfg, registrationManager);
        this.dataDir = dataDir;
    }

    public String execute() {
        return "success";
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getLog() {
        return this.log;
    }

    public String logfile() throws IOException {
        File logFile = this.dataDir.loggingFile(this.log + ".log");
        if (logFile.exists() && this.dataDir.loggingDir().equals(logFile.getParentFile())) {
            LOG.debug("Serving logfile " + logFile.getAbsolutePath());
            this.inputStream = new FileInputStream(logFile);
            return "success";
        }
        return "404";
    }

    public void setLog(String log) {
        this.log = log;
    }
}

