/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action.admin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.ConfigWarnings;
import org.gbif.ipt.model.DataPackageSchema;
import org.gbif.ipt.model.Resource;
import org.gbif.ipt.model.datapackage.metadata.camtrap.CamtrapMetadata;
import org.gbif.ipt.service.DeletionNotAllowedException;
import org.gbif.ipt.service.RegistryException;
import org.gbif.ipt.service.admin.DataPackageSchemaManager;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.manage.ResourceManager;
import org.gbif.ipt.service.registry.RegistryManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class DataPackageSchemaAction
extends POSTAction {
    private static final long serialVersionUID = -535308367714585780L;
    private static final Logger LOG = LogManager.getLogger(DataPackageSchemaAction.class);
    private final DataPackageSchemaManager schemaManager;
    private final RegistryManager registryManager;
    private final ConfigWarnings configWarnings;
    private List<DataPackageSchema> latestDataSchemasVersions;
    private List<DataPackageSchema> schemas;
    private List<DataPackageSchema> newSchemas;
    private String schemaName;
    private DataPackageSchema dataPackageSchema;
    private String dataPackageSchemaRawData;
    private ResourceManager resourceManager;
    private boolean upToDate = true;
    private boolean iptReinstallationRequired = false;

    @Inject
    public DataPackageSchemaAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, DataPackageSchemaManager schemaManager, RegistryManager registryManager, ConfigWarnings configWarnings, ResourceManager resourceManager) {
        super(textProvider, cfg, registrationManager);
        this.schemaManager = schemaManager;
        this.registryManager = registryManager;
        this.configWarnings = configWarnings;
        this.resourceManager = resourceManager;
    }

    public String delete() throws Exception {
        try {
            for (Resource r : this.resourceManager.list()) {
                if (r.getDataPackageIdentifier() == null || !r.getDataPackageIdentifier().equals(this.id) || r.getDataPackageMappings().isEmpty()) continue;
                LOG.warn("Schema mapped in resource {}", (Object)r.getShortname());
                String msg = this.getText("admin.dataPackages.delete.error.mapped", new String[]{r.getShortname()});
                throw new DeletionNotAllowedException(DeletionNotAllowedException.Reason.DATA_SCHEMA_MAPPED, msg);
            }
            this.schemaManager.uninstallSafely(this.id, this.schemaName);
            this.addActionMessage(this.getText("admin.dataPackages.delete.success", new String[]{this.id}));
        }
        catch (DeletionNotAllowedException e) {
            this.addActionWarning(this.getText("admin.dataPackages.delete.error", new String[]{this.id}));
            this.addActionExceptionWarning((Exception)((Object)e));
        }
        return "success";
    }

    public String update() throws Exception {
        try {
            LOG.info("Updating data schema {} to the latest version...", (Object)this.id);
            DataPackageSchema latestCompatibleSchema = this.schemaManager.update(this.id);
            if (latestCompatibleSchema != null) {
                this.updateResourcesAfterSchemaUpdate(latestCompatibleSchema);
            }
            this.addActionMessage(this.getText("admin.dataPackages.update.success", new String[]{this.id}));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            this.addActionWarning(this.getText("admin.dataPackages.update.error", new String[]{e.getMessage()}), e);
        }
        return "success";
    }

    private void updateResourcesAfterSchemaUpdate(DataPackageSchema newlyInstalledSchema) {
        this.resourceManager.list().stream().filter(Resource::isDataPackage).forEach(res -> this.updateResourceAfterSchemaUpdate(res, newlyInstalledSchema));
    }

    private void updateResourceAfterSchemaUpdate(Resource resource, DataPackageSchema newlyInstalledSchema) {
        if ("camtrap-dp".equals(resource.getCoreType()) && resource.getDataPackageMetadata() instanceof CamtrapMetadata) {
            CamtrapMetadata metadata = (CamtrapMetadata)resource.getDataPackageMetadata();
            metadata.setProfile(newlyInstalledSchema.getProfile());
        }
        resource.getDataPackageMappings().forEach(m -> m.setDataPackageSchema(newlyInstalledSchema));
    }

    public String list() {
        this.schemas = this.schemaManager.list();
        this.updateComputableFields(this.schemas);
        this.newSchemas = this.getLatestDataSchemasVersions();
        List installedSchemasIdentifiers = this.schemas.stream().map(DataPackageSchema::getIdentifier).collect(Collectors.toList());
        this.newSchemas.removeIf(ds -> installedSchemasIdentifiers.contains(ds.getIdentifier()));
        return "success";
    }

    public String save() {
        try {
            Optional<DataPackageSchema> wrappedSchema = this.latestDataSchemasVersions.stream().filter(ds -> ds.getIdentifier().equals(this.id)).findFirst();
            if (wrappedSchema.isPresent()) {
                this.schemaManager.install(wrappedSchema.get());
            } else {
                this.addActionWarning(this.getText("admin.dataPackages.install.error", new String[]{this.id}));
            }
            this.addActionMessage(this.getText("admin.dataPackages.install.success", new String[]{this.id}));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            this.addActionWarning(this.getText("admin.dataPackages.install.error", new String[]{this.id}), e);
        }
        return "success";
    }

    public void prepare() {
        super.prepare();
        this.loadLatestDataSchemasVersions();
        if (this.id != null) {
            this.dataPackageSchema = this.schemaManager.get(this.id);
            this.dataPackageSchemaRawData = this.schemaManager.getRawData(this.dataPackageSchema.getName());
        }
    }

    private void loadLatestDataSchemasVersions() {
        try {
            List all = this.registryManager.getLatestDataPackageSchemas();
            if (!all.isEmpty()) {
                this.setLatestDataSchemasVersions(this.getLatestVersions(all));
            }
        }
        catch (RegistryException e) {
            String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
            this.configWarnings.addStartupError(msg);
            LOG.error(msg);
            msg = this.getText("admin.dataPackages.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.configWarnings.addStartupError(msg);
            LOG.error(msg);
        }
        finally {
            if (this.getLatestDataSchemasVersions() == null) {
                this.setLatestDataSchemasVersions(new ArrayList());
            }
        }
    }

    protected List<DataPackageSchema> getLatestVersions(List<DataPackageSchema> dataPackageSchemas) {
        List sorted = dataPackageSchemas.stream().sorted(Comparator.comparing(DataPackageSchema::getIssued, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
        HashMap<String, DataPackageSchema> dataPackageSchemasByIdentifier = new HashMap<String, DataPackageSchema>();
        if (!sorted.isEmpty()) {
            for (DataPackageSchema dataPackageSchema : sorted) {
                String identifier = dataPackageSchema.getIdentifier();
                if (identifier == null || dataPackageSchemasByIdentifier.containsKey(identifier)) continue;
                dataPackageSchemasByIdentifier.put(identifier, dataPackageSchema);
            }
        }
        return new ArrayList<DataPackageSchema>(dataPackageSchemasByIdentifier.values());
    }

    protected void updateComputableFields(List<DataPackageSchema> installedDataSchemas) {
        if (installedDataSchemas.isEmpty()) {
            return;
        }
        try {
            List registeredSchemas = this.registryManager.getLatestDataPackageSchemas();
            for (DataPackageSchema installedSchema : installedDataSchemas) {
                this.updateComputableFields(installedSchema, registeredSchemas);
            }
        }
        catch (RegistryException e) {
            String msg = RegistryException.logRegistryException((RegistryException)e, (BaseAction)this);
            this.configWarnings.addStartupError(msg);
            LOG.error(msg);
            msg = this.getText("admin.dataPackages.couldnt.load", new String[]{this.cfg.getRegistryUrl()});
            this.configWarnings.addStartupError(msg);
            LOG.error(msg);
        }
    }

    private void updateComputableFields(DataPackageSchema installedSchema, List<DataPackageSchema> registeredSchemas) {
        installedSchema.setLatest(true);
        for (DataPackageSchema registeredSchema : registeredSchemas) {
            if (!this.isLatest(registeredSchema) || !this.isSameIdentifier(installedSchema, registeredSchema)) continue;
            this.handleSchema(installedSchema, registeredSchema);
            break;
        }
    }

    private void handleSchema(DataPackageSchema installedSchema, DataPackageSchema latestSchema) {
        String latestCompatibleVersion = this.registryManager.getLatestCompatibleSchemaVersion(installedSchema.getName(), installedSchema.getVersion());
        String installedVersion = installedSchema.getVersion();
        String latestVersion = latestSchema.getVersion();
        Date installedSchemaIssuedDate = installedSchema.getIssued();
        Date latestSchemaIssuedDate = latestSchema.getIssued();
        if (installedVersion.equals(latestCompatibleVersion) && latestCompatibleVersion.equals(latestVersion) && installedSchemaIssuedDate != null && installedSchemaIssuedDate.equals(latestSchemaIssuedDate)) {
            LOG.debug("Installed data schema with identifier {} was issued {}. It's the latest available schema.", (Object)installedSchema.getIdentifier(), (Object)installedSchema.getIssued());
        } else if (installedVersion.equals(latestCompatibleVersion)) {
            this.handleCompatibleVersionMatchesInstalledButNotMatchLatest(installedSchema, latestCompatibleVersion);
        } else {
            this.handleCompatibleVersionNotMatchInstalled(installedSchema, latestCompatibleVersion);
        }
    }

    private void handleCompatibleVersionNotMatchInstalled(DataPackageSchema installedSchema, String latestCompatibleVersion) {
        this.upToDate = false;
        installedSchema.setLatest(false);
        installedSchema.setUpdatable(true);
        LOG.debug("Installed data schema with identifier {} was issued {}. A newer compatible version {} exists.", (Object)installedSchema.getIdentifier(), (Object)installedSchema.getIssued(), (Object)latestCompatibleVersion);
    }

    private void handleCompatibleVersionMatchesInstalledButNotMatchLatest(DataPackageSchema installedSchema, String latestCompatibleVersion) {
        DataPackageSchema latestCompatibleSchema = this.registryManager.getSchema(installedSchema.getName(), latestCompatibleVersion);
        Date latestCompatibleSchemaIssuedDate = latestCompatibleSchema.getIssued();
        this.upToDate = false;
        installedSchema.setLatest(false);
        if (latestCompatibleSchemaIssuedDate.after(installedSchema.getIssued())) {
            LOG.debug("Installed data schema with identifier {} was issued {}. A newer compatible schema with the same version but newer issued date exists.", (Object)installedSchema.getIdentifier(), (Object)installedSchema.getIssued());
            installedSchema.setUpdatable(true);
        } else {
            LOG.debug("Installed data schema with identifier {} was issued {}. Latest compatible version already installed. IPT update required", (Object)installedSchema.getIdentifier(), (Object)installedSchema.getIssued());
            this.iptReinstallationRequired = true;
        }
    }

    private boolean isSameIdentifier(DataPackageSchema first, DataPackageSchema second) {
        return first.getIdentifier().equalsIgnoreCase(second.getIdentifier());
    }

    private boolean isLatest(DataPackageSchema schema) {
        return schema.isLatest();
    }

    public void setLatestDataSchemasVersions(List<DataPackageSchema> latestDataSchemasVersions) {
        this.latestDataSchemasVersions = latestDataSchemasVersions;
    }

    public List<DataPackageSchema> getLatestDataSchemasVersions() {
        return this.latestDataSchemasVersions;
    }

    public List<DataPackageSchema> getSchemas() {
        return this.schemas;
    }

    public List<DataPackageSchema> getNewSchemas() {
        return this.newSchemas;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public DataPackageSchema getDataPackageSchema() {
        return this.dataPackageSchema;
    }

    public String getDataPackageSchemaRawData() {
        return this.dataPackageSchemaRawData;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setUpToDate(boolean upToDate) {
        this.upToDate = upToDate;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    public boolean isIptReinstallationRequired() {
        return this.iptReinstallationRequired;
    }
}

