/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.config.Constants;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.model.User;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.utils.XSSUtil;

public class BaseAction
extends ActionSupport
implements SessionAware,
Preparable,
ServletRequestAware,
ServletResponseAware {
    private static final Logger LOG = LogManager.getLogger(BaseAction.class);
    private static final long serialVersionUID = -2330991910834399442L;
    public static final String NOT_MODIFIED = "304";
    public static final String NOT_FOUND = "404";
    public static final String NOT_ALLOWED = "401";
    public static final String NOT_ALLOWED_MANAGER = "401-manager";
    public static final String LOGIN = "login";
    public static final String HOME = "home";
    public static final String LOCKED = "locked";
    public static final String GONE = "410";
    protected List<String> warnings = new ArrayList();
    protected Map<String, Object> session;
    protected HttpServletRequest req;
    protected HttpServletResponse response;
    public String id;
    protected boolean cancel = false;
    protected SimpleTextProvider textProvider;
    protected AppConfig cfg;
    protected RegistrationManager registrationManager;

    @Inject
    public BaseAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager) {
        this.textProvider = textProvider;
        this.cfg = cfg;
        this.registrationManager = registrationManager;
    }

    protected void addActionExceptionWarning(Exception e) {
        String msg = e.getMessage();
        if (msg != null) {
            this.warnings.add(msg);
        }
    }

    public void addActionWarning(String anErrorMessage) {
        if (!this.warnings.contains(anErrorMessage)) {
            this.warnings.add(anErrorMessage);
        }
    }

    public void addActionWarning(String anErrorMessage, Exception e) {
        this.warnings.add(anErrorMessage);
        this.addActionExceptionWarning(e);
    }

    public List<String> getActionWarnings() {
        return this.warnings;
    }

    public String getBase() {
        return this.getBaseURL();
    }

    public String getBaseURL() {
        return this.cfg.getBaseUrl();
    }

    public String getLogoRedirectURL() {
        return Optional.ofNullable(this.cfg.getLogoRedirectUrl()).orElse(this.cfg.getBaseUrl());
    }

    public String getPrimaryColor() {
        String primaryColorHex = this.cfg.getColorSchemeConfig().getPrimaryColor();
        return Integer.valueOf(primaryColorHex.substring(1, 3), 16) + "," + Integer.valueOf(primaryColorHex.substring(3, 5), 16) + "," + Integer.valueOf(primaryColorHex.substring(5, 7), 16);
    }

    public String getNavbarColor() {
        String navbarColorHex = this.cfg.getColorSchemeConfig().getNavbarColor();
        return Integer.valueOf(navbarColorHex.substring(1, 3), 16) + "," + Integer.valueOf(navbarColorHex.substring(3, 5), 16) + "," + Integer.valueOf(navbarColorHex.substring(5, 7), 16);
    }

    public String getNavbarLinkColor() {
        String navbarLinkColorHex = this.cfg.getColorSchemeConfig().getNavbarLinkColor();
        return Integer.valueOf(navbarLinkColorHex.substring(1, 3), 16) + "," + Integer.valueOf(navbarLinkColorHex.substring(3, 5), 16) + "," + Integer.valueOf(navbarLinkColorHex.substring(5, 7), 16);
    }

    public String getNavbarGbifLogoColor() {
        String navbarGbifLogoColorHex = this.cfg.getColorSchemeConfig().getNavbarGbifLogoColor();
        return Integer.valueOf(navbarGbifLogoColorHex.substring(1, 3), 16) + "," + Integer.valueOf(navbarGbifLogoColorHex.substring(3, 5), 16) + "," + Integer.valueOf(navbarGbifLogoColorHex.substring(5, 7), 16);
    }

    public String getNavbarActiveTabColor() {
        String navbarActiveTabColorHex = this.cfg.getColorSchemeConfig().getNavbarActiveTabColor();
        return Integer.valueOf(navbarActiveTabColorHex.substring(1, 3), 16) + "," + Integer.valueOf(navbarActiveTabColorHex.substring(3, 5), 16) + "," + Integer.valueOf(navbarActiveTabColorHex.substring(5, 7), 16);
    }

    public String getLinkColor() {
        String linkColorHex = this.cfg.getColorSchemeConfig().getLinkColor();
        return Integer.valueOf(linkColorHex.substring(1, 3), 16) + "," + Integer.valueOf(linkColorHex.substring(3, 5), 16) + "," + Integer.valueOf(linkColorHex.substring(5, 7), 16);
    }

    public String getRequestURL() {
        try {
            return UriBuilder.fromUri((String)this.getBaseURL()).path(StringUtils.trimToEmpty((String)this.req.getServletPath())).path(StringUtils.trimToEmpty((String)this.req.getPathInfo())).replaceQuery(this.req.getQueryString()).replaceQueryParam("request_locale", new Object[0]).build(new Object[0]).toString();
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to reconstruct requestURL from {}. Error: {}", (Object)this.req.getRequestURL(), (Object)e.getMessage());
            return this.getBaseURL();
        }
    }

    public AppConfig getCfg() {
        return this.cfg;
    }

    public User getCurrentUser() {
        User u = null;
        try {
            u = (User)this.session.get("curr_user");
        }
        catch (Exception e) {
            LOG.debug("A problem occurred retrieving current user. This can happen if the session is not yet opened");
        }
        return u;
    }

    public String getId() {
        return this.id;
    }

    public String getLocaleLanguage() {
        String requestedLocale;
        if (this.getLocale() != null && (requestedLocale = StringUtils.trimToNull((String)this.getLocale().getLanguage())) != null && !XSSUtil.containsXSS((String)requestedLocale)) {
            ResourceBundle resourceBundle = this.textProvider.getTexts(new Locale(requestedLocale));
            return resourceBundle.getLocale().getLanguage();
        }
        return Locale.ENGLISH.getLanguage();
    }

    public Locale getLocale() {
        return ActionContext.getContext() != null ? super.getLocale() : null;
    }

    public String getText(String key) {
        return this.textProvider.getText((LocaleProvider)this, key, null, (Object[])new String[0]);
    }

    public String getText(String key, List<?> args) {
        return this.textProvider.getText((LocaleProvider)this, key, null, args);
    }

    public String getText(String key, String defaultValue) {
        return this.textProvider.getText((LocaleProvider)this, key, defaultValue, (Object[])new String[0]);
    }

    public String getText(String key, String defaultValue, List<?> args) {
        return this.textProvider.getText((LocaleProvider)this, key, defaultValue, args);
    }

    public String getText(String key, String defaultValue, List<?> args, ValueStack stack) {
        return this.textProvider.getText((LocaleProvider)this, key, defaultValue, args);
    }

    public String getText(String key, String defaultValue, String obj) {
        return this.textProvider.getText((LocaleProvider)this, key, defaultValue, (Object[])new String[0]);
    }

    public String getText(String key, String defaultValue, String[] args) {
        return this.textProvider.getText((LocaleProvider)this, key, defaultValue, (Object[])args);
    }

    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        return this.textProvider.getText((LocaleProvider)this, key, defaultValue, (Object[])args);
    }

    public String getText(String key, String[] args) {
        return this.textProvider.getText((LocaleProvider)this, key, null, (Object[])args);
    }

    public ResourceBundle getTexts() {
        return this.textProvider.getTexts(this.getLocale());
    }

    public ResourceBundle getTexts(String bundleName) {
        return this.textProvider.getTexts(bundleName, this.getLocale());
    }

    public String getTextWithDynamicArgs(String key, String ... args) {
        return this.textProvider.getText((LocaleProvider)this, key, null, (Object[])args);
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean isAdminRights() {
        User user = this.getCurrentUser();
        return user != null && user.hasAdminRights();
    }

    protected boolean isHttpPost() {
        return this.req != null && this.req.getMethod().equalsIgnoreCase("post");
    }

    public boolean isLoggedIn() {
        return this.getCurrentUser() != null;
    }

    public boolean isManagerRights() {
        User user = this.getCurrentUser();
        return user != null && user.hasManagerRights();
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies;
        if (this.req != null && (cookies = this.req.getCookies()) != null) {
            for (Cookie c : this.req.getCookies()) {
                if (!name.equals(c.getName())) continue;
                return c;
            }
        }
        return null;
    }

    public Optional<String> getRequestParameter(HttpServletRequest request, String paramName) {
        return Optional.ofNullable(request.getParameter(paramName));
    }

    public void prepare() {
        this.id = StringUtils.trimToNull((String)this.req.getParameter("id"));
    }

    public String cancel() throws Exception {
        return "cancel";
    }

    public void setCancel(String cancel) {
        this.cancel = StringUtils.trimToNull((String)cancel) != null;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setServletRequest(HttpServletRequest req) {
        this.req = req;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
        if (session.isEmpty()) {
            session.put("-", true);
        }
    }

    protected boolean stringEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 != null) {
            return o1.toString().equals(o2.toString());
        }
        return false;
    }

    public Ipt getRegisteredIpt() {
        return this.registrationManager.getIpt();
    }

    @Nullable
    public Organisation getDefaultOrganisation() {
        return this.registrationManager.get(Constants.DEFAULT_ORG_KEY);
    }
}

