/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action;

import at.favre.lib.crypto.bcrypt.BCrypt;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.action.POSTAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.User;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.service.admin.UserAccountManager;
import org.gbif.ipt.struts2.SimpleTextProvider;
import org.gbif.ipt.validation.UserValidator;

public class AccountAction
extends POSTAction {
    private static final Logger LOG = LogManager.getLogger(AccountAction.class);
    private static final long serialVersionUID = 5092204508303815778L;
    private final UserAccountManager userManager;
    private final UserValidator validator = new UserValidator();
    private String email;
    private User user;
    private String newPassword;
    private String password2;
    private String currentPassword;
    private User currentUser;

    @Inject
    public AccountAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager, UserAccountManager userManager) {
        super(textProvider, cfg, registrationManager);
        this.userManager = userManager;
    }

    public String execute() throws Exception {
        if (this.user == null) {
            return "login";
        }
        return super.execute();
    }

    public void prepare() {
        super.prepare();
        try {
            if (this.getCurrentUser() != null) {
                this.currentUser = this.getCurrentUser();
                this.user = (User)this.currentUser.clone();
                this.email = this.user.getEmail();
            }
        }
        catch (CloneNotSupportedException e) {
            LOG.error("Failed to clone current user: " + e.getMessage(), (Throwable)e);
        }
    }

    public String save() {
        try {
            if (this.validator.validate((BaseAction)this, this.user, false)) {
                this.currentUser.setLastname(this.user.getLastname());
                this.currentUser.setFirstname(this.user.getFirstname());
                this.addActionMessage(this.getText("admin.user.account.updated"));
                LOG.info("The user {} account has been updated", (Object)this.user.getEmail());
                this.userManager.save();
                return "success";
            }
        }
        catch (IOException e) {
            this.addActionError(this.getText("admin.user.account.saveError"));
            LOG.error("The user {} account change could not be made: " + e.getMessage(), (Object)this.user.getEmail(), (Object)e);
            this.addActionError(e.getMessage());
        }
        return "input";
    }

    public String changePassword() {
        if (this.currentUser != null) {
            String trimmedCurrentPassword = StringUtils.trimToNull((String)this.currentPassword);
            String trimmedNewPassword = StringUtils.trimToNull((String)this.newPassword);
            String trimmedNewPasswordConfirmation = StringUtils.trimToNull((String)this.password2);
            if (trimmedCurrentPassword == null) {
                this.addFieldError("currentPassword", this.getText("validation.password.reentered"));
                LOG.error("The current password entered is empty");
            } else if (trimmedNewPassword == null) {
                this.addFieldError("newPassword", this.getText("validation.password.reentered"));
                LOG.error("The new password entered is empty");
            } else if (trimmedNewPasswordConfirmation == null) {
                this.addFieldError("password2", this.getText("validation.password.reentered"));
                LOG.error("The new password confirmation entered is empty");
            } else if (!BCrypt.verifyer().verify((char[])trimmedCurrentPassword.toCharArray(), (char[])this.currentUser.getPassword().toCharArray()).verified) {
                this.addFieldError("currentPassword", this.getText("validation.password.wrong"));
                LOG.error("The password does not match");
            } else if (!trimmedNewPassword.equals(trimmedNewPasswordConfirmation)) {
                this.addFieldError("password2", this.getText("validation.password2.wrong"));
                LOG.error("The passwords entered do not match");
                this.password2 = null;
            } else if (this.validator.validatePassword((BaseAction)this, this.newPassword)) {
                this.currentUser.setPassword(BCrypt.withDefaults().hashToString(12, this.newPassword.toCharArray()));
                this.newPassword = null;
                this.currentPassword = null;
                this.password2 = null;
                this.addActionMessage(this.getText("admin.user.account.passwordChanged"));
                LOG.debug("The password has been reset");
                return "success";
            }
        }
        return "input";
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getPassword2() {
        return this.password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }
}

