/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ipt.action;

import java.util.UUID;
import javax.inject.Inject;
import org.gbif.ipt.action.BaseAction;
import org.gbif.ipt.config.AppConfig;
import org.gbif.ipt.model.Ipt;
import org.gbif.ipt.model.Organisation;
import org.gbif.ipt.service.admin.RegistrationManager;
import org.gbif.ipt.struts2.SimpleTextProvider;

public class AboutAction
extends BaseAction {
    private static final long serialVersionUID = -471175839075190159L;
    private final AppConfig cfg;
    private String title;
    private UUID iptKey;
    private String iptDescription;
    private String hostingOrganisationName;

    @Inject
    public AboutAction(SimpleTextProvider textProvider, AppConfig cfg, RegistrationManager registrationManager) {
        super(textProvider, cfg, registrationManager);
        this.cfg = cfg;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPortalUrl() {
        return this.cfg.getPortalUrl();
    }

    public void prepare() {
        Ipt ipt = this.registrationManager.getIpt();
        Organisation org = this.registrationManager.getHostingOrganisation();
        if (ipt != null) {
            this.iptKey = ipt.getKey();
            this.iptDescription = ipt.getDescription();
        }
        if (org != null) {
            this.hostingOrganisationName = org.getName();
        }
        this.title = ipt != null && ipt.getName() != null ? ipt.getName() : (this.cfg.getProperty("about.title") != null ? this.cfg.getProperty("about.title") : this.getText("about.title"));
    }

    public UUID getIptKey() {
        return this.iptKey;
    }

    public String getIptDescription() {
        return this.iptDescription;
    }

    public String getHostingOrganisationName() {
        return this.hostingOrganisationName;
    }
}

